#include <inti/main.h>
#include <inti/core.h>
#include <inti/gtk/entry.h>
#include <inti/gtk/selection.h>
#include <inti/gtk/togglebutton.h>
#include <inti/gtk/invisible.h>

using namespace Inti;

// RetrieveSelectionButton

class RetrieveSelectionButton : public Gtk::Button
{
protected:
	void on_get_target(Gtk::Entry *entry);
	virtual void on_selection_received(const Gtk::SelectionData& selection_data, unsigned int time);

public:
	RetrieveSelectionButton(Gtk::Entry *entry);
	virtual ~RetrieveSelectionButton();
};

// SupplySelectionButton

class SupplySelectionButton : public Gtk::ToggleButton
{
	static std::vector<Gtk::TargetEntry> target_entries;
	
	Gtk::Invisible *selection_widget;
	String target_string;

protected:
	virtual void on_toggled();
	void selection_get(GtkSelectionData *selection_data, unsigned int info, unsigned int time);
	bool selection_clear_event(GdkEventSelection *event);

public:
	SupplySelectionButton();
	virtual ~SupplySelectionButton();
};

// SelectionTest

class SelectionTest : public Gtk::Dialog
{
public:
	SelectionTest();
	virtual ~SelectionTest();
};

