#include "colorselection.h"
#include <inti/bind.h>

ColorSelectionWindow::ColorSelectionWindow()
{
	set_title("Color selection test");

	// Create drawing area
	area= new Gtk::DrawingArea(250, 200);

	// Set the initial background color	and events to receive
	color.set(0, 0, 65535);
	area->modify_bg(Gtk::STATE_NORMAL, &color);
	area->set_events(Gdk::BUTTON_PRESS_MASK);
	area->sig_event().connect(slot(this, &ColorSelectionWindow::on_drawing_area_event));

	// Add drawing area to main window
	add(*area);
	area->show();
	show();
}

ColorSelectionWindow::~ColorSelectionWindow()
{
}

bool
ColorSelectionWindow::on_drawing_area_event(GdkEvent *event)
{
	bool handled = false;

	if (event->type == GDK_BUTTON_PRESS)
	{
		handled = true;
		Gtk::ColorSelectionDialog *dialog = new Gtk::ColorSelectionDialog("Select background color");
		Gtk::ColorSelection *colorsel = dialog->colorsel();
		colorsel->set_previous_color(color);
		colorsel->set_current_color(color);
		colorsel->set_has_palette(true);

		// Connect to the "color_changed" signal
		colorsel->sig_color_changed().connect(bind(slot(this, &ColorSelectionWindow::on_color_changed), colorsel));

		// Show the dialog
		if (dialog->run() == Gtk::RESPONSE_OK)
			color =	colorsel->get_current_color();
		else
 			area->modify_bg(Gtk::STATE_NORMAL, &color);

		dialog->dispose();
	}
	return handled;
}

void
ColorSelectionWindow::on_color_changed(Gtk::ColorSelection *colorsel)
{
	Gdk::Color new_color = colorsel->get_current_color();
	area->modify_bg(Gtk::STATE_NORMAL, &new_color);
}

int main (int argc, char *argv[])
{
	using namespace Main;

	init(&argc, &argv);

	ColorSelectionWindow window;
	window.sig_destroy().connect(slot(&Inti::Main::quit));

	run();
	return 0;
}
