/***************************************************************************
                         ccallback.cpp  -  description
                             -------------------
    begin                : Thu Aug 1 2002
    copyright            : (C) 2002-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <dclib/dcos.h>
#include <dclib/core/clist.h>

#include "ccallback.h"

/** */
CCallbackList::CCallbackList()
{
	m_pCallbackList = new CThreadList<_CCallback>;
}

/** */
CCallbackList::~CCallbackList()
{
	m_pCallbackList->Lock();
	m_pCallbackList->Clear();
	m_pCallbackList->UnLock();
	delete m_pCallbackList;
	m_pCallbackList = 0;
}

/** */
void CCallbackList::AddCallback( _CCallback * callback )
{
	m_pCallbackList->Lock();
	m_pCallbackList->Add(callback);
	m_pCallbackList->UnLock();
}

/** */
void CCallbackList::DelCallback( _CCallback * callback )
{
	m_pCallbackList->Lock();
	m_pCallbackList->Del(callback);
	m_pCallbackList->UnLock();
}

/** */
int CCallbackList::notify( CObject * sender, CObject * object )
{
	int i=0;
	_CCallback * callback = 0;

	m_pCallbackList->Lock();
	while( (callback=m_pCallbackList->Next(callback)) != 0 )
		if ( callback->notify(sender,object) == 0 )
			i++;
	m_pCallbackList->UnLock();
	return i;
}

