/***************************************************************************
                          cclientssl.h  -  description
                             -------------------
    begin                : Sat Dec 7 2002
    copyright            : (C) 2002-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CCLIENTSSL_H
#define CCLIENTSSL_H

/**
  *@author Mathias Kster
  */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <dclib/dcos.h>
#include <dclib/core/cssl.h>

class CClient;

class DLL_EXPORT CClientSSL : public CSSL {
public:
	/** */
	CClientSSL();
	/** */
	virtual ~CClientSSL();

	/** */
	void PrivateChat( CClient * client, CMessagePrivateChat * msg );

#ifdef HAVE_SSL
	/** */
	void Init();
	/** */
	CString EncryptMessage( CClient * client, CString nick, CString message );
	/** */
	void JoinHub( CClient * client, CString nick );
	/** */
	void LeaveHub( CClient * client, CString nick );
#endif

private:
	/** */
	CStringList * m_pCryptPrivateMessageList;
};

#endif
