
/*  A Bison parser, made from aux-item-def-parse.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define YYLSP_NEEDED

#define	NUMBER	257
#define	BOOLEAN	258
#define	ID	259
#define	STRING	260
#define	DISABLED	261
#define	TEXT	262
#define	CONFERENCE	263
#define	LETTERBOX	264
#define	TOK_SERVER	265
#define	TOK_ANY	266
#define	VOID	267
#define	CREATE	268
#define	MODIFY	269

#line 1 "aux-item-def-parse.y"

/*
 * $Id: aux-item-def-parse.y,v 1.12 2001/09/30 16:52:02 ceder Exp $
 * Copyright (C) 1994-1996, 1999, 2001  Lysator Academic Computer Association.
 *
 * This file is part of the LysKOM server.
 * 
 * LysKOM is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 1, or (at your option) 
 * any later version.
 * 
 * LysKOM is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with LysKOM; see the file COPYING.  If not, write to
 * Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
 * or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
 * MA 02139, USA.
 *
 * Please mail bug reports to bug-lyskom@lysator.liu.se. 
 */

/* Rename hack from the automake 1.4 manual. */

#define	yymaxdepth aid_maxdepth
#define	yyparse	aid_parse
#define	yylex	aid_lex
#define	yyerror	aid_error
#define	yylval	aid_lval
#define	yychar	aid_char
#define	yydebug	aid_debug
#define	yypact	aid_pact
#define	yyr1	aid_r1
#define	yyr2	aid_r2
#define	yydef	aid_def
#define	yychk	aid_chk
#define	yypgo	aid_pgo
#define	yyact	aid_act
#define	yyexca	aid_exca
#define yyerrflag aid_errflag
#define yynerrs	aid_nerrs
#define	yyps	aid_ps
#define	yypv	aid_pv
#define	yys	aid_s
#define	yy_yys	aid_yys
#define	yystate	aid_state
#define	yytmp	aid_tmp
#define	yyv	aid_v
#define	yy_yyv	aid_yyv
#define	yyval	aid_val
#define	yylloc	aid_lloc
#define yyreds	aid_reds
#define yytoks	aid_toks
#define yylhs	aid_yylhs
#define yylen	aid_yylen
#define yydefred aid_yydefred
#define yydgoto	aid_yydgoto
#define yysindex aid_yysindex
#define yyrindex aid_yyrindex
#define yygindex aid_yygindex
#define yytable	 aid_yytable
#define yycheck	 aid_yycheck
#define yyname   aid_yyname
#define yyrule   aid_yyrule

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifdef HAVE_STRING_H
# include <string.h>
#endif
#if STDC_HEADERS || HAVE_STRING_H
#  include <string.h>
#else
#  include <strings.h>
#endif
#ifdef HAVE_STDARG_H
#  include <stdarg.h>
#endif
#include <malloc.h>
#include <setjmp.h>

#include "kom-types.h"
#include "com.h"
#include "async.h"
#include "connections.h"
#include "aux-items.h"
#include "s-string.h"
#include "server/smalloc.h"
#include "lyskomd.h"
#include "debug.h"
#include "log.h"
#include "string-malloc.h"

BUGDECL;    

#define YYDEBUG 1
    
static Aux_item_definition      def;
static Bool                     errorFlag = FALSE;

#define CHK_ASSIGN(_i_, _f_, _t_, _d_, _e_, _l_) \
        found = found || aux_item_def_check_assign(_i_,_d_,&def._f_,_t_,&(_e_),_l_)

#define CHK_FLAG_A(_i_, _f_, _d_, _e_, _l_) \
        if (!s_strcmp(s_fcrea_str(_i_),_d_)) \
        { \
            found = 1; \
            if (_e_.type != BOOLEAN ) \
            { \
                  aux_item_def_error_line = _l_; \
                yyerror("invalid type: expected %s, got %s", \
                        aux_item_def_typename(BOOLEAN), \
                        aux_item_def_typename(_e_.type)); \
            } \
            if (_e_.val.num) { def.set_flags._f_ = 1; } \
            else { def.clear_flags._f_ = 1; } \
        } 


extern int yylex(void);

static char *inputFile;
int aux_item_def_error_line;
extern int yylineno;

#if defined(HAVE_VFPRINTF) && defined(HAVE_STDARG_H)
void yyerror(const char * format, ...)
#  if HAVE_ATTRIBUTE_FORMAT_PRINTF
    __attribute__ ((format (printf, 1, 2)))
#  endif
    ;
#else
void yyerror();
#endif

struct aux_item_def_value_type;
static int  aux_item_def_check_assign(const char  *,
                                      String,
                                      void  *,
                                      int,
                                      struct aux_item_def_value_type *,
                                      int);
static const char *aux_item_def_typename(int);
static
short aux_item_def_check_trigger(const char *check_name,
                                 int type,
                                 String trigger_name,
                                 String function_name,
                                 unsigned long *counter,
                                 Aux_item_trigger **triggers);

static
short aux_item_def_check_validate(const char *check_name,
                                  String field_name,
                                  int type,
                                  String data,
                                  Aux_item_definition *def);


#define YYERROR_VERBOSE

#line 169 "aux-item-def-parse.y"
typedef union
{
    String          str;
    unsigned long   num;
    struct aux_item_def_value_type
    {
        int         type;
        union
        {
            String          str;
            unsigned long   num;
        } val;
    } value;
} YYSTYPE;

#ifndef YYLTYPE
typedef
  struct yyltype
    {
      int timestamp;
      int first_line;
      int first_column;
      int last_line;
      int last_column;
      char *text;
   }
  yyltype;

#define YYLTYPE yyltype
#endif

#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		39
#define	YYFLAG		-32768
#define	YYNTBASE	24

#define YYTRANSLATE(x) ((unsigned)(x) <= 269 ? yytranslate[x] : 33)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,    19,
    20,     2,     2,    21,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    18,    23,     2,
    22,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    16,     2,    17,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     3,     4,     9,    16,    24,    28,    30,    33,    36,
    39,    41,    44,    47,    50,    51,    54,    57,    58,    63,
    65,    67,    69,    73
};

static const short yyrhs[] = {    24,
    25,     0,     0,    26,    16,    30,    17,     0,     3,    18,
     5,    19,    27,    20,     0,     3,    18,     5,    19,    27,
    20,     7,     0,    27,    21,    28,     0,    28,     0,    29,
     8,     0,    29,     9,     0,    29,    10,     0,    11,     0,
    29,    12,     0,    29,    14,     0,    29,    15,     0,     0,
    30,    31,     0,    30,     1,     0,     0,     5,    22,    32,
    23,     0,     4,     0,     6,     0,     3,     0,     5,    19,
    20,     0,    13,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   194,   195,   198,   208,   221,   232,   233,   236,   237,   238,
   240,   241,   250,   251,   252,   254,   255,   256,   259,   343,
   344,   345,   346,   347
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","NUMBER",
"BOOLEAN","ID","STRING","DISABLED","TEXT","CONFERENCE","LETTERBOX","TOK_SERVER",
"TOK_ANY","VOID","CREATE","MODIFY","'{'","'}'","':'","'('","')'","','","'='",
"';'","items","item","head","targets","target","action","body","assign","value", NULL
};
#endif

static const short yyr1[] = {     0,
    24,    24,    25,    26,    26,    27,    27,    28,    28,    28,
    28,    28,    29,    29,    29,    30,    30,    30,    31,    32,
    32,    32,    32,    32
};

static const short yyr2[] = {     0,
     2,     0,     4,     6,     7,     3,     1,     2,     2,     2,
     1,     2,     2,     2,     0,     2,     2,     0,     4,     1,
     1,     1,     3,     1
};

static const short yydefact[] = {     2,
     0,     0,     1,     0,     0,    18,     0,     0,    15,    17,
     0,     3,    16,    11,     0,     7,     0,     0,     4,    15,
     8,     9,    10,    12,    13,    14,    22,    20,     0,    21,
    24,     0,     5,     6,     0,    19,    23,     0,     0
};

static const short yydefgoto[] = {     1,
     3,     4,    15,    16,    17,     8,    13,    32
};

static const short yypact[] = {-32768,
    10,   -15,-32768,    -7,     6,-32768,    -5,    -1,     1,-32768,
    -2,-32768,-32768,-32768,   -19,-32768,     9,     2,    15,     1,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,     7,-32768,
-32768,     4,-32768,-32768,     5,-32768,-32768,    28,-32768
};

static const short yypgoto[] = {-32768,
-32768,-32768,-32768,    11,-32768,-32768,-32768,-32768
};


#define	YYLAST		31


static const short yytable[] = {    10,
    19,    20,     5,    11,    27,    28,    29,    30,     6,    38,
     7,    14,     2,     9,    31,    12,    21,    22,    23,    18,
    24,    33,    25,    26,    37,    35,    36,    39,     0,     0,
    34
};

static const short yycheck[] = {     1,
    20,    21,    18,     5,     3,     4,     5,     6,    16,     0,
     5,    11,     3,    19,    13,    17,     8,     9,    10,    22,
    12,     7,    14,    15,    20,    19,    23,     0,    -1,    -1,
    20
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/share/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 3:
#line 199 "aux-item-def-parse.y"
{
                if (def.tag != 0)
                {
                    aux_item_definition_add(&def);
                }
                def = empty_aux_item_definition;
            ;
    break;}
case 4:
#line 209 "aux-item-def-parse.y"
{
                def.tag = yyvsp[-5].num;
                def.name = s_crea_c_str(yyvsp[-3].str);
                if (buglevel)
                {
                    kom_log("Parsing definition of aux-iem %ld (%s)\n",
                            def.tag, def.name);
                }
                s_clear(&(yyvsp[-3].str));
                yyvsp[-3].str = EMPTY_STRING;
                yylval.str = EMPTY_STRING;
            ;
    break;}
case 5:
#line 222 "aux-item-def-parse.y"
{
                def.tag = yyvsp[-6].num;
                def.name = s_crea_c_str(yyvsp[-4].str);
                def.disabled = TRUE;
                s_clear(&(yyvsp[-4].str));
                yyvsp[-4].str = EMPTY_STRING;
                yylval.str = EMPTY_STRING;
            ;
    break;}
case 8:
#line 236 "aux-item-def-parse.y"
{ def.texts = TRUE; def.text_a = yyvsp[-1].num; ;
    break;}
case 9:
#line 237 "aux-item-def-parse.y"
{ def.confs = TRUE; def.conf_a = yyvsp[-1].num; ;
    break;}
case 10:
#line 238 "aux-item-def-parse.y"
{ def.letterboxes = TRUE;
                                        def.conf_a = yyvsp[-1].num; ;
    break;}
case 11:
#line 240 "aux-item-def-parse.y"
{ def.system = TRUE; ;
    break;}
case 12:
#line 242 "aux-item-def-parse.y"
{
                def.texts       = TRUE; def.text_a = yyvsp[-1].num;
                def.confs       = TRUE; def.conf_a = yyvsp[-1].num;
                def.letterboxes = TRUE; 
                def.system      = TRUE;
            ;
    break;}
case 13:
#line 250 "aux-item-def-parse.y"
{ yyval.num = yyvsp[-1].num | AUX_ITEM_ADD_ON_CREATE; ;
    break;}
case 14:
#line 251 "aux-item-def-parse.y"
{ yyval.num = yyvsp[-1].num | AUX_ITEM_ADD_ON_MODIFY; ;
    break;}
case 15:
#line 252 "aux-item-def-parse.y"
{ yyval.num = 0; ;
    break;}
case 19:
#line 260 "aux-item-def-parse.y"
{
                int found = 0;

                CHK_ASSIGN("author-only", author_only, BOOLEAN,
                           yyvsp[-3].str, yyvsp[-1].value, yylsp[-1].first_line);
                CHK_ASSIGN("supervisor-only", supervisor_only,
                           BOOLEAN, yyvsp[-3].str, yyvsp[-1].value, yylsp[-1].first_line);
                CHK_ASSIGN("system-only", system_only,
                           BOOLEAN, yyvsp[-3].str, yyvsp[-1].value, yylsp[-1].first_line);
                CHK_ASSIGN("inherit-limit", inherit_limit, NUMBER,
                           yyvsp[-3].str, yyvsp[-1].value, yylsp[-1].first_line);
                CHK_ASSIGN("unique", one_per_person, BOOLEAN,
                           yyvsp[-3].str, yyvsp[-1].value, yylsp[-1].first_line);
                CHK_ASSIGN("permanent", may_not_delete, BOOLEAN,
                           yyvsp[-3].str, yyvsp[-1].value, yylsp[-1].first_line);
                CHK_ASSIGN("owner-delete", owner_delete, BOOLEAN,
                           yyvsp[-3].str, yyvsp[-1].value, yylsp[-1].first_line);
                CHK_FLAG_A("inherit", inherit, yyvsp[-3].str, yyvsp[-1].value, yylsp[-1].first_line);
                CHK_FLAG_A("secret", secret, yyvsp[-3].str, yyvsp[-1].value, yylsp[-1].first_line);
                CHK_FLAG_A("hide-creator", hide_creator,
                           yyvsp[-3].str, yyvsp[-1].value, yylsp[-1].first_line);
                CHK_FLAG_A("dont-garb", dont_garb, yyvsp[-3].str, yyvsp[-1].value, yylsp[-1].first_line);
                CHK_FLAG_A("reserved-2", reserved3, yyvsp[-3].str, yyvsp[-1].value, yylsp[-1].first_line); 
                CHK_FLAG_A("reserved-3", reserved4, yyvsp[-3].str, yyvsp[-1].value, yylsp[-1].first_line); 
                CHK_FLAG_A("reserved-4", reserved5, yyvsp[-3].str, yyvsp[-1].value, yylsp[-1].first_line); 


                found = found ? 1 :
                    aux_item_def_check_validate("validate",
                                                yyvsp[-3].str,
                                                yyvsp[-1].value.type,
                                                yyvsp[-1].value.val.str,
                                                &def);

                found = found ? 1 :
                    aux_item_def_check_trigger("delete-trigger",
                                               yyvsp[-1].value.type,
                                               yyvsp[-3].str,
                                               yyvsp[-1].value.val.str,
                                               &def.num_delete_triggers,
                                               &def.delete_triggers);


                found = found ? 1 :
                    aux_item_def_check_trigger("undelete-trigger",
                                               yyvsp[-1].value.type,
                                               yyvsp[-3].str,
                                               yyvsp[-1].value.val.str,
                                               &def.num_undelete_triggers,
                                               &def.undelete_triggers);


                found = found ? 1 :
                    aux_item_def_check_trigger("add-trigger",
                                               yyvsp[-1].value.type,
                                               yyvsp[-3].str,
                                               yyvsp[-1].value.val.str,
                                               &def.num_add_triggers,
                                               &def.add_triggers);


                if (found == 0)
                {
                    char *tmp;

                    tmp = s_crea_c_str(yyvsp[-3].str);
                    aux_item_def_error_line = yylsp[-3].first_line;
                    yyerror("invalid field name: %s", tmp);
                    string_free(tmp);
                }

                if (yyvsp[-1].value.type == STRING || yyvsp[-1].value.type == ID)
                {
                    s_clear(&(yyvsp[-1].value).val.str);
                    yyvsp[-1].value.val.str = EMPTY_STRING;
                    yylval.value.val.str = EMPTY_STRING;
                }
                s_clear(&(yyvsp[-3].str));
                yyvsp[-3].str = EMPTY_STRING;
                yylval.str = EMPTY_STRING;
            ;
    break;}
case 20:
#line 343 "aux-item-def-parse.y"
{ yyval.value.val.num = yyvsp[0].num; yyval.value.type = BOOLEAN; ;
    break;}
case 21:
#line 344 "aux-item-def-parse.y"
{ yyval.value.val.str = yyvsp[0].str; yyval.value.type = STRING;  ;
    break;}
case 22:
#line 345 "aux-item-def-parse.y"
{ yyval.value.val.num = yyvsp[0].num; yyval.value.type = NUMBER;  ;
    break;}
case 23:
#line 346 "aux-item-def-parse.y"
{ yyval.value.val.str = yyvsp[-2].str; yyval.value.type = ID;;
    break;}
case 24:
#line 347 "aux-item-def-parse.y"
{ YYERROR; ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/share/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 350 "aux-item-def-parse.y"


extern FILE *yyin;

#if defined(HAVE_VFPRINTF) && defined(HAVE_STDARG_H)
void yyerror(const char *format, ...)
{
    va_list     AP;

    va_start(AP, format);
    fprintf(stderr, "%s: %d: ", inputFile, aux_item_def_error_line);
    vfprintf(stderr, format, AP);
    fprintf(stderr, "\n");
    fflush(stderr);

    errorFlag = TRUE;
    va_end(AP);
}
#else
void yyerror(const char *s, 
             int a, int b, int c, int d, int e, int f, int g)
{
    fprintf(stderr, "%s: %d: ",  inputFile, aux_item_def_error_line);
    fprintf(stderr, format, a, b, c, d, e, f, g);
    fprintf(stderr, "\n");
    fflush(stderr);

    errorFlag = TRUE;
}
#endif

static const char *aux_item_def_typename(int type)
{
    switch (type)
    {
    case STRING:  return "string";
    case NUMBER:  return "number";
    case BOOLEAN: return "boolean";
    case ID:      return "identifier";
    default:
        return "unknown";
    }
}

static int  aux_item_def_check_assign(const char  *id,
                                      String field,
                                      void  *data,
                                      int    type,
                                      struct aux_item_def_value_type *val,
                                      int    lineno)
{
    if (!s_strcmp(s_fcrea_str(id), field))
    {
        if (type != val->type)
        {
            aux_item_def_error_line = lineno;
            yyerror("invalid type: expected %s, got %s",
                     aux_item_def_typename(type),
                     aux_item_def_typename(val->type));
            return 0;
        }
        else if (type == STRING)
        {
            *((char **)data) = s_crea_c_str(val->val.str);
        }
        else if (type == NUMBER)
        {
            *((unsigned long *)data) = val->val.num;
        }
        else if (type == BOOLEAN)
        {
            *((Bool *)data) = val->val.num ? TRUE : FALSE;
        }
        else
        {
            restart_kom("Internal error: bad type in aux-item definition "
                        "assignment (can't happen.)\n");
        }
        return 1;
    }
    else
    {
        return 0;
    }
}

static short aux_item_def_check_trigger(const char *check_name,
					int type,
					String trigger_name,
					String function_name,
					unsigned long *counter,
					Aux_item_trigger **triggers)
{
    Aux_item_trigger trigger;
    char *tmp_string;

    if (s_strcmp(s_fcrea_str(check_name), trigger_name) == 0)
    {
        if (type != ID)
        {
            yyerror("invalid type: expected %s, got %s", 
                    aux_item_def_typename(ID), 
                    aux_item_def_typename(type)); 
            return 0;
        }

        tmp_string = s_crea_c_str(function_name);
        trigger = aux_item_find_trigger(tmp_string);
        string_free(tmp_string);

        if (trigger == NULL)
        {
            yyerror("undefined function: %s",
                    tmp_string);
            return 1;
        }

        *counter += 1;
        *triggers =
            srealloc(*triggers,
                     *counter *
                     sizeof(Aux_item_trigger));
        *triggers[*counter-1] = trigger;

        return 1;
    }
    return 0;
}

void parse_aux_item_definitions(char *file)
{
    inputFile = file;
    yyin = fopen(file, "r");
    if (yyin == NULL)
    {
        perror(file);
        restart_kom("Unable to open aux-item definition file\n");
    }

    def = empty_aux_item_definition;
    yyparse();
    fclose(yyin);

    if (errorFlag == TRUE)
    {
        restart_kom("Errors reading aux-item definition file\n");
    }

    /*
      {
        extern Aux_item_definition *aux_item_definition_list;
        extern unsigned long num_aux_item_definitions;
        Aux_item_definition *def;

        fprintf(stderr, "Number of defs: %ld\n", num_aux_item_definitions);
        def = aux_item_definition_list;

        while (def != NULL)
        {
            fprintf(stderr, "Name:            '%s'\n", def->name);
            fprintf(stderr, "Tag:             %ld\n", def->tag);
            fprintf(stderr, "Clear flags:     ");
            if (def->clear_flags.deleted) fprintf(stderr, "deleted ");
            if (def->clear_flags.inherit) fprintf(stderr, "inherit ");
            if (def->clear_flags.secret) fprintf(stderr, "secret ");
            if (def->clear_flags.hide_creator) fprintf(stderr,"hide_creator ");
            if (def->clear_flags.reserved2) fprintf(stderr, "reserved2 ");
            if (def->clear_flags.reserved3) fprintf(stderr, "reserved3 ");
            if (def->clear_flags.reserved4) fprintf(stderr, "reserved4 ");
            if (def->clear_flags.reserved5) fprintf(stderr, "reserved5 ");
            fprintf(stderr, "\n");
            fprintf(stderr, "Set flags:       ");
            if (def->set_flags.deleted) fprintf(stderr, "deleted ");
            if (def->set_flags.inherit) fprintf(stderr, "inherit ");
            if (def->set_flags.secret) fprintf(stderr, "secret ");
            if (def->set_flags.hide_creator) fprintf(stderr,"hide_creator ");
            if (def->set_flags.reserved2) fprintf(stderr, "reserved2 ");
            if (def->set_flags.reserved3) fprintf(stderr, "reserved3 ");
            if (def->set_flags.reserved4) fprintf(stderr, "reserved4 ");
            if (def->set_flags.reserved5) fprintf(stderr, "reserved5 ");
            fprintf(stderr, "\n");
            fprintf(stderr, "Author only:     %d\n", def->author_only);
            fprintf(stderr, "Supervisor only: %d\n", def->supervisor_only);
            fprintf(stderr, "Unique:          %d\n", def->one_per_person);
            fprintf(stderr, "Permanent:       %d\n", def->may_not_delete);
            fprintf(stderr, "Inherit limit:   %ld\n", def->inherit_limit);
            fprintf(stderr, "Texts:           %d\n", def->texts);
            fprintf(stderr, "Conferences:     %d\n", def->confs);
            fprintf(stderr, "Letterboxes:     %d\n", def->letterboxes);
            fprintf(stderr, "Validate regexp: '%s'\n",
                    def->validate_regexp?def->validate_regexp:"0x0");
            def = def->next;
        }
    }
    */
}


static short aux_item_def_check_validate(const char *check_name,
					 String field_name,
					 int type,
					 String data,
					 Aux_item_definition *def)
{
    Aux_item_validation_function        validator;
    char                               *tmp_string;

    if (s_strcmp(s_fcrea_str(check_name), field_name) == 0)
    {
        /*
         * Validator is a function
         */

        if (type == ID)
        {
            tmp_string = s_crea_c_str(data);
            validator = aux_item_find_validator(tmp_string);
            string_free(tmp_string);

            if (validator == NULL)
            {
                yyerror("undefined function: %s",
                        tmp_string);
                return 1;
            }

            def->num_validators += 1;
            def->validators = srealloc(def->validators,
                                       def->num_validators *
                                       sizeof(*def->validators));

            def->validators[def->num_validators-1].type = AUX_VALIDATE_FUNCTION;
            def->validators[def->num_validators-1].v.fn.function = validator;

            return 1;
            
        }
        else if (type == STRING)
        {
            /*
             * Validator is a string (regexp)
             */

            def->num_validators += 1;
            def->validators = srealloc(def->validators,
                                       def->num_validators *
                                       sizeof(*def->validators));


            def->validators[def->num_validators-1].type = AUX_VALIDATE_REGEXP;
            def->validators[def->num_validators-1].v.re.regexp = s_crea_c_str(data);
            def->validators[def->num_validators-1].v.re.cached_re_buf = NULL;
        }
        else
        {
            yyerror("invalid type: expected %s or %s, got %s", 
                    aux_item_def_typename(ID), 
                    aux_item_def_typename(STRING), 
                    aux_item_def_typename(type)); 
            return 0;
        }

        return 1;
    }
    return 0;
}
