/* (C) Marcin Kwadrans <quar@vitea.pl> */

#include "include/support.h"
#include "include/pixmapset.h"

static void delete_pixmap (LWPixmap *pixmap)
{
	delete pixmap;
}

/*! \brief Konstruktor

	Tworzy zbiór ikon
*/
LWPixmapSet::LWPixmapSet ()
{
	g_datalist_init (&datalist);
}

/*! \brief Destruktor

	Niszczy zbiór ikon
*/	
LWPixmapSet::~LWPixmapSet ()
{
	g_datalist_clear (&datalist);
}

/*! \brief Dodanie ikony do zbioru

	Dadaje ikonę do zbioru
	\param pixmap Dodawana ikona
*/	
void LWPixmapSet::addPixmap (LWPixmap *pixmap)
{
	g_datalist_set_data_full (&datalist, 
								pixmap->getName(), 
								(gpointer) pixmap,
								(GDestroyNotify) delete_pixmap);
}

/*! \brief Odtwarzanie zbioru ikon z drzewa XML

	Odtwarza zbiór ikon na podstawie opisu zawartego w drzewie XML
	\param node Drzewo na podstawie którego zostanie dokonana rekonstrukcja
*/
void LWPixmapSet::restoreFromXML (xmlNode *node)
{
	g_return_if_fail (!xmlStrcasecmp (node->name, (xmlChar *) "PixmapSet"));
	
	for (xmlNode *n=node->children; n != NULL; n=n->next) {
		LWPixmap *pixmap = new LWPixmap ();
		pixmap->restoreFromXML (n);
		addPixmap (pixmap);
	}
	
}

/*! \brief Pobranie ikony

	Pobiera ikonę ze zbioru na podstawie jej nazwy
	\name Nazwa ikony
*/
LWPixmap *LWPixmapSet::getPixmap (const gchar *name)
{
	g_return_val_if_fail (name != NULL, NULL);
	
	return (LWPixmap *) g_datalist_get_data (&datalist, name);
}
