/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Gerben Venekamp <venekamp@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
    \file   _lcmaps_db_read.h
    \brief  Internal header file of LCMAPS database reader
    \author Martijn Steenbakkers for the EU DataGrid.

    This header contains the declarations of the LCMAPS database reader
    functions and typedefs.

    \internal
*/

#ifndef _LCMAPS_DB_READ_H
#define _LCMAPS_DB_READ_H

/******************************************************************************
                             Include header files
******************************************************************************/
#include "lcmaps_db_read.h"
/* #include "_lcmaps_defines.h" */

/******************************************************************************
 *                             Module definition
 *****************************************************************************/
extern lcmaps_db_entry_t * lcmaps_db_fill_entry(
        lcmaps_db_entry_t ** plcmaps_db,
        lcmaps_db_entry_t *  db_entry
);

extern lcmaps_db_entry_t ** lcmaps_db_read(
        char * lcmaps_db_fname
);

extern int lcmaps_db_clean_list(
        lcmaps_db_entry_t ** list
);

extern int lcmaps_db_clean(void);

#endif /* _LCMAPS_DB_READ_H */

/******************************************************************************
CVS Information:
    $Source: /srv/home/dennisvd/svn/mw-security/lcmaps/src/pluginmanager/_lcmaps_db_read.h,v $
    $Date: 2011-12-13 12:06:42 +0100 (Tue, 13 Dec 2011) $
    $Revision: 15701 $
    $Author: okoeroo $
******************************************************************************/
