/*
    This file is part of KitchenSync.

    Copyright (c) 2004 Tobias Koenig <tokoe@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef KONNECTORPAIRMANAGER_H
#define KONNECTORPAIRMANAGER_H

#include <qobject.h>

#include "konnectorpair.h"

class KonnectorPairManager : public QObject
{
  Q_OBJECT

  public:
    KonnectorPairManager( QObject *parent );
    ~KonnectorPairManager();

    void load();
    void save();

    void add( KonnectorPair *pair );
    void change( KonnectorPair *pair );
    void remove( const QString &uid );

    KonnectorPair* pair( const QString &uid ) const;
    KonnectorPair::List pairs() const;

  signals:
    void changed();

  private:
    QString configFile() const;

    KonnectorPair::Map mPairs;
};

#endif
