// From https://github.com/darobin/webidl.js/tree/, under MIT license
window.WebIDLParser = (function(){
  /*
   * Generated by PEG.js 0.7.0.
   *
   * http://pegjs.majda.cz/
   */
  
  function quote(s) {
    /*
     * ECMA-262, 5th ed., 7.8.4: All characters may appear literally in a
     * string literal except for the closing quote character, backslash,
     * carriage return, line separator, paragraph separator, and line feed.
     * Any character may appear in the form of an escape sequence.
     *
     * For portability, we also escape escape all control and non-ASCII
     * characters. Note that "\0" and "\v" escape sequences are not used
     * because JSHint does not like the first and IE the second.
     */
     return '"' + s
      .replace(/\\/g, '\\\\')  // backslash
      .replace(/"/g, '\\"')    // closing quote character
      .replace(/\x08/g, '\\b') // backspace
      .replace(/\t/g, '\\t')   // horizontal tab
      .replace(/\n/g, '\\n')   // line feed
      .replace(/\f/g, '\\f')   // form feed
      .replace(/\r/g, '\\r')   // carriage return
      .replace(/[\x00-\x07\x0B\x0E-\x1F\x80-\uFFFF]/g, escape)
      + '"';
  }
  
  var result = {
    /*
     * Parses the input with a generated parser. If the parsing is successfull,
     * returns a value explicitly or implicitly specified by the grammar from
     * which the parser was generated (see |PEG.buildParser|). If the parsing is
     * unsuccessful, throws |PEG.parser.SyntaxError| describing the error.
     */
    parse: function(input, startRule) {
      var parseFunctions = {
        "space": parse_space,
        "s": parse_s,
        "w": parse_w,
        "identifier": parse_identifier,
        "octal": parse_octal,
        "hex": parse_hex,
        "decimal": parse_decimal,
        "integer": parse_integer,
        "floatEe": parse_floatEe,
        "expFloat": parse_expFloat,
        "leadFloat": parse_leadFloat,
        "dotFloat": parse_dotFloat,
        "float": parse_float,
        "string": parse_string,
        "other": parse_other,
        "type": parse_type,
        "TypeDesc": parse_TypeDesc,
        "Sequence": parse_Sequence,
        "ArrayType": parse_ArrayType,
        "UnionType": parse_UnionType,
        "TypeList": parse_TypeList,
        "TypeListRest": parse_TypeListRest,
        "SimpleType": parse_SimpleType,
        "PrimitiveType": parse_PrimitiveType,
        "FloatType": parse_FloatType,
        "UnsignedIntegerType": parse_UnsignedIntegerType,
        "ScopedNameList": parse_ScopedNameList,
        "ScopedNameListRest": parse_ScopedNameListRest,
        "ScopedName": parse_ScopedName,
        "AbsoluteScopedName": parse_AbsoluteScopedName,
        "RelativeScopedName": parse_RelativeScopedName,
        "ScopedNameRest": parse_ScopedNameRest,
        "BooleanLiteral": parse_BooleanLiteral,
        "Nullable": parse_Nullable,
        "ReturnType": parse_ReturnType,
        "definitions": parse_definitions,
        "definition": parse_definition,
        "partialinterface": parse_partialinterface,
        "partialdictionary": parse_partialdictionary,
        "callbackinterface": parse_callbackinterface,
        "module": parse_module,
        "implements": parse_implements,
        "interface": parse_interface,
        "enum": parse_enum,
        "callback": parse_callback,
        "EnumValues": parse_EnumValues,
        "EnumValuesRest": parse_EnumValuesRest,
        "Inheritance": parse_Inheritance,
        "InheritanceInner": parse_InheritanceInner,
        "InterfaceMemberList": parse_InterfaceMemberList,
        "InterfaceMember": parse_InterfaceMember,
        "const": parse_const,
        "constExpr": parse_constExpr,
        "attrOrOp": parse_attrOrOp,
        "Stringifier": parse_Stringifier,
        "Attribute": parse_Attribute,
        "GetRaises": parse_GetRaises,
        "SetRaises": parse_SetRaises,
        "Operation": parse_Operation,
        "Qualifiers": parse_Qualifiers,
        "Special": parse_Special,
        "OperationRest": parse_OperationRest,
        "Arguments": parse_Arguments,
        "ArgumentsRest": parse_ArgumentsRest,
        "Argument": parse_Argument,
        "Raises": parse_Raises,
        "dictionary": parse_dictionary,
        "DictionaryMemberList": parse_DictionaryMemberList,
        "DictionaryMember": parse_DictionaryMember,
        "defaultValue": parse_defaultValue,
        "typedef": parse_typedef,
        "exception": parse_exception,
        "ExceptionMembers": parse_ExceptionMembers,
        "ExceptionMember": parse_ExceptionMember,
        "field": parse_field,
        "ExtendedAttributeList": parse_ExtendedAttributeList,
        "ExtendedAttributeListInner": parse_ExtendedAttributeListInner,
        "ExtAttrs": parse_ExtAttrs,
        "ExtAttrsRest": parse_ExtAttrsRest,
        "ExtAttr": parse_ExtAttr,
        "ExtAttrNoArg": parse_ExtAttrNoArg,
        "ExtAttrNameValue": parse_ExtAttrNameValue,
        "ExtAttrNamedArgList": parse_ExtAttrNamedArgList,
        "ExtAttrNamedArgList": parse_ExtAttrNamedArgList,
        "ExtAttrArgList": parse_ExtAttrArgList
      };
      
      if (startRule !== undefined) {
        if (parseFunctions[startRule] === undefined) {
          throw new Error("Invalid rule name: " + quote(startRule) + ".");
        }
      } else {
        startRule = "definitions";
      }
      
      var pos = 0;
      var reportFailures = 0;
      var rightmostFailuresPos = 0;
      var rightmostFailuresExpected = [];
      
      function padLeft(input, padding, length) {
        var result = input;
        
        var padLength = length - input.length;
        for (var i = 0; i < padLength; i++) {
          result = padding + result;
        }
        
        return result;
      }
      
      function escape(ch) {
        var charCode = ch.charCodeAt(0);
        var escapeChar;
        var length;
        
        if (charCode <= 0xFF) {
          escapeChar = 'x';
          length = 2;
        } else {
          escapeChar = 'u';
          length = 4;
        }
        
        return '\\' + escapeChar + padLeft(charCode.toString(16).toUpperCase(), '0', length);
      }
      
      function matchFailed(failure) {
        if (pos < rightmostFailuresPos) {
          return;
        }
        
        if (pos > rightmostFailuresPos) {
          rightmostFailuresPos = pos;
          rightmostFailuresExpected = [];
        }
        
        rightmostFailuresExpected.push(failure);
      }
      
      function parse_space() {
        var result0, result1, result2, result3;
        var pos0, pos1, pos2;
        
        if (input.charCodeAt(pos) === 32) {
          result0 = " ";
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\" \"");
          }
        }
        if (result0 === null) {
          if (input.charCodeAt(pos) === 9) {
            result0 = "\t";
            pos++;
          } else {
            result0 = null;
            if (reportFailures === 0) {
              matchFailed("\"\\t\"");
            }
          }
          if (result0 === null) {
            if (input.charCodeAt(pos) === 13) {
              result0 = "\r";
              pos++;
            } else {
              result0 = null;
              if (reportFailures === 0) {
                matchFailed("\"\\r\"");
              }
            }
            if (result0 === null) {
              if (input.charCodeAt(pos) === 10) {
                result0 = "\n";
                pos++;
              } else {
                result0 = null;
                if (reportFailures === 0) {
                  matchFailed("\"\\n\"");
                }
              }
              if (result0 === null) {
                if (input.charCodeAt(pos) === 12) {
                  result0 = "\f";
                  pos++;
                } else {
                  result0 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"\\f\"");
                  }
                }
                if (result0 === null) {
                  pos0 = pos;
                  if (input.substr(pos, 2) === "//") {
                    result0 = "//";
                    pos += 2;
                  } else {
                    result0 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"//\"");
                    }
                  }
                  if (result0 !== null) {
                    result1 = [];
                    if (/^[^\n]/.test(input.charAt(pos))) {
                      result2 = input.charAt(pos);
                      pos++;
                    } else {
                      result2 = null;
                      if (reportFailures === 0) {
                        matchFailed("[^\\n]");
                      }
                    }
                    while (result2 !== null) {
                      result1.push(result2);
                      if (/^[^\n]/.test(input.charAt(pos))) {
                        result2 = input.charAt(pos);
                        pos++;
                      } else {
                        result2 = null;
                        if (reportFailures === 0) {
                          matchFailed("[^\\n]");
                        }
                      }
                    }
                    if (result1 !== null) {
                      if (input.charCodeAt(pos) === 10) {
                        result2 = "\n";
                        pos++;
                      } else {
                        result2 = null;
                        if (reportFailures === 0) {
                          matchFailed("\"\\n\"");
                        }
                      }
                      if (result2 !== null) {
                        result0 = [result0, result1, result2];
                      } else {
                        result0 = null;
                        pos = pos0;
                      }
                    } else {
                      result0 = null;
                      pos = pos0;
                    }
                  } else {
                    result0 = null;
                    pos = pos0;
                  }
                  if (result0 === null) {
                    pos0 = pos;
                    if (input.substr(pos, 2) === "/*") {
                      result0 = "/*";
                      pos += 2;
                    } else {
                      result0 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"/*\"");
                      }
                    }
                    if (result0 !== null) {
                      result1 = [];
                      if (/^[^*]/.test(input.charAt(pos))) {
                        result2 = input.charAt(pos);
                        pos++;
                      } else {
                        result2 = null;
                        if (reportFailures === 0) {
                          matchFailed("[^*]");
                        }
                      }
                      if (result2 === null) {
                        pos1 = pos;
                        if (input.charCodeAt(pos) === 42) {
                          result2 = "*";
                          pos++;
                        } else {
                          result2 = null;
                          if (reportFailures === 0) {
                            matchFailed("\"*\"");
                          }
                        }
                        if (result2 !== null) {
                          pos2 = pos;
                          reportFailures++;
                          if (input.charCodeAt(pos) === 47) {
                            result3 = "/";
                            pos++;
                          } else {
                            result3 = null;
                            if (reportFailures === 0) {
                              matchFailed("\"/\"");
                            }
                          }
                          reportFailures--;
                          if (result3 === null) {
                            result3 = "";
                          } else {
                            result3 = null;
                            pos = pos2;
                          }
                          if (result3 !== null) {
                            result2 = [result2, result3];
                          } else {
                            result2 = null;
                            pos = pos1;
                          }
                        } else {
                          result2 = null;
                          pos = pos1;
                        }
                      }
                      while (result2 !== null) {
                        result1.push(result2);
                        if (/^[^*]/.test(input.charAt(pos))) {
                          result2 = input.charAt(pos);
                          pos++;
                        } else {
                          result2 = null;
                          if (reportFailures === 0) {
                            matchFailed("[^*]");
                          }
                        }
                        if (result2 === null) {
                          pos1 = pos;
                          if (input.charCodeAt(pos) === 42) {
                            result2 = "*";
                            pos++;
                          } else {
                            result2 = null;
                            if (reportFailures === 0) {
                              matchFailed("\"*\"");
                            }
                          }
                          if (result2 !== null) {
                            pos2 = pos;
                            reportFailures++;
                            if (input.charCodeAt(pos) === 47) {
                              result3 = "/";
                              pos++;
                            } else {
                              result3 = null;
                              if (reportFailures === 0) {
                                matchFailed("\"/\"");
                              }
                            }
                            reportFailures--;
                            if (result3 === null) {
                              result3 = "";
                            } else {
                              result3 = null;
                              pos = pos2;
                            }
                            if (result3 !== null) {
                              result2 = [result2, result3];
                            } else {
                              result2 = null;
                              pos = pos1;
                            }
                          } else {
                            result2 = null;
                            pos = pos1;
                          }
                        }
                      }
                      if (result1 !== null) {
                        if (input.substr(pos, 2) === "*/") {
                          result2 = "*/";
                          pos += 2;
                        } else {
                          result2 = null;
                          if (reportFailures === 0) {
                            matchFailed("\"*/\"");
                          }
                        }
                        if (result2 !== null) {
                          result0 = [result0, result1, result2];
                        } else {
                          result0 = null;
                          pos = pos0;
                        }
                      } else {
                        result0 = null;
                        pos = pos0;
                      }
                    } else {
                      result0 = null;
                      pos = pos0;
                    }
                  }
                }
              }
            }
          }
        }
        return result0;
      }
      
      function parse_s() {
        var result0, result1;
        
        result1 = parse_space();
        if (result1 !== null) {
          result0 = [];
          while (result1 !== null) {
            result0.push(result1);
            result1 = parse_space();
          }
        } else {
          result0 = null;
        }
        return result0;
      }
      
      function parse_w() {
        var result0;
        
        result0 = parse_s();
        result0 = result0 !== null ? result0 : "";
        return result0;
      }
      
      function parse_identifier() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (/^[A-Z_a-z]/.test(input.charAt(pos))) {
          result0 = input.charAt(pos);
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("[A-Z_a-z]");
          }
        }
        if (result0 !== null) {
          result1 = [];
          if (/^[0-9A-Z_a-z]/.test(input.charAt(pos))) {
            result2 = input.charAt(pos);
            pos++;
          } else {
            result2 = null;
            if (reportFailures === 0) {
              matchFailed("[0-9A-Z_a-z]");
            }
          }
          while (result2 !== null) {
            result1.push(result2);
            if (/^[0-9A-Z_a-z]/.test(input.charAt(pos))) {
              result2 = input.charAt(pos);
              pos++;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("[0-9A-Z_a-z]");
              }
            }
          }
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, nmstart, nmchars) { return nmstart + nmchars.join(""); })(pos0, result0[0], result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_octal() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.charCodeAt(pos) === 48) {
          result0 = "0";
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"0\"");
          }
        }
        if (result0 !== null) {
          result1 = [];
          if (/^[0-7]/.test(input.charAt(pos))) {
            result2 = input.charAt(pos);
            pos++;
          } else {
            result2 = null;
            if (reportFailures === 0) {
              matchFailed("[0-7]");
            }
          }
          while (result2 !== null) {
            result1.push(result2);
            if (/^[0-7]/.test(input.charAt(pos))) {
              result2 = input.charAt(pos);
              pos++;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("[0-7]");
              }
            }
          }
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, value) { return "0" + value.join(""); })(pos0, result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_hex() {
        var result0, result1, result2, result3;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.charCodeAt(pos) === 48) {
          result0 = "0";
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"0\"");
          }
        }
        if (result0 !== null) {
          if (/^[Xx]/.test(input.charAt(pos))) {
            result1 = input.charAt(pos);
            pos++;
          } else {
            result1 = null;
            if (reportFailures === 0) {
              matchFailed("[Xx]");
            }
          }
          if (result1 !== null) {
            if (/^[0-9A-Fa-f]/.test(input.charAt(pos))) {
              result3 = input.charAt(pos);
              pos++;
            } else {
              result3 = null;
              if (reportFailures === 0) {
                matchFailed("[0-9A-Fa-f]");
              }
            }
            if (result3 !== null) {
              result2 = [];
              while (result3 !== null) {
                result2.push(result3);
                if (/^[0-9A-Fa-f]/.test(input.charAt(pos))) {
                  result3 = input.charAt(pos);
                  pos++;
                } else {
                  result3 = null;
                  if (reportFailures === 0) {
                    matchFailed("[0-9A-Fa-f]");
                  }
                }
              }
            } else {
              result2 = null;
            }
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, x, value) { return "0" + x + value.join(""); })(pos0, result0[1], result0[2]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_decimal() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (/^[0-9]/.test(input.charAt(pos))) {
          result0 = input.charAt(pos);
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("[0-9]");
          }
        }
        if (result0 !== null) {
          result1 = [];
          if (/^[0-9]/.test(input.charAt(pos))) {
            result2 = input.charAt(pos);
            pos++;
          } else {
            result2 = null;
            if (reportFailures === 0) {
              matchFailed("[0-9]");
            }
          }
          while (result2 !== null) {
            result1.push(result2);
            if (/^[0-9]/.test(input.charAt(pos))) {
              result2 = input.charAt(pos);
              pos++;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("[0-9]");
              }
            }
          }
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, numStart, numRest) { return numStart + numRest.join(""); })(pos0, result0[0], result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_integer() {
        var result0, result1;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.charCodeAt(pos) === 45) {
          result0 = "-";
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"-\"");
          }
        }
        result0 = result0 !== null ? result0 : "";
        if (result0 !== null) {
          result1 = parse_hex();
          if (result1 === null) {
            result1 = parse_octal();
            if (result1 === null) {
              result1 = parse_decimal();
            }
          }
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, neg, num) { return neg + num; })(pos0, result0[0], result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_floatEe() {
        var result0, result1, result2, result3;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (/^[Ee]/.test(input.charAt(pos))) {
          result0 = input.charAt(pos);
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("[Ee]");
          }
        }
        if (result0 !== null) {
          if (/^[+\-]/.test(input.charAt(pos))) {
            result1 = input.charAt(pos);
            pos++;
          } else {
            result1 = null;
            if (reportFailures === 0) {
              matchFailed("[+\\-]");
            }
          }
          result1 = result1 !== null ? result1 : "";
          if (result1 !== null) {
            if (/^[0-9]/.test(input.charAt(pos))) {
              result3 = input.charAt(pos);
              pos++;
            } else {
              result3 = null;
              if (reportFailures === 0) {
                matchFailed("[0-9]");
              }
            }
            if (result3 !== null) {
              result2 = [];
              while (result3 !== null) {
                result2.push(result3);
                if (/^[0-9]/.test(input.charAt(pos))) {
                  result3 = input.charAt(pos);
                  pos++;
                } else {
                  result3 = null;
                  if (reportFailures === 0) {
                    matchFailed("[0-9]");
                  }
                }
              }
            } else {
              result2 = null;
            }
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, e, sign, exp) { return e + sign + exp.join(""); })(pos0, result0[0], result0[1], result0[2]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_expFloat() {
        var result0, result1;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (/^[0-9]/.test(input.charAt(pos))) {
          result1 = input.charAt(pos);
          pos++;
        } else {
          result1 = null;
          if (reportFailures === 0) {
            matchFailed("[0-9]");
          }
        }
        if (result1 !== null) {
          result0 = [];
          while (result1 !== null) {
            result0.push(result1);
            if (/^[0-9]/.test(input.charAt(pos))) {
              result1 = input.charAt(pos);
              pos++;
            } else {
              result1 = null;
              if (reportFailures === 0) {
                matchFailed("[0-9]");
              }
            }
          }
        } else {
          result0 = null;
        }
        if (result0 !== null) {
          result1 = parse_floatEe();
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, num, fee) { return num.join("") + fee; })(pos0, result0[0], result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_leadFloat() {
        var result0, result1, result2, result3;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (/^[0-9]/.test(input.charAt(pos))) {
          result1 = input.charAt(pos);
          pos++;
        } else {
          result1 = null;
          if (reportFailures === 0) {
            matchFailed("[0-9]");
          }
        }
        if (result1 !== null) {
          result0 = [];
          while (result1 !== null) {
            result0.push(result1);
            if (/^[0-9]/.test(input.charAt(pos))) {
              result1 = input.charAt(pos);
              pos++;
            } else {
              result1 = null;
              if (reportFailures === 0) {
                matchFailed("[0-9]");
              }
            }
          }
        } else {
          result0 = null;
        }
        if (result0 !== null) {
          if (input.charCodeAt(pos) === 46) {
            result1 = ".";
            pos++;
          } else {
            result1 = null;
            if (reportFailures === 0) {
              matchFailed("\".\"");
            }
          }
          if (result1 !== null) {
            result2 = [];
            if (/^[0-9]/.test(input.charAt(pos))) {
              result3 = input.charAt(pos);
              pos++;
            } else {
              result3 = null;
              if (reportFailures === 0) {
                matchFailed("[0-9]");
              }
            }
            while (result3 !== null) {
              result2.push(result3);
              if (/^[0-9]/.test(input.charAt(pos))) {
                result3 = input.charAt(pos);
                pos++;
              } else {
                result3 = null;
                if (reportFailures === 0) {
                  matchFailed("[0-9]");
                }
              }
            }
            if (result2 !== null) {
              result3 = parse_floatEe();
              result3 = result3 !== null ? result3 : "";
              if (result3 !== null) {
                result0 = [result0, result1, result2, result3];
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, num, dec, fee) { return num.join("") + "." + dec.join("") + fee; })(pos0, result0[0], result0[2], result0[3]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_dotFloat() {
        var result0, result1, result2, result3;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = [];
        if (/^[0-9]/.test(input.charAt(pos))) {
          result1 = input.charAt(pos);
          pos++;
        } else {
          result1 = null;
          if (reportFailures === 0) {
            matchFailed("[0-9]");
          }
        }
        while (result1 !== null) {
          result0.push(result1);
          if (/^[0-9]/.test(input.charAt(pos))) {
            result1 = input.charAt(pos);
            pos++;
          } else {
            result1 = null;
            if (reportFailures === 0) {
              matchFailed("[0-9]");
            }
          }
        }
        if (result0 !== null) {
          if (input.charCodeAt(pos) === 46) {
            result1 = ".";
            pos++;
          } else {
            result1 = null;
            if (reportFailures === 0) {
              matchFailed("\".\"");
            }
          }
          if (result1 !== null) {
            if (/^[0-9]/.test(input.charAt(pos))) {
              result3 = input.charAt(pos);
              pos++;
            } else {
              result3 = null;
              if (reportFailures === 0) {
                matchFailed("[0-9]");
              }
            }
            if (result3 !== null) {
              result2 = [];
              while (result3 !== null) {
                result2.push(result3);
                if (/^[0-9]/.test(input.charAt(pos))) {
                  result3 = input.charAt(pos);
                  pos++;
                } else {
                  result3 = null;
                  if (reportFailures === 0) {
                    matchFailed("[0-9]");
                  }
                }
              }
            } else {
              result2 = null;
            }
            if (result2 !== null) {
              result3 = parse_floatEe();
              result3 = result3 !== null ? result3 : "";
              if (result3 !== null) {
                result0 = [result0, result1, result2, result3];
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, num, dec, fee) { return num.join("") + "." + dec.join("") + fee; })(pos0, result0[0], result0[2], result0[3]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_float() {
        var result0, result1;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.charCodeAt(pos) === 45) {
          result0 = "-";
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"-\"");
          }
        }
        result0 = result0 !== null ? result0 : "";
        if (result0 !== null) {
          result1 = parse_leadFloat();
          if (result1 === null) {
            result1 = parse_dotFloat();
            if (result1 === null) {
              result1 = parse_expFloat();
              if (result1 === null) {
                if (input.substr(pos, 8) === "Infinity") {
                  result1 = "Infinity";
                  pos += 8;
                } else {
                  result1 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"Infinity\"");
                  }
                }
              }
            }
          }
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, neg, num) { return neg + num; })(pos0, result0[0], result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_string() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.charCodeAt(pos) === 34) {
          result0 = "\"";
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"\\\"\"");
          }
        }
        if (result0 !== null) {
          result1 = [];
          if (/^[^""]/.test(input.charAt(pos))) {
            result2 = input.charAt(pos);
            pos++;
          } else {
            result2 = null;
            if (reportFailures === 0) {
              matchFailed("[^\"\"]");
            }
          }
          while (result2 !== null) {
            result1.push(result2);
            if (/^[^""]/.test(input.charAt(pos))) {
              result2 = input.charAt(pos);
              pos++;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("[^\"\"]");
              }
            }
          }
          if (result1 !== null) {
            if (input.charCodeAt(pos) === 34) {
              result2 = "\"";
              pos++;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"\\\"\"");
              }
            }
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, str) { return str.join(""); })(pos0, result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_other() {
        var result0, result1;
        var pos0;
        
        pos0 = pos;
        if (/^[^\t\n\r 0-9A-Z_a-z]/.test(input.charAt(pos))) {
          result1 = input.charAt(pos);
          pos++;
        } else {
          result1 = null;
          if (reportFailures === 0) {
            matchFailed("[^\\t\\n\\r 0-9A-Z_a-z]");
          }
        }
        if (result1 !== null) {
          result0 = [];
          while (result1 !== null) {
            result0.push(result1);
            if (/^[^\t\n\r 0-9A-Z_a-z]/.test(input.charAt(pos))) {
              result1 = input.charAt(pos);
              pos++;
            } else {
              result1 = null;
              if (reportFailures === 0) {
                matchFailed("[^\\t\\n\\r 0-9A-Z_a-z]");
              }
            }
          }
        } else {
          result0 = null;
        }
        if (result0 !== null) {
          result0 = (function(offset, other) { return other.join(""); })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_type() {
        var result0, result1;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_TypeDesc();
        if (result0 !== null) {
          result1 = parse_Nullable();
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, type, nullable) {
                    if (!type.sequence) type.sequence = false;
                    type.nullable = nullable;
                    return type; })(pos0, result0[0], result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_TypeDesc() {
        var result0;
        var pos0;
        
        pos0 = pos;
        result0 = parse_Sequence();
        if (result0 === null) {
          result0 = parse_ArrayType();
          if (result0 === null) {
            result0 = parse_SimpleType();
            if (result0 === null) {
              result0 = parse_UnionType();
            }
          }
        }
        if (result0 !== null) {
          result0 = (function(offset, type) { return type; })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_Sequence() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.substr(pos, 9) === "sequence<") {
          result0 = "sequence<";
          pos += 9;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"sequence<\"");
          }
        }
        if (result0 !== null) {
          result1 = parse_type();
          if (result1 !== null) {
            if (input.charCodeAt(pos) === 62) {
              result2 = ">";
              pos++;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\">\"");
              }
            }
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, type) { return { sequence: true, array: false, idlType: type, members: [] }; })(pos0, result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_ArrayType() {
        var result0, result1;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_SimpleType();
        if (result0 !== null) {
          if (input.substr(pos, 2) === "[]") {
            result1 = "[]";
            pos += 2;
          } else {
            result1 = null;
            if (reportFailures === 0) {
              matchFailed("\"[]\"");
            }
          }
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, type) {
                    type.array = true;
                    return type;
                })(pos0, result0[0]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_UnionType() {
        var result0, result1, result2, result3, result4;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.charCodeAt(pos) === 40) {
          result0 = "(";
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"(\"");
          }
        }
        if (result0 !== null) {
          result1 = parse_w();
          if (result1 !== null) {
            result2 = parse_TypeList();
            if (result2 !== null) {
              result3 = parse_w();
              if (result3 !== null) {
                if (input.charCodeAt(pos) === 41) {
                  result4 = ")";
                  pos++;
                } else {
                  result4 = null;
                  if (reportFailures === 0) {
                    matchFailed("\")\"");
                  }
                }
                if (result4 !== null) {
                  result0 = [result0, result1, result2, result3, result4];
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, members) { return { idlType: "union", members: members, sequence: false, array: false }; })(pos0, result0[2]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_TypeList() {
        var result0, result1, result2, result3, result4, result5, result6;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_type();
        if (result0 !== null) {
          result1 = parse_s();
          if (result1 !== null) {
            if (input.substr(pos, 2) === "or") {
              result2 = "or";
              pos += 2;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"or\"");
              }
            }
            if (result2 !== null) {
              result3 = parse_s();
              if (result3 !== null) {
                result4 = parse_type();
                if (result4 !== null) {
                  result5 = [];
                  result6 = parse_TypeListRest();
                  while (result6 !== null) {
                    result5.push(result6);
                    result6 = parse_TypeListRest();
                  }
                  if (result5 !== null) {
                    result0 = [result0, result1, result2, result3, result4, result5];
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, first, second, others) {   var ret = [first, second];
                    for (var i = 0, n = others.length; i < n; i++) { ret.push(others[i]); }
                    return ret; })(pos0, result0[0], result0[4], result0[5]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_TypeListRest() {
        var result0, result1, result2, result3;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_s();
        if (result0 !== null) {
          if (input.substr(pos, 2) === "or") {
            result1 = "or";
            pos += 2;
          } else {
            result1 = null;
            if (reportFailures === 0) {
              matchFailed("\"or\"");
            }
          }
          if (result1 !== null) {
            result2 = parse_s();
            if (result2 !== null) {
              result3 = parse_type();
              if (result3 !== null) {
                result0 = [result0, result1, result2, result3];
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, rest) { return rest; })(pos0, result0[3]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_SimpleType() {
        var result0;
        var pos0;
        
        pos0 = pos;
        result0 = parse_PrimitiveType();
        if (result0 === null) {
          result0 = parse_UnsignedIntegerType();
          if (result0 === null) {
            result0 = parse_FloatType();
            if (result0 === null) {
              result0 = parse_ScopedName();
            }
          }
        }
        if (result0 !== null) {
          result0 = (function(offset, type) { return { sequence: false, array: false, idlType: type, members: [] }; })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_PrimitiveType() {
        var result0, result1;
        var pos0, pos1, pos2;
        
        pos0 = pos;
        pos1 = pos;
        if (input.substr(pos, 3) === "any") {
          result0 = "any";
          pos += 3;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"any\"");
          }
        }
        if (result0 === null) {
          if (input.substr(pos, 6) === "object") {
            result0 = "object";
            pos += 6;
          } else {
            result0 = null;
            if (reportFailures === 0) {
              matchFailed("\"object\"");
            }
          }
          if (result0 === null) {
            if (input.substr(pos, 7) === "boolean") {
              result0 = "boolean";
              pos += 7;
            } else {
              result0 = null;
              if (reportFailures === 0) {
                matchFailed("\"boolean\"");
              }
            }
            if (result0 === null) {
              if (input.substr(pos, 5) === "octet") {
                result0 = "octet";
                pos += 5;
              } else {
                result0 = null;
                if (reportFailures === 0) {
                  matchFailed("\"octet\"");
                }
              }
              if (result0 === null) {
                if (input.substr(pos, 9) === "DOMString") {
                  result0 = "DOMString";
                  pos += 9;
                } else {
                  result0 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"DOMString\"");
                  }
                }
              }
            }
          }
        }
        if (result0 !== null) {
          pos2 = pos;
          reportFailures++;
          if (/^[A-Za-z0-9]/.test(input.charAt(pos))) {
            result1 = input.charAt(pos);
            pos++;
          } else {
            result1 = null;
            if (reportFailures === 0) {
              matchFailed("[A-Za-z0-9]");
            }
          }
          reportFailures--;
          if (result1 === null) {
            result1 = "";
          } else {
            result1 = null;
            pos = pos2;
          }
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, type) { return type; })(pos0, result0[0]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_FloatType() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.substr(pos, 12) === "unrestricted") {
          result0 = "unrestricted";
          pos += 12;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"unrestricted\"");
          }
        }
        result0 = result0 !== null ? result0 : "";
        if (result0 !== null) {
          result1 = parse_s();
          if (result1 !== null) {
            if (input.substr(pos, 5) === "float") {
              result2 = "float";
              pos += 5;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"float\"");
              }
            }
            if (result2 === null) {
              if (input.substr(pos, 6) === "double") {
                result2 = "double";
                pos += 6;
              } else {
                result2 = null;
                if (reportFailures === 0) {
                  matchFailed("\"double\"");
                }
              }
            }
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, unr, kind) { return (unr ? "unrestricted " : "") + (kind); })(pos0, result0[0], result0[2]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_UnsignedIntegerType() {
        var result0, result1, result2, result3, result4;
        var pos0, pos1, pos2;
        
        pos0 = pos;
        pos1 = pos;
        if (input.substr(pos, 8) === "unsigned") {
          result0 = "unsigned";
          pos += 8;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"unsigned\"");
          }
        }
        result0 = result0 !== null ? result0 : "";
        if (result0 !== null) {
          result1 = parse_s();
          if (result1 !== null) {
            pos2 = pos;
            if (input.substr(pos, 4) === "long") {
              result2 = "long";
              pos += 4;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"long\"");
              }
            }
            if (result2 !== null) {
              result3 = parse_s();
              if (result3 !== null) {
                if (input.substr(pos, 4) === "long") {
                  result4 = "long";
                  pos += 4;
                } else {
                  result4 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"long\"");
                  }
                }
                if (result4 !== null) {
                  result2 = [result2, result3, result4];
                } else {
                  result2 = null;
                  pos = pos2;
                }
              } else {
                result2 = null;
                pos = pos2;
              }
            } else {
              result2 = null;
              pos = pos2;
            }
            if (result2 === null) {
              if (input.substr(pos, 4) === "long") {
                result2 = "long";
                pos += 4;
              } else {
                result2 = null;
                if (reportFailures === 0) {
                  matchFailed("\"long\"");
                }
              }
              if (result2 === null) {
                if (input.substr(pos, 5) === "short") {
                  result2 = "short";
                  pos += 5;
                } else {
                  result2 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"short\"");
                  }
                }
                if (result2 === null) {
                  if (input.substr(pos, 4) === "byte") {
                    result2 = "byte";
                    pos += 4;
                  } else {
                    result2 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"byte\"");
                    }
                  }
                }
              }
            }
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, uns, kind) { return (uns ? "unsigned " : "") + (kind.join ? kind.join("") : kind); })(pos0, result0[0], result0[2]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_ScopedNameList() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_ScopedName();
        if (result0 !== null) {
          result1 = [];
          result2 = parse_ScopedNameListRest();
          while (result2 !== null) {
            result1.push(result2);
            result2 = parse_ScopedNameListRest();
          }
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, first, others) {   var ret = [first];
                    for (var i = 0, n = others.length; i < n; i++) { ret.push(others[i]); }
                    return ret; })(pos0, result0[0], result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_ScopedNameListRest() {
        var result0, result1, result2, result3;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_w();
        if (result0 !== null) {
          if (input.charCodeAt(pos) === 44) {
            result1 = ",";
            pos++;
          } else {
            result1 = null;
            if (reportFailures === 0) {
              matchFailed("\",\"");
            }
          }
          if (result1 !== null) {
            result2 = parse_w();
            if (result2 !== null) {
              result3 = parse_ScopedName();
              if (result3 !== null) {
                result0 = [result0, result1, result2, result3];
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, rest) { return rest; })(pos0, result0[3]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_ScopedName() {
        var result0;
        var pos0;
        
        pos0 = pos;
        result0 = parse_AbsoluteScopedName();
        if (result0 === null) {
          result0 = parse_RelativeScopedName();
        }
        if (result0 !== null) {
          result0 = (function(offset, name) { return name; })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_AbsoluteScopedName() {
        var result0, result1;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.substr(pos, 2) === "::") {
          result0 = "::";
          pos += 2;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"::\"");
          }
        }
        if (result0 !== null) {
          result1 = parse_RelativeScopedName();
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, rel) { return "::" + rel; })(pos0, result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_RelativeScopedName() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_identifier();
        if (result0 !== null) {
          result1 = [];
          result2 = parse_ScopedNameRest();
          while (result2 !== null) {
            result1.push(result2);
            result2 = parse_ScopedNameRest();
          }
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, name, rest) { return name + rest.join(""); })(pos0, result0[0], result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_ScopedNameRest() {
        var result0, result1;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.substr(pos, 2) === "::") {
          result0 = "::";
          pos += 2;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"::\"");
          }
        }
        if (result0 !== null) {
          result1 = parse_identifier();
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, name) { return name.join(""); })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_BooleanLiteral() {
        var result0;
        var pos0;
        
        pos0 = pos;
        if (input.substr(pos, 4) === "true") {
          result0 = "true";
          pos += 4;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"true\"");
          }
        }
        if (result0 === null) {
          if (input.substr(pos, 5) === "false") {
            result0 = "false";
            pos += 5;
          } else {
            result0 = null;
            if (reportFailures === 0) {
              matchFailed("\"false\"");
            }
          }
        }
        if (result0 !== null) {
          result0 = (function(offset, value) { return value; })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_Nullable() {
        var result0;
        var pos0;
        
        pos0 = pos;
        if (input.charCodeAt(pos) === 63) {
          result0 = "?";
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"?\"");
          }
        }
        result0 = result0 !== null ? result0 : "";
        if (result0 !== null) {
          result0 = (function(offset, nullable) { return nullable ? true : false; })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_ReturnType() {
        var result0;
        var pos0;
        
        pos0 = pos;
        if (input.substr(pos, 4) === "void") {
          result0 = "void";
          pos += 4;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"void\"");
          }
        }
        if (result0 === null) {
          result0 = parse_type();
        }
        if (result0 !== null) {
          result0 = (function(offset, ret) { return ret; })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_definitions() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_w();
        if (result0 !== null) {
          result1 = [];
          result2 = parse_definition();
          while (result2 !== null) {
            result1.push(result2);
            result2 = parse_definition();
          }
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, defs) { return defs; })(pos0, result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_definition() {
        var result0;
        var pos0;
        
        pos0 = pos;
        result0 = parse_partialdictionary();
        if (result0 === null) {
          result0 = parse_partialinterface();
          if (result0 === null) {
            result0 = parse_callbackinterface();
            if (result0 === null) {
              result0 = parse_module();
              if (result0 === null) {
                result0 = parse_interface();
                if (result0 === null) {
                  result0 = parse_dictionary();
                  if (result0 === null) {
                    result0 = parse_typedef();
                    if (result0 === null) {
                      result0 = parse_exception();
                      if (result0 === null) {
                        result0 = parse_implements();
                        if (result0 === null) {
                          result0 = parse_enum();
                          if (result0 === null) {
                            result0 = parse_callback();
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
        if (result0 !== null) {
          result0 = (function(offset, def) { return def; })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_partialinterface() {
        var result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13, result14, result15;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_ExtendedAttributeList();
        if (result0 !== null) {
          result1 = parse_s();
          result1 = result1 !== null ? result1 : "";
          if (result1 !== null) {
            if (input.substr(pos, 7) === "partial") {
              result2 = "partial";
              pos += 7;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"partial\"");
              }
            }
            if (result2 !== null) {
              result3 = parse_s();
              if (result3 !== null) {
                if (input.substr(pos, 9) === "interface") {
                  result4 = "interface";
                  pos += 9;
                } else {
                  result4 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"interface\"");
                  }
                }
                if (result4 !== null) {
                  result5 = parse_s();
                  if (result5 !== null) {
                    result6 = parse_identifier();
                    if (result6 !== null) {
                      result7 = parse_w();
                      if (result7 !== null) {
                        if (input.charCodeAt(pos) === 123) {
                          result8 = "{";
                          pos++;
                        } else {
                          result8 = null;
                          if (reportFailures === 0) {
                            matchFailed("\"{\"");
                          }
                        }
                        if (result8 !== null) {
                          result9 = parse_w();
                          if (result9 !== null) {
                            result10 = parse_InterfaceMemberList();
                            if (result10 !== null) {
                              result11 = parse_w();
                              if (result11 !== null) {
                                if (input.charCodeAt(pos) === 125) {
                                  result12 = "}";
                                  pos++;
                                } else {
                                  result12 = null;
                                  if (reportFailures === 0) {
                                    matchFailed("\"}\"");
                                  }
                                }
                                if (result12 !== null) {
                                  result13 = parse_w();
                                  if (result13 !== null) {
                                    if (input.charCodeAt(pos) === 59) {
                                      result14 = ";";
                                      pos++;
                                    } else {
                                      result14 = null;
                                      if (reportFailures === 0) {
                                        matchFailed("\";\"");
                                      }
                                    }
                                    if (result14 !== null) {
                                      result15 = parse_w();
                                      if (result15 !== null) {
                                        result0 = [result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13, result14, result15];
                                      } else {
                                        result0 = null;
                                        pos = pos1;
                                      }
                                    } else {
                                      result0 = null;
                                      pos = pos1;
                                    }
                                  } else {
                                    result0 = null;
                                    pos = pos1;
                                  }
                                } else {
                                  result0 = null;
                                  pos = pos1;
                                }
                              } else {
                                result0 = null;
                                pos = pos1;
                              }
                            } else {
                              result0 = null;
                              pos = pos1;
                            }
                          } else {
                            result0 = null;
                            pos = pos1;
                          }
                        } else {
                          result0 = null;
                          pos = pos1;
                        }
                      } else {
                        result0 = null;
                        pos = pos1;
                      }
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, extAttrs, name, mem) { return { type: "partialinterface", name: name, members: mem, extAttrs: extAttrs }; })(pos0, result0[0], result0[6], result0[10]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_partialdictionary() {
        var result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.substr(pos, 7) === "partial") {
          result0 = "partial";
          pos += 7;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"partial\"");
          }
        }
        if (result0 !== null) {
          result1 = parse_s();
          if (result1 !== null) {
            if (input.substr(pos, 10) === "dictionary") {
              result2 = "dictionary";
              pos += 10;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"dictionary\"");
              }
            }
            if (result2 !== null) {
              result3 = parse_s();
              if (result3 !== null) {
                result4 = parse_identifier();
                if (result4 !== null) {
                  result5 = parse_w();
                  if (result5 !== null) {
                    if (input.charCodeAt(pos) === 123) {
                      result6 = "{";
                      pos++;
                    } else {
                      result6 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"{\"");
                      }
                    }
                    if (result6 !== null) {
                      result7 = parse_w();
                      if (result7 !== null) {
                        result8 = parse_DictionaryMemberList();
                        if (result8 !== null) {
                          result9 = parse_w();
                          if (result9 !== null) {
                            if (input.charCodeAt(pos) === 125) {
                              result10 = "}";
                              pos++;
                            } else {
                              result10 = null;
                              if (reportFailures === 0) {
                                matchFailed("\"}\"");
                              }
                            }
                            if (result10 !== null) {
                              result11 = parse_w();
                              if (result11 !== null) {
                                if (input.charCodeAt(pos) === 59) {
                                  result12 = ";";
                                  pos++;
                                } else {
                                  result12 = null;
                                  if (reportFailures === 0) {
                                    matchFailed("\";\"");
                                  }
                                }
                                if (result12 !== null) {
                                  result13 = parse_w();
                                  if (result13 !== null) {
                                    result0 = [result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13];
                                  } else {
                                    result0 = null;
                                    pos = pos1;
                                  }
                                } else {
                                  result0 = null;
                                  pos = pos1;
                                }
                              } else {
                                result0 = null;
                                pos = pos1;
                              }
                            } else {
                              result0 = null;
                              pos = pos1;
                            }
                          } else {
                            result0 = null;
                            pos = pos1;
                          }
                        } else {
                          result0 = null;
                          pos = pos1;
                        }
                      } else {
                        result0 = null;
                        pos = pos1;
                      }
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, name, members) {
                    return {
                        type: "partialdictionary",
                        name: name,
                        members: members
                    };
                })(pos0, result0[4], result0[8]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_callbackinterface() {
        var result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13, result14, result15;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_ExtendedAttributeList();
        if (result0 !== null) {
          result1 = parse_s();
          result1 = result1 !== null ? result1 : "";
          if (result1 !== null) {
            if (input.substr(pos, 8) === "callback") {
              result2 = "callback";
              pos += 8;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"callback\"");
              }
            }
            if (result2 !== null) {
              result3 = parse_s();
              if (result3 !== null) {
                if (input.substr(pos, 9) === "interface") {
                  result4 = "interface";
                  pos += 9;
                } else {
                  result4 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"interface\"");
                  }
                }
                if (result4 !== null) {
                  result5 = parse_s();
                  if (result5 !== null) {
                    result6 = parse_identifier();
                    if (result6 !== null) {
                      result7 = parse_w();
                      if (result7 !== null) {
                        if (input.charCodeAt(pos) === 123) {
                          result8 = "{";
                          pos++;
                        } else {
                          result8 = null;
                          if (reportFailures === 0) {
                            matchFailed("\"{\"");
                          }
                        }
                        if (result8 !== null) {
                          result9 = parse_w();
                          if (result9 !== null) {
                            result10 = parse_InterfaceMemberList();
                            if (result10 !== null) {
                              result11 = parse_w();
                              if (result11 !== null) {
                                if (input.charCodeAt(pos) === 125) {
                                  result12 = "}";
                                  pos++;
                                } else {
                                  result12 = null;
                                  if (reportFailures === 0) {
                                    matchFailed("\"}\"");
                                  }
                                }
                                if (result12 !== null) {
                                  result13 = parse_w();
                                  if (result13 !== null) {
                                    if (input.charCodeAt(pos) === 59) {
                                      result14 = ";";
                                      pos++;
                                    } else {
                                      result14 = null;
                                      if (reportFailures === 0) {
                                        matchFailed("\";\"");
                                      }
                                    }
                                    if (result14 !== null) {
                                      result15 = parse_w();
                                      if (result15 !== null) {
                                        result0 = [result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13, result14, result15];
                                      } else {
                                        result0 = null;
                                        pos = pos1;
                                      }
                                    } else {
                                      result0 = null;
                                      pos = pos1;
                                    }
                                  } else {
                                    result0 = null;
                                    pos = pos1;
                                  }
                                } else {
                                  result0 = null;
                                  pos = pos1;
                                }
                              } else {
                                result0 = null;
                                pos = pos1;
                              }
                            } else {
                              result0 = null;
                              pos = pos1;
                            }
                          } else {
                            result0 = null;
                            pos = pos1;
                          }
                        } else {
                          result0 = null;
                          pos = pos1;
                        }
                      } else {
                        result0 = null;
                        pos = pos1;
                      }
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, extAttrs, name, mem) { return { type: "callbackinterface", name: name, members: mem, extAttrs: extAttrs }; })(pos0, result0[0], result0[6], result0[10]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_module() {
        var result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_ExtendedAttributeList();
        if (result0 !== null) {
          result1 = parse_s();
          result1 = result1 !== null ? result1 : "";
          if (result1 !== null) {
            if (input.substr(pos, 6) === "module") {
              result2 = "module";
              pos += 6;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"module\"");
              }
            }
            if (result2 !== null) {
              result3 = parse_s();
              if (result3 !== null) {
                result4 = parse_identifier();
                if (result4 !== null) {
                  result5 = parse_w();
                  if (result5 !== null) {
                    if (input.charCodeAt(pos) === 123) {
                      result6 = "{";
                      pos++;
                    } else {
                      result6 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"{\"");
                      }
                    }
                    if (result6 !== null) {
                      result7 = parse_w();
                      if (result7 !== null) {
                        result8 = parse_definitions();
                        if (result8 !== null) {
                          result9 = parse_w();
                          if (result9 !== null) {
                            if (input.charCodeAt(pos) === 125) {
                              result10 = "}";
                              pos++;
                            } else {
                              result10 = null;
                              if (reportFailures === 0) {
                                matchFailed("\"}\"");
                              }
                            }
                            if (result10 !== null) {
                              result11 = parse_w();
                              if (result11 !== null) {
                                if (input.charCodeAt(pos) === 59) {
                                  result12 = ";";
                                  pos++;
                                } else {
                                  result12 = null;
                                  if (reportFailures === 0) {
                                    matchFailed("\";\"");
                                  }
                                }
                                if (result12 !== null) {
                                  result13 = parse_w();
                                  if (result13 !== null) {
                                    result0 = [result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13];
                                  } else {
                                    result0 = null;
                                    pos = pos1;
                                  }
                                } else {
                                  result0 = null;
                                  pos = pos1;
                                }
                              } else {
                                result0 = null;
                                pos = pos1;
                              }
                            } else {
                              result0 = null;
                              pos = pos1;
                            }
                          } else {
                            result0 = null;
                            pos = pos1;
                          }
                        } else {
                          result0 = null;
                          pos = pos1;
                        }
                      } else {
                        result0 = null;
                        pos = pos1;
                      }
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, extAttrs, name, defs) { return { type: "module", name: name, definitions: defs, extAttrs: extAttrs }; })(pos0, result0[0], result0[4], result0[8]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_implements() {
        var result0, result1, result2, result3, result4, result5, result6, result7, result8, result9;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_ExtendedAttributeList();
        if (result0 !== null) {
          result1 = parse_s();
          result1 = result1 !== null ? result1 : "";
          if (result1 !== null) {
            result2 = parse_ScopedName();
            if (result2 !== null) {
              result3 = parse_s();
              if (result3 !== null) {
                if (input.substr(pos, 10) === "implements") {
                  result4 = "implements";
                  pos += 10;
                } else {
                  result4 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"implements\"");
                  }
                }
                if (result4 !== null) {
                  result5 = parse_s();
                  if (result5 !== null) {
                    result6 = parse_ScopedName();
                    if (result6 !== null) {
                      result7 = parse_w();
                      if (result7 !== null) {
                        if (input.charCodeAt(pos) === 59) {
                          result8 = ";";
                          pos++;
                        } else {
                          result8 = null;
                          if (reportFailures === 0) {
                            matchFailed("\";\"");
                          }
                        }
                        if (result8 !== null) {
                          result9 = parse_w();
                          if (result9 !== null) {
                            result0 = [result0, result1, result2, result3, result4, result5, result6, result7, result8, result9];
                          } else {
                            result0 = null;
                            pos = pos1;
                          }
                        } else {
                          result0 = null;
                          pos = pos1;
                        }
                      } else {
                        result0 = null;
                        pos = pos1;
                      }
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, extAttrs, target, impl) { return { type: 'implements', target: target, 'implements': impl, extAttrs: extAttrs }; })(pos0, result0[0], result0[2], result0[6]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_interface() {
        var result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13, result14, result15;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_ExtendedAttributeList();
        if (result0 !== null) {
          result1 = parse_s();
          result1 = result1 !== null ? result1 : "";
          if (result1 !== null) {
            if (input.substr(pos, 9) === "interface") {
              result2 = "interface";
              pos += 9;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"interface\"");
              }
            }
            if (result2 !== null) {
              result3 = parse_s();
              if (result3 !== null) {
                result4 = parse_identifier();
                if (result4 !== null) {
                  result5 = parse_w();
                  if (result5 !== null) {
                    result6 = parse_Inheritance();
                    if (result6 !== null) {
                      result7 = parse_w();
                      if (result7 !== null) {
                        if (input.charCodeAt(pos) === 123) {
                          result8 = "{";
                          pos++;
                        } else {
                          result8 = null;
                          if (reportFailures === 0) {
                            matchFailed("\"{\"");
                          }
                        }
                        if (result8 !== null) {
                          result9 = parse_w();
                          if (result9 !== null) {
                            result10 = parse_InterfaceMemberList();
                            if (result10 !== null) {
                              result11 = parse_w();
                              if (result11 !== null) {
                                if (input.charCodeAt(pos) === 125) {
                                  result12 = "}";
                                  pos++;
                                } else {
                                  result12 = null;
                                  if (reportFailures === 0) {
                                    matchFailed("\"}\"");
                                  }
                                }
                                if (result12 !== null) {
                                  result13 = parse_w();
                                  if (result13 !== null) {
                                    if (input.charCodeAt(pos) === 59) {
                                      result14 = ";";
                                      pos++;
                                    } else {
                                      result14 = null;
                                      if (reportFailures === 0) {
                                        matchFailed("\";\"");
                                      }
                                    }
                                    if (result14 !== null) {
                                      result15 = parse_w();
                                      if (result15 !== null) {
                                        result0 = [result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13, result14, result15];
                                      } else {
                                        result0 = null;
                                        pos = pos1;
                                      }
                                    } else {
                                      result0 = null;
                                      pos = pos1;
                                    }
                                  } else {
                                    result0 = null;
                                    pos = pos1;
                                  }
                                } else {
                                  result0 = null;
                                  pos = pos1;
                                }
                              } else {
                                result0 = null;
                                pos = pos1;
                              }
                            } else {
                              result0 = null;
                              pos = pos1;
                            }
                          } else {
                            result0 = null;
                            pos = pos1;
                          }
                        } else {
                          result0 = null;
                          pos = pos1;
                        }
                      } else {
                        result0 = null;
                        pos = pos1;
                      }
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, extAttrs, name, herit, mem) { return { type: "interface", name: name, inheritance: herit, members: mem, extAttrs: extAttrs }; })(pos0, result0[0], result0[4], result0[6], result0[10]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_enum() {
        var result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13, result14, result15;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_ExtendedAttributeList();
        if (result0 !== null) {
          result1 = parse_s();
          result1 = result1 !== null ? result1 : "";
          if (result1 !== null) {
            if (input.substr(pos, 4) === "enum") {
              result2 = "enum";
              pos += 4;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"enum\"");
              }
            }
            if (result2 !== null) {
              result3 = parse_s();
              if (result3 !== null) {
                result4 = parse_identifier();
                if (result4 !== null) {
                  result5 = parse_w();
                  if (result5 !== null) {
                    if (input.charCodeAt(pos) === 123) {
                      result6 = "{";
                      pos++;
                    } else {
                      result6 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"{\"");
                      }
                    }
                    if (result6 !== null) {
                      result7 = parse_w();
                      if (result7 !== null) {
                        result8 = parse_EnumValues();
                        if (result8 !== null) {
                          result9 = parse_w();
                          result9 = result9 !== null ? result9 : "";
                          if (result9 !== null) {
                            if (input.charCodeAt(pos) === 44) {
                              result10 = ",";
                              pos++;
                            } else {
                              result10 = null;
                              if (reportFailures === 0) {
                                matchFailed("\",\"");
                              }
                            }
                            result10 = result10 !== null ? result10 : "";
                            if (result10 !== null) {
                              result11 = parse_w();
                              if (result11 !== null) {
                                if (input.charCodeAt(pos) === 125) {
                                  result12 = "}";
                                  pos++;
                                } else {
                                  result12 = null;
                                  if (reportFailures === 0) {
                                    matchFailed("\"}\"");
                                  }
                                }
                                if (result12 !== null) {
                                  result13 = parse_w();
                                  if (result13 !== null) {
                                    if (input.charCodeAt(pos) === 59) {
                                      result14 = ";";
                                      pos++;
                                    } else {
                                      result14 = null;
                                      if (reportFailures === 0) {
                                        matchFailed("\";\"");
                                      }
                                    }
                                    if (result14 !== null) {
                                      result15 = parse_w();
                                      if (result15 !== null) {
                                        result0 = [result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13, result14, result15];
                                      } else {
                                        result0 = null;
                                        pos = pos1;
                                      }
                                    } else {
                                      result0 = null;
                                      pos = pos1;
                                    }
                                  } else {
                                    result0 = null;
                                    pos = pos1;
                                  }
                                } else {
                                  result0 = null;
                                  pos = pos1;
                                }
                              } else {
                                result0 = null;
                                pos = pos1;
                              }
                            } else {
                              result0 = null;
                              pos = pos1;
                            }
                          } else {
                            result0 = null;
                            pos = pos1;
                          }
                        } else {
                          result0 = null;
                          pos = pos1;
                        }
                      } else {
                        result0 = null;
                        pos = pos1;
                      }
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, extAttrs, name, values) { return { type: "enum", name: name, values: values, extAttrs: extAttrs }; })(pos0, result0[0], result0[4], result0[8]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_callback() {
        var result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13, result14, result15, result16, result17;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_ExtendedAttributeList();
        if (result0 !== null) {
          result1 = parse_s();
          result1 = result1 !== null ? result1 : "";
          if (result1 !== null) {
            if (input.substr(pos, 8) === "callback") {
              result2 = "callback";
              pos += 8;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"callback\"");
              }
            }
            if (result2 !== null) {
              result3 = parse_s();
              if (result3 !== null) {
                result4 = parse_identifier();
                if (result4 !== null) {
                  result5 = parse_w();
                  if (result5 !== null) {
                    if (input.charCodeAt(pos) === 61) {
                      result6 = "=";
                      pos++;
                    } else {
                      result6 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"=\"");
                      }
                    }
                    if (result6 !== null) {
                      result7 = parse_w();
                      if (result7 !== null) {
                        result8 = parse_ReturnType();
                        if (result8 !== null) {
                          result9 = parse_s();
                          if (result9 !== null) {
                            if (input.charCodeAt(pos) === 40) {
                              result10 = "(";
                              pos++;
                            } else {
                              result10 = null;
                              if (reportFailures === 0) {
                                matchFailed("\"(\"");
                              }
                            }
                            if (result10 !== null) {
                              result11 = parse_w();
                              if (result11 !== null) {
                                result12 = parse_Arguments();
                                if (result12 !== null) {
                                  result13 = parse_w();
                                  if (result13 !== null) {
                                    if (input.charCodeAt(pos) === 41) {
                                      result14 = ")";
                                      pos++;
                                    } else {
                                      result14 = null;
                                      if (reportFailures === 0) {
                                        matchFailed("\")\"");
                                      }
                                    }
                                    if (result14 !== null) {
                                      result15 = parse_w();
                                      if (result15 !== null) {
                                        if (input.charCodeAt(pos) === 59) {
                                          result16 = ";";
                                          pos++;
                                        } else {
                                          result16 = null;
                                          if (reportFailures === 0) {
                                            matchFailed("\";\"");
                                          }
                                        }
                                        if (result16 !== null) {
                                          result17 = parse_w();
                                          if (result17 !== null) {
                                            result0 = [result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13, result14, result15, result16, result17];
                                          } else {
                                            result0 = null;
                                            pos = pos1;
                                          }
                                        } else {
                                          result0 = null;
                                          pos = pos1;
                                        }
                                      } else {
                                        result0 = null;
                                        pos = pos1;
                                      }
                                    } else {
                                      result0 = null;
                                      pos = pos1;
                                    }
                                  } else {
                                    result0 = null;
                                    pos = pos1;
                                  }
                                } else {
                                  result0 = null;
                                  pos = pos1;
                                }
                              } else {
                                result0 = null;
                                pos = pos1;
                              }
                            } else {
                              result0 = null;
                              pos = pos1;
                            }
                          } else {
                            result0 = null;
                            pos = pos1;
                          }
                        } else {
                          result0 = null;
                          pos = pos1;
                        }
                      } else {
                        result0 = null;
                        pos = pos1;
                      }
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, extAttrs, name, ret, args) { return { type: "callback", idlType: ret, name: name, args: args, extAttrs: extAttrs }; })(pos0, result0[0], result0[4], result0[8], result0[12]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_EnumValues() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_string();
        if (result0 !== null) {
          result1 = [];
          result2 = parse_EnumValuesRest();
          while (result2 !== null) {
            result1.push(result2);
            result2 = parse_EnumValuesRest();
          }
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, first, others) {   var ret = [first];
                    for (var i = 0, n = others.length; i < n; i++) { ret.push(others[i]); }
                    return ret; })(pos0, result0[0], result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_EnumValuesRest() {
        var result0, result1, result2, result3;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_w();
        if (result0 !== null) {
          if (input.charCodeAt(pos) === 44) {
            result1 = ",";
            pos++;
          } else {
            result1 = null;
            if (reportFailures === 0) {
              matchFailed("\",\"");
            }
          }
          if (result1 !== null) {
            result2 = parse_w();
            if (result2 !== null) {
              result3 = parse_string();
              if (result3 !== null) {
                result0 = [result0, result1, result2, result3];
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, rest) { return rest; })(pos0, result0[3]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_Inheritance() {
        var result0;
        var pos0;
        
        pos0 = pos;
        result0 = parse_InheritanceInner();
        result0 = result0 !== null ? result0 : "";
        if (result0 !== null) {
          result0 = (function(offset, herit) { return herit ? herit : []; })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_InheritanceInner() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.charCodeAt(pos) === 58) {
          result0 = ":";
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\":\"");
          }
        }
        if (result0 !== null) {
          result1 = parse_w();
          if (result1 !== null) {
            result2 = parse_ScopedNameList();
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, herit) { return herit; })(pos0, result0[2]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_InterfaceMemberList() {
        var result0, result1;
        var pos0;
        
        pos0 = pos;
        result0 = [];
        result1 = parse_InterfaceMember();
        while (result1 !== null) {
          result0.push(result1);
          result1 = parse_InterfaceMember();
        }
        if (result0 !== null) {
          result0 = (function(offset, mem) { return mem ? mem : []; })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_InterfaceMember() {
        var result0;
        var pos0;
        
        pos0 = pos;
        result0 = parse_const();
        if (result0 === null) {
          result0 = parse_attrOrOp();
        }
        if (result0 !== null) {
          result0 = (function(offset, mem) { return mem; })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_const() {
        var result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_ExtendedAttributeList();
        if (result0 !== null) {
          result1 = parse_s();
          result1 = result1 !== null ? result1 : "";
          if (result1 !== null) {
            if (input.substr(pos, 5) === "const") {
              result2 = "const";
              pos += 5;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"const\"");
              }
            }
            if (result2 !== null) {
              result3 = parse_s();
              if (result3 !== null) {
                result4 = parse_type();
                if (result4 !== null) {
                  result5 = parse_s();
                  if (result5 !== null) {
                    result6 = parse_identifier();
                    if (result6 !== null) {
                      result7 = parse_w();
                      if (result7 !== null) {
                        if (input.charCodeAt(pos) === 61) {
                          result8 = "=";
                          pos++;
                        } else {
                          result8 = null;
                          if (reportFailures === 0) {
                            matchFailed("\"=\"");
                          }
                        }
                        if (result8 !== null) {
                          result9 = parse_w();
                          if (result9 !== null) {
                            result10 = parse_constExpr();
                            if (result10 !== null) {
                              result11 = parse_w();
                              if (result11 !== null) {
                                if (input.charCodeAt(pos) === 59) {
                                  result12 = ";";
                                  pos++;
                                } else {
                                  result12 = null;
                                  if (reportFailures === 0) {
                                    matchFailed("\";\"");
                                  }
                                }
                                if (result12 !== null) {
                                  result13 = parse_w();
                                  if (result13 !== null) {
                                    result0 = [result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13];
                                  } else {
                                    result0 = null;
                                    pos = pos1;
                                  }
                                } else {
                                  result0 = null;
                                  pos = pos1;
                                }
                              } else {
                                result0 = null;
                                pos = pos1;
                              }
                            } else {
                              result0 = null;
                              pos = pos1;
                            }
                          } else {
                            result0 = null;
                            pos = pos1;
                          }
                        } else {
                          result0 = null;
                          pos = pos1;
                        }
                      } else {
                        result0 = null;
                        pos = pos1;
                      }
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, extAttrs, type, name, value) { return { type: "const", extAttrs: extAttrs, idlType: type, name: name, value: value }; })(pos0, result0[0], result0[4], result0[6], result0[10]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_constExpr() {
        var result0;
        var pos0;
        
        pos0 = pos;
        result0 = parse_BooleanLiteral();
        if (result0 === null) {
          result0 = parse_float();
          if (result0 === null) {
            result0 = parse_integer();
            if (result0 === null) {
              if (input.substr(pos, 3) === "NaN") {
                result0 = "NaN";
                pos += 3;
              } else {
                result0 = null;
                if (reportFailures === 0) {
                  matchFailed("\"NaN\"");
                }
              }
              if (result0 === null) {
                if (input.substr(pos, 4) === "null") {
                  result0 = "null";
                  pos += 4;
                } else {
                  result0 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"null\"");
                  }
                }
                if (result0 === null) {
                  if (input.charCodeAt(pos) === 39) {
                    result0 = "'";
                    pos++;
                  } else {
                    result0 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"'\"");
                    }
                  }
                }
              }
            }
          }
        }
        if (result0 !== null) {
          result0 = (function(offset, value) { return value; })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_attrOrOp() {
        var result0;
        var pos0;
        
        pos0 = pos;
        result0 = parse_Stringifier();
        if (result0 === null) {
          result0 = parse_Attribute();
          if (result0 === null) {
            result0 = parse_Operation();
          }
        }
        if (result0 !== null) {
          result0 = (function(offset, ao) { return ao; })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_Stringifier() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.substr(pos, 11) === "stringifier") {
          result0 = "stringifier";
          pos += 11;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"stringifier\"");
          }
        }
        if (result0 !== null) {
          result1 = parse_w();
          if (result1 !== null) {
            result2 = parse_Attribute();
            if (result2 === null) {
              result2 = parse_OperationRest();
              if (result2 === null) {
                if (input.charCodeAt(pos) === 59) {
                  result2 = ";";
                  pos++;
                } else {
                  result2 = null;
                  if (reportFailures === 0) {
                    matchFailed("\";\"");
                  }
                }
              }
            }
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, rest) {
                    if (rest === ";") return { type: "stringifier", stringifier: true };
                    else {
                        rest.stringifier = true;
                        return rest;
                    }
                })(pos0, result0[2]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_Attribute() {
        var result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13, result14;
        var pos0, pos1, pos2;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_ExtendedAttributeList();
        if (result0 !== null) {
          result1 = parse_w();
          if (result1 !== null) {
            pos2 = pos;
            if (input.substr(pos, 8) === "readonly") {
              result2 = "readonly";
              pos += 8;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"readonly\"");
              }
            }
            if (result2 !== null) {
              result3 = parse_s();
              if (result3 !== null) {
                result2 = [result2, result3];
              } else {
                result2 = null;
                pos = pos2;
              }
            } else {
              result2 = null;
              pos = pos2;
            }
            result2 = result2 !== null ? result2 : "";
            if (result2 !== null) {
              if (input.substr(pos, 9) === "attribute") {
                result3 = "attribute";
                pos += 9;
              } else {
                result3 = null;
                if (reportFailures === 0) {
                  matchFailed("\"attribute\"");
                }
              }
              if (result3 !== null) {
                result4 = parse_s();
                if (result4 !== null) {
                  result5 = parse_type();
                  if (result5 !== null) {
                    result6 = parse_s();
                    if (result6 !== null) {
                      result7 = parse_identifier();
                      if (result7 !== null) {
                        result8 = parse_w();
                        if (result8 !== null) {
                          result9 = parse_GetRaises();
                          result9 = result9 !== null ? result9 : "";
                          if (result9 !== null) {
                            result10 = parse_w();
                            if (result10 !== null) {
                              result11 = parse_SetRaises();
                              result11 = result11 !== null ? result11 : "";
                              if (result11 !== null) {
                                result12 = parse_w();
                                if (result12 !== null) {
                                  if (input.charCodeAt(pos) === 59) {
                                    result13 = ";";
                                    pos++;
                                  } else {
                                    result13 = null;
                                    if (reportFailures === 0) {
                                      matchFailed("\";\"");
                                    }
                                  }
                                  if (result13 !== null) {
                                    result14 = parse_w();
                                    if (result14 !== null) {
                                      result0 = [result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13, result14];
                                    } else {
                                      result0 = null;
                                      pos = pos1;
                                    }
                                  } else {
                                    result0 = null;
                                    pos = pos1;
                                  }
                                } else {
                                  result0 = null;
                                  pos = pos1;
                                }
                              } else {
                                result0 = null;
                                pos = pos1;
                              }
                            } else {
                              result0 = null;
                              pos = pos1;
                            }
                          } else {
                            result0 = null;
                            pos = pos1;
                          }
                        } else {
                          result0 = null;
                          pos = pos1;
                        }
                      } else {
                        result0 = null;
                        pos = pos1;
                      }
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, extAttrs, ro, type, name, gr, sr) { return { type: "attribute", extAttrs: extAttrs, idlType: type, name: name, readonly: (ro ? true : false), getraises: gr, setraises: sr }; })(pos0, result0[0], result0[2], result0[5], result0[7], result0[9], result0[11]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_GetRaises() {
        var result0, result1, result2, result3, result4;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.substr(pos, 9) === "getraises") {
          result0 = "getraises";
          pos += 9;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"getraises\"");
          }
        }
        if (result0 !== null) {
          result1 = parse_w();
          if (result1 !== null) {
            if (input.charCodeAt(pos) === 40) {
              result2 = "(";
              pos++;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"(\"");
              }
            }
            if (result2 !== null) {
              result3 = parse_ScopedNameList();
              if (result3 !== null) {
                if (input.charCodeAt(pos) === 41) {
                  result4 = ")";
                  pos++;
                } else {
                  result4 = null;
                  if (reportFailures === 0) {
                    matchFailed("\")\"");
                  }
                }
                if (result4 !== null) {
                  result0 = [result0, result1, result2, result3, result4];
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, list) { return list; })(pos0, result0[3]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_SetRaises() {
        var result0, result1, result2, result3, result4;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.substr(pos, 9) === "setraises") {
          result0 = "setraises";
          pos += 9;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"setraises\"");
          }
        }
        if (result0 !== null) {
          result1 = parse_w();
          if (result1 !== null) {
            if (input.charCodeAt(pos) === 40) {
              result2 = "(";
              pos++;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"(\"");
              }
            }
            if (result2 !== null) {
              result3 = parse_ScopedNameList();
              if (result3 !== null) {
                if (input.charCodeAt(pos) === 41) {
                  result4 = ")";
                  pos++;
                } else {
                  result4 = null;
                  if (reportFailures === 0) {
                    matchFailed("\")\"");
                  }
                }
                if (result4 !== null) {
                  result0 = [result0, result1, result2, result3, result4];
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, list) { return list; })(pos0, result0[3]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_Operation() {
        var result0, result1, result2, result3, result4;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_ExtendedAttributeList();
        if (result0 !== null) {
          result1 = parse_w();
          if (result1 !== null) {
            result2 = parse_Qualifiers();
            if (result2 !== null) {
              result3 = parse_w();
              if (result3 !== null) {
                result4 = parse_OperationRest();
                if (result4 !== null) {
                  result0 = [result0, result1, result2, result3, result4];
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, extAttrs, quals, rest) {
                    for (var k in quals) rest[k] = quals[k];
                    if (extAttrs) rest.extAttrs = extAttrs;
                    return rest;
                })(pos0, result0[0], result0[2], result0[4]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_Qualifiers() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_w();
        if (result0 !== null) {
          if (input.substr(pos, 6) === "static") {
            result1 = "static";
            pos += 6;
          } else {
            result1 = null;
            if (reportFailures === 0) {
              matchFailed("\"static\"");
            }
          }
          if (result1 === null) {
            result1 = [];
            result2 = parse_Special();
            while (result2 !== null) {
              result1.push(result2);
              result2 = parse_Special();
            }
          }
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, quals) {   if (typeof quals == "string") return [quals];
        		    return quals; })(pos0, result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_Special() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_w();
        if (result0 !== null) {
          if (input.substr(pos, 6) === "getter") {
            result1 = "getter";
            pos += 6;
          } else {
            result1 = null;
            if (reportFailures === 0) {
              matchFailed("\"getter\"");
            }
          }
          if (result1 === null) {
            if (input.substr(pos, 6) === "setter") {
              result1 = "setter";
              pos += 6;
            } else {
              result1 = null;
              if (reportFailures === 0) {
                matchFailed("\"setter\"");
              }
            }
            if (result1 === null) {
              if (input.substr(pos, 7) === "creator") {
                result1 = "creator";
                pos += 7;
              } else {
                result1 = null;
                if (reportFailures === 0) {
                  matchFailed("\"creator\"");
                }
              }
              if (result1 === null) {
                if (input.substr(pos, 7) === "deleter") {
                  result1 = "deleter";
                  pos += 7;
                } else {
                  result1 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"deleter\"");
                  }
                }
                if (result1 === null) {
                  if (input.substr(pos, 12) === "legacycaller") {
                    result1 = "legacycaller";
                    pos += 12;
                  } else {
                    result1 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"legacycaller\"");
                    }
                  }
                }
              }
            }
          }
          if (result1 !== null) {
            result2 = parse_w();
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, spe) { return spe; })(pos0, result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_OperationRest() {
        var result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_ReturnType();
        if (result0 !== null) {
          result1 = parse_s();
          if (result1 !== null) {
            result2 = parse_identifier();
            result2 = result2 !== null ? result2 : "";
            if (result2 !== null) {
              result3 = parse_w();
              if (result3 !== null) {
                if (input.charCodeAt(pos) === 40) {
                  result4 = "(";
                  pos++;
                } else {
                  result4 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"(\"");
                  }
                }
                if (result4 !== null) {
                  result5 = parse_w();
                  if (result5 !== null) {
                    result6 = parse_Arguments();
                    result6 = result6 !== null ? result6 : "";
                    if (result6 !== null) {
                      result7 = parse_w();
                      if (result7 !== null) {
                        if (input.charCodeAt(pos) === 41) {
                          result8 = ")";
                          pos++;
                        } else {
                          result8 = null;
                          if (reportFailures === 0) {
                            matchFailed("\")\"");
                          }
                        }
                        if (result8 !== null) {
                          result9 = parse_w();
                          if (result9 !== null) {
                            result10 = parse_Raises();
                            result10 = result10 !== null ? result10 : "";
                            if (result10 !== null) {
                              result11 = parse_w();
                              if (result11 !== null) {
                                if (input.charCodeAt(pos) === 59) {
                                  result12 = ";";
                                  pos++;
                                } else {
                                  result12 = null;
                                  if (reportFailures === 0) {
                                    matchFailed("\";\"");
                                  }
                                }
                                if (result12 !== null) {
                                  result13 = parse_w();
                                  if (result13 !== null) {
                                    result0 = [result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13];
                                  } else {
                                    result0 = null;
                                    pos = pos1;
                                  }
                                } else {
                                  result0 = null;
                                  pos = pos1;
                                }
                              } else {
                                result0 = null;
                                pos = pos1;
                              }
                            } else {
                              result0 = null;
                              pos = pos1;
                            }
                          } else {
                            result0 = null;
                            pos = pos1;
                          }
                        } else {
                          result0 = null;
                          pos = pos1;
                        }
                      } else {
                        result0 = null;
                        pos = pos1;
                      }
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, ret, name, args, exc) { return { type: "operation", idlType: ret, name: name, arguments: (args ? args : []), raises: exc }; })(pos0, result0[0], result0[2], result0[6], result0[10]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_Arguments() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_Argument();
        if (result0 !== null) {
          result1 = [];
          result2 = parse_ArgumentsRest();
          while (result2 !== null) {
            result1.push(result2);
            result2 = parse_ArgumentsRest();
          }
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, first, others) {   var ret = [first];
                    for (var i = 0, n = others.length; i < n; i++) { ret.push(others[i]); }
                    return ret; })(pos0, result0[0], result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_ArgumentsRest() {
        var result0, result1, result2, result3;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_w();
        if (result0 !== null) {
          if (input.charCodeAt(pos) === 44) {
            result1 = ",";
            pos++;
          } else {
            result1 = null;
            if (reportFailures === 0) {
              matchFailed("\",\"");
            }
          }
          if (result1 !== null) {
            result2 = parse_w();
            if (result2 !== null) {
              result3 = parse_Argument();
              if (result3 !== null) {
                result0 = [result0, result1, result2, result3];
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, rest) { return rest; })(pos0, result0[3]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_Argument() {
        var result0, result1, result2, result3, result4, result5, result6, result7, result8, result9;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_ExtendedAttributeList();
        if (result0 !== null) {
          result1 = parse_w();
          if (result1 !== null) {
            if (input.substr(pos, 2) === "in") {
              result2 = "in";
              pos += 2;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"in\"");
              }
            }
            result2 = result2 !== null ? result2 : "";
            if (result2 !== null) {
              result3 = parse_w();
              if (result3 !== null) {
                if (input.substr(pos, 8) === "optional") {
                  result4 = "optional";
                  pos += 8;
                } else {
                  result4 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"optional\"");
                  }
                }
                result4 = result4 !== null ? result4 : "";
                if (result4 !== null) {
                  result5 = parse_w();
                  if (result5 !== null) {
                    result6 = parse_type();
                    if (result6 !== null) {
                      if (input.substr(pos, 3) === "...") {
                        result7 = "...";
                        pos += 3;
                      } else {
                        result7 = null;
                        if (reportFailures === 0) {
                          matchFailed("\"...\"");
                        }
                      }
                      result7 = result7 !== null ? result7 : "";
                      if (result7 !== null) {
                        result8 = parse_s();
                        if (result8 !== null) {
                          result9 = parse_identifier();
                          if (result9 !== null) {
                            result0 = [result0, result1, result2, result3, result4, result5, result6, result7, result8, result9];
                          } else {
                            result0 = null;
                            pos = pos1;
                          }
                        } else {
                          result0 = null;
                          pos = pos1;
                        }
                      } else {
                        result0 = null;
                        pos = pos1;
                      }
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, extAttrs, opt, type, ell, name) { return { name: name, type: type, variadic: (ell ? true : false), optional: (opt ? true : false), extAttrs: extAttrs }; })(pos0, result0[0], result0[4], result0[6], result0[7], result0[9]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_Raises() {
        var result0, result1, result2, result3, result4, result5, result6;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.substr(pos, 6) === "raises") {
          result0 = "raises";
          pos += 6;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"raises\"");
          }
        }
        if (result0 !== null) {
          result1 = parse_s();
          if (result1 !== null) {
            if (input.charCodeAt(pos) === 40) {
              result2 = "(";
              pos++;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"(\"");
              }
            }
            if (result2 !== null) {
              result3 = parse_w();
              if (result3 !== null) {
                result4 = parse_ScopedNameList();
                if (result4 !== null) {
                  result5 = parse_w();
                  if (result5 !== null) {
                    if (input.charCodeAt(pos) === 41) {
                      result6 = ")";
                      pos++;
                    } else {
                      result6 = null;
                      if (reportFailures === 0) {
                        matchFailed("\")\"");
                      }
                    }
                    if (result6 !== null) {
                      result0 = [result0, result1, result2, result3, result4, result5, result6];
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, list) { return list; })(pos0, result0[4]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_dictionary() {
        var result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.substr(pos, 10) === "dictionary") {
          result0 = "dictionary";
          pos += 10;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"dictionary\"");
          }
        }
        if (result0 !== null) {
          result1 = parse_s();
          if (result1 !== null) {
            result2 = parse_identifier();
            if (result2 !== null) {
              result3 = parse_w();
              if (result3 !== null) {
                result4 = parse_Inheritance();
                if (result4 !== null) {
                  result5 = parse_w();
                  if (result5 !== null) {
                    if (input.charCodeAt(pos) === 123) {
                      result6 = "{";
                      pos++;
                    } else {
                      result6 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"{\"");
                      }
                    }
                    if (result6 !== null) {
                      result7 = parse_w();
                      if (result7 !== null) {
                        result8 = parse_DictionaryMemberList();
                        if (result8 !== null) {
                          result9 = parse_w();
                          if (result9 !== null) {
                            if (input.charCodeAt(pos) === 125) {
                              result10 = "}";
                              pos++;
                            } else {
                              result10 = null;
                              if (reportFailures === 0) {
                                matchFailed("\"}\"");
                              }
                            }
                            if (result10 !== null) {
                              result11 = parse_w();
                              if (result11 !== null) {
                                if (input.charCodeAt(pos) === 59) {
                                  result12 = ";";
                                  pos++;
                                } else {
                                  result12 = null;
                                  if (reportFailures === 0) {
                                    matchFailed("\";\"");
                                  }
                                }
                                if (result12 !== null) {
                                  result13 = parse_w();
                                  if (result13 !== null) {
                                    result0 = [result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13];
                                  } else {
                                    result0 = null;
                                    pos = pos1;
                                  }
                                } else {
                                  result0 = null;
                                  pos = pos1;
                                }
                              } else {
                                result0 = null;
                                pos = pos1;
                              }
                            } else {
                              result0 = null;
                              pos = pos1;
                            }
                          } else {
                            result0 = null;
                            pos = pos1;
                          }
                        } else {
                          result0 = null;
                          pos = pos1;
                        }
                      } else {
                        result0 = null;
                        pos = pos1;
                      }
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, name, superclass, members) {
                        return {
                            type: "dictionary",
                            name: name,
                            inheritance: superclass,
                            members: members
                        };
                    })(pos0, result0[2], result0[4], result0[8]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_DictionaryMemberList() {
        var result0, result1;
        var pos0;
        
        pos0 = pos;
        result0 = [];
        result1 = parse_DictionaryMember();
        while (result1 !== null) {
          result0.push(result1);
          result1 = parse_DictionaryMember();
        }
        if (result0 !== null) {
          result0 = (function(offset, mem) { return mem ? mem : []; })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_DictionaryMember() {
        var result0, result1, result2, result3, result4, result5, result6, result7, result8, result9;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_ExtendedAttributeList();
        if (result0 !== null) {
          result1 = parse_w();
          if (result1 !== null) {
            result2 = parse_type();
            if (result2 !== null) {
              result3 = parse_s();
              if (result3 !== null) {
                result4 = parse_identifier();
                if (result4 !== null) {
                  result5 = parse_w();
                  if (result5 !== null) {
                    result6 = parse_defaultValue();
                    result6 = result6 !== null ? result6 : "";
                    if (result6 !== null) {
                      result7 = parse_w();
                      if (result7 !== null) {
                        if (input.charCodeAt(pos) === 59) {
                          result8 = ";";
                          pos++;
                        } else {
                          result8 = null;
                          if (reportFailures === 0) {
                            matchFailed("\";\"");
                          }
                        }
                        if (result8 !== null) {
                          result9 = parse_w();
                          if (result9 !== null) {
                            result0 = [result0, result1, result2, result3, result4, result5, result6, result7, result8, result9];
                          } else {
                            result0 = null;
                            pos = pos1;
                          }
                        } else {
                          result0 = null;
                          pos = pos1;
                        }
                      } else {
                        result0 = null;
                        pos = pos1;
                      }
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, extAttrs, type, name, defaultValue) {
                     return {
                         type: type,
                         name: name,
                         defaultValue: defaultValue
                     };
                 })(pos0, result0[0], result0[2], result0[4], result0[6]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_defaultValue() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.charCodeAt(pos) === 61) {
          result0 = "=";
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"=\"");
          }
        }
        if (result0 !== null) {
          result1 = parse_w();
          if (result1 !== null) {
            result2 = parse_constExpr();
            if (result2 === null) {
              result2 = parse_string();
            }
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, value) { return value; })(pos0, result0[2]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_typedef() {
        var result0, result1, result2, result3, result4, result5, result6, result7;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.substr(pos, 7) === "typedef") {
          result0 = "typedef";
          pos += 7;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"typedef\"");
          }
        }
        if (result0 !== null) {
          result1 = parse_s();
          if (result1 !== null) {
            result2 = parse_type();
            if (result2 !== null) {
              result3 = parse_s();
              if (result3 !== null) {
                result4 = parse_identifier();
                if (result4 !== null) {
                  result5 = parse_w();
                  if (result5 !== null) {
                    if (input.charCodeAt(pos) === 59) {
                      result6 = ";";
                      pos++;
                    } else {
                      result6 = null;
                      if (reportFailures === 0) {
                        matchFailed("\";\"");
                      }
                    }
                    if (result6 !== null) {
                      result7 = parse_w();
                      if (result7 !== null) {
                        result0 = [result0, result1, result2, result3, result4, result5, result6, result7];
                      } else {
                        result0 = null;
                        pos = pos1;
                      }
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, type, name) { return { type: 'typedef', name: name, idlType: type }; })(pos0, result0[2], result0[4]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_exception() {
        var result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13, result14, result15;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_ExtendedAttributeList();
        if (result0 !== null) {
          result1 = parse_w();
          if (result1 !== null) {
            if (input.substr(pos, 9) === "exception") {
              result2 = "exception";
              pos += 9;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"exception\"");
              }
            }
            if (result2 !== null) {
              result3 = parse_s();
              if (result3 !== null) {
                result4 = parse_identifier();
                if (result4 !== null) {
                  result5 = parse_w();
                  if (result5 !== null) {
                    result6 = parse_Inheritance();
                    if (result6 !== null) {
                      result7 = parse_w();
                      if (result7 !== null) {
                        if (input.charCodeAt(pos) === 123) {
                          result8 = "{";
                          pos++;
                        } else {
                          result8 = null;
                          if (reportFailures === 0) {
                            matchFailed("\"{\"");
                          }
                        }
                        if (result8 !== null) {
                          result9 = parse_w();
                          if (result9 !== null) {
                            result10 = parse_ExceptionMembers();
                            if (result10 !== null) {
                              result11 = parse_w();
                              if (result11 !== null) {
                                if (input.charCodeAt(pos) === 125) {
                                  result12 = "}";
                                  pos++;
                                } else {
                                  result12 = null;
                                  if (reportFailures === 0) {
                                    matchFailed("\"}\"");
                                  }
                                }
                                if (result12 !== null) {
                                  result13 = parse_w();
                                  if (result13 !== null) {
                                    if (input.charCodeAt(pos) === 59) {
                                      result14 = ";";
                                      pos++;
                                    } else {
                                      result14 = null;
                                      if (reportFailures === 0) {
                                        matchFailed("\";\"");
                                      }
                                    }
                                    if (result14 !== null) {
                                      result15 = parse_w();
                                      if (result15 !== null) {
                                        result0 = [result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13, result14, result15];
                                      } else {
                                        result0 = null;
                                        pos = pos1;
                                      }
                                    } else {
                                      result0 = null;
                                      pos = pos1;
                                    }
                                  } else {
                                    result0 = null;
                                    pos = pos1;
                                  }
                                } else {
                                  result0 = null;
                                  pos = pos1;
                                }
                              } else {
                                result0 = null;
                                pos = pos1;
                              }
                            } else {
                              result0 = null;
                              pos = pos1;
                            }
                          } else {
                            result0 = null;
                            pos = pos1;
                          }
                        } else {
                          result0 = null;
                          pos = pos1;
                        }
                      } else {
                        result0 = null;
                        pos = pos1;
                      }
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, extAttrs, name, herit, mem) {
                    return {
                        type: 'exception',
                        name: name,
                        inheritance: herit,
                        members: mem,
                        extAttrs: extAttrs,
                    };
                })(pos0, result0[0], result0[4], result0[6], result0[10]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_ExceptionMembers() {
        var result0, result1;
        var pos0;
        
        pos0 = pos;
        result0 = [];
        result1 = parse_ExceptionMember();
        while (result1 !== null) {
          result0.push(result1);
          result1 = parse_ExceptionMember();
        }
        if (result0 !== null) {
          result0 = (function(offset, mem) { return mem ? mem : []; })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_ExceptionMember() {
        var result0;
        var pos0;
        
        pos0 = pos;
        result0 = parse_const();
        if (result0 === null) {
          result0 = parse_field();
        }
        if (result0 !== null) {
          result0 = (function(offset, mem) { return mem; })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_field() {
        var result0, result1, result2, result3, result4, result5, result6, result7;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_ExtendedAttributeList();
        if (result0 !== null) {
          result1 = parse_s();
          result1 = result1 !== null ? result1 : "";
          if (result1 !== null) {
            result2 = parse_type();
            if (result2 !== null) {
              result3 = parse_s();
              if (result3 !== null) {
                result4 = parse_identifier();
                if (result4 !== null) {
                  result5 = parse_w();
                  if (result5 !== null) {
                    if (input.charCodeAt(pos) === 59) {
                      result6 = ";";
                      pos++;
                    } else {
                      result6 = null;
                      if (reportFailures === 0) {
                        matchFailed("\";\"");
                      }
                    }
                    if (result6 !== null) {
                      result7 = parse_w();
                      if (result7 !== null) {
                        result0 = [result0, result1, result2, result3, result4, result5, result6, result7];
                      } else {
                        result0 = null;
                        pos = pos1;
                      }
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, extAttrs, type, name) { return { type: "field", extAttrs: extAttrs, idlType: type, name: name }; })(pos0, result0[0], result0[2], result0[4]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_ExtendedAttributeList() {
        var result0;
        var pos0;
        
        pos0 = pos;
        result0 = parse_ExtendedAttributeListInner();
        result0 = result0 !== null ? result0 : "";
        if (result0 !== null) {
          result0 = (function(offset, ea) { return ea ? ea : []; })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_ExtendedAttributeListInner() {
        var result0, result1, result2, result3, result4, result5, result6;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_w();
        if (result0 !== null) {
          if (input.charCodeAt(pos) === 91) {
            result1 = "[";
            pos++;
          } else {
            result1 = null;
            if (reportFailures === 0) {
              matchFailed("\"[\"");
            }
          }
          if (result1 !== null) {
            result2 = parse_w();
            if (result2 !== null) {
              result3 = parse_ExtAttrs();
              if (result3 !== null) {
                result4 = parse_w();
                if (result4 !== null) {
                  if (input.charCodeAt(pos) === 93) {
                    result5 = "]";
                    pos++;
                  } else {
                    result5 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"]\"");
                    }
                  }
                  if (result5 !== null) {
                    result6 = parse_w();
                    if (result6 !== null) {
                      result0 = [result0, result1, result2, result3, result4, result5, result6];
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, ea) { return ea; })(pos0, result0[3]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_ExtAttrs() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_ExtAttr();
        if (result0 !== null) {
          result1 = [];
          result2 = parse_ExtAttrsRest();
          while (result2 !== null) {
            result1.push(result2);
            result2 = parse_ExtAttrsRest();
          }
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, first, others) {   var ret = [first];
                    for (var i = 0, n = others.length; i < n; i++) { ret.push(others[i]); }
                    return ret; })(pos0, result0[0], result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_ExtAttrsRest() {
        var result0, result1, result2, result3;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_w();
        if (result0 !== null) {
          if (input.charCodeAt(pos) === 44) {
            result1 = ",";
            pos++;
          } else {
            result1 = null;
            if (reportFailures === 0) {
              matchFailed("\",\"");
            }
          }
          if (result1 !== null) {
            result2 = parse_w();
            if (result2 !== null) {
              result3 = parse_ExtAttr();
              if (result3 !== null) {
                result0 = [result0, result1, result2, result3];
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, rest) { return rest; })(pos0, result0[3]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_ExtAttr() {
        var result0;
        var pos0;
        
        pos0 = pos;
        result0 = parse_ExtAttrArgList();
        if (result0 === null) {
          result0 = parse_ExtAttrNamedArgList();
          if (result0 === null) {
            result0 = parse_ExtAttrNameValue();
            if (result0 === null) {
              result0 = parse_ExtAttrNoArg();
            }
          }
        }
        if (result0 !== null) {
          result0 = (function(offset, ea) { return ea; })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_ExtAttrNoArg() {
        var result0;
        var pos0;
        
        pos0 = pos;
        result0 = parse_identifier();
        if (result0 !== null) {
          result0 = (function(offset, name) {return { name: name }; })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_ExtAttrNameValue() {
        var result0, result1, result2, result3, result4;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_identifier();
        if (result0 !== null) {
          result1 = parse_w();
          if (result1 !== null) {
            if (input.charCodeAt(pos) === 61) {
              result2 = "=";
              pos++;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"=\"");
              }
            }
            if (result2 !== null) {
              result3 = parse_w();
              if (result3 !== null) {
                result4 = parse_ScopedName();
                if (result4 !== null) {
                  result0 = [result0, result1, result2, result3, result4];
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, name, value) {return { name: name, value: value }; })(pos0, result0[0], result0[4]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_ExtAttrNamedArgList() {
        var result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_identifier();
        if (result0 !== null) {
          result1 = parse_w();
          if (result1 !== null) {
            if (input.charCodeAt(pos) === 61) {
              result2 = "=";
              pos++;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"=\"");
              }
            }
            if (result2 !== null) {
              result3 = parse_w();
              if (result3 !== null) {
                result4 = parse_identifier();
                if (result4 !== null) {
                  result5 = parse_w();
                  if (result5 !== null) {
                    if (input.charCodeAt(pos) === 40) {
                      result6 = "(";
                      pos++;
                    } else {
                      result6 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"(\"");
                      }
                    }
                    if (result6 !== null) {
                      result7 = parse_w();
                      if (result7 !== null) {
                        result8 = parse_Arguments();
                        result8 = result8 !== null ? result8 : "";
                        if (result8 !== null) {
                          result9 = parse_w();
                          if (result9 !== null) {
                            if (input.charCodeAt(pos) === 41) {
                              result10 = ")";
                              pos++;
                            } else {
                              result10 = null;
                              if (reportFailures === 0) {
                                matchFailed("\")\"");
                              }
                            }
                            if (result10 !== null) {
                              result0 = [result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10];
                            } else {
                              result0 = null;
                              pos = pos1;
                            }
                          } else {
                            result0 = null;
                            pos = pos1;
                          }
                        } else {
                          result0 = null;
                          pos = pos1;
                        }
                      } else {
                        result0 = null;
                        pos = pos1;
                      }
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, name, value, args) {return { name: name, value: value, arguments: args }; })(pos0, result0[0], result0[4], result0[8]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_ExtAttrNamedArgList() {
        var result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_identifier();
        if (result0 !== null) {
          result1 = parse_w();
          if (result1 !== null) {
            if (input.charCodeAt(pos) === 61) {
              result2 = "=";
              pos++;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"=\"");
              }
            }
            if (result2 !== null) {
              result3 = parse_w();
              if (result3 !== null) {
                result4 = parse_identifier();
                if (result4 !== null) {
                  result5 = parse_w();
                  if (result5 !== null) {
                    if (input.charCodeAt(pos) === 40) {
                      result6 = "(";
                      pos++;
                    } else {
                      result6 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"(\"");
                      }
                    }
                    if (result6 !== null) {
                      result7 = parse_w();
                      if (result7 !== null) {
                        result8 = parse_Arguments();
                        result8 = result8 !== null ? result8 : "";
                        if (result8 !== null) {
                          result9 = parse_w();
                          if (result9 !== null) {
                            if (input.charCodeAt(pos) === 41) {
                              result10 = ")";
                              pos++;
                            } else {
                              result10 = null;
                              if (reportFailures === 0) {
                                matchFailed("\")\"");
                              }
                            }
                            if (result10 !== null) {
                              result0 = [result0, result1, result2, result3, result4, result5, result6, result7, result8, result9, result10];
                            } else {
                              result0 = null;
                              pos = pos1;
                            }
                          } else {
                            result0 = null;
                            pos = pos1;
                          }
                        } else {
                          result0 = null;
                          pos = pos1;
                        }
                      } else {
                        result0 = null;
                        pos = pos1;
                      }
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, name, value, args) {return { name: name, value: value, arguments: args }; })(pos0, result0[0], result0[4], result0[8]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_ExtAttrArgList() {
        var result0, result1, result2, result3, result4, result5, result6;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_identifier();
        if (result0 !== null) {
          result1 = parse_w();
          if (result1 !== null) {
            if (input.charCodeAt(pos) === 40) {
              result2 = "(";
              pos++;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"(\"");
              }
            }
            if (result2 !== null) {
              result3 = parse_w();
              if (result3 !== null) {
                result4 = parse_Arguments();
                result4 = result4 !== null ? result4 : "";
                if (result4 !== null) {
                  result5 = parse_w();
                  if (result5 !== null) {
                    if (input.charCodeAt(pos) === 41) {
                      result6 = ")";
                      pos++;
                    } else {
                      result6 = null;
                      if (reportFailures === 0) {
                        matchFailed("\")\"");
                      }
                    }
                    if (result6 !== null) {
                      result0 = [result0, result1, result2, result3, result4, result5, result6];
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, name, args) {return { name: name, arguments: args }; })(pos0, result0[0], result0[4]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      
      function cleanupExpected(expected) {
        expected.sort();
        
        var lastExpected = null;
        var cleanExpected = [];
        for (var i = 0; i < expected.length; i++) {
          if (expected[i] !== lastExpected) {
            cleanExpected.push(expected[i]);
            lastExpected = expected[i];
          }
        }
        return cleanExpected;
      }
      
      function computeErrorPosition() {
        /*
         * The first idea was to use |String.split| to break the input up to the
         * error position along newlines and derive the line and column from
         * there. However IE's |split| implementation is so broken that it was
         * enough to prevent it.
         */
        
        var line = 1;
        var column = 1;
        var seenCR = false;
        
        for (var i = 0; i < Math.max(pos, rightmostFailuresPos); i++) {
          var ch = input.charAt(i);
          if (ch === "\n") {
            if (!seenCR) { line++; }
            column = 1;
            seenCR = false;
          } else if (ch === "\r" || ch === "\u2028" || ch === "\u2029") {
            line++;
            column = 1;
            seenCR = true;
          } else {
            column++;
            seenCR = false;
          }
        }
        
        return { line: line, column: column };
      }
      
      
      var result = parseFunctions[startRule]();
      
      /*
       * The parser is now in one of the following three states:
       *
       * 1. The parser successfully parsed the whole input.
       *
       *    - |result !== null|
       *    - |pos === input.length|
       *    - |rightmostFailuresExpected| may or may not contain something
       *
       * 2. The parser successfully parsed only a part of the input.
       *
       *    - |result !== null|
       *    - |pos < input.length|
       *    - |rightmostFailuresExpected| may or may not contain something
       *
       * 3. The parser did not successfully parse any part of the input.
       *
       *   - |result === null|
       *   - |pos === 0|
       *   - |rightmostFailuresExpected| contains at least one failure
       *
       * All code following this comment (including called functions) must
       * handle these states.
       */
      if (result === null || pos !== input.length) {
        var offset = Math.max(pos, rightmostFailuresPos);
        var found = offset < input.length ? input.charAt(offset) : null;
        var errorPosition = computeErrorPosition();
        
        throw new this.SyntaxError(
          cleanupExpected(rightmostFailuresExpected),
          found,
          offset,
          errorPosition.line,
          errorPosition.column
        );
      }
      
      return result;
    },
    
    /* Returns the parser source code. */
    toSource: function() { return this._source; }
  };
  
  /* Thrown when a parser encounters a syntax error. */
  
  result.SyntaxError = function(expected, found, offset, line, column) {
    function buildMessage(expected, found) {
      var expectedHumanized, foundHumanized;
      
      switch (expected.length) {
        case 0:
          expectedHumanized = "end of input";
          break;
        case 1:
          expectedHumanized = expected[0];
          break;
        default:
          expectedHumanized = expected.slice(0, expected.length - 1).join(", ")
            + " or "
            + expected[expected.length - 1];
      }
      
      foundHumanized = found ? quote(found) : "end of input";
      
      return "Expected " + expectedHumanized + " but " + foundHumanized + " found.";
    }
    
    this.name = "SyntaxError";
    this.expected = expected;
    this.found = found;
    this.message = buildMessage(expected, found);
    this.offset = offset;
    this.line = line;
    this.column = column;
  };
  
  result.SyntaxError.prototype = Error.prototype;
  
  return result;
})();
