/* This file is generated by python scripts. Don't edit this file directly.
 */

#ifndef __PY_LIB_PINYIN_EMOJI_TABLE_H
#define __PY_LIB_PINYIN_EMOJI_TABLE_H

namespace PY{

typedef struct {
    const char * m_emoji_match;
    const char * m_emoji_string;
} EmojiItem;

const EmojiItem english_emoji_table[] = {
"a"       , "🅰",
"ab"      , "🆎",
"abacus"  , "🧮",
"abc"     , "🔤",
"abcd"    , "🔡",
"access"  , "♿",
"actor"   , "👨‍🎤",
"adore"   , "🥰",
"adult"   , "🧑",
"aerial"  , "🚡",
"afro"    , "🦱",
"aid"     , "⛑",
"alarm"   , "⏰",
"alien"   , "👽",
"alpaca"  , "🦙",
"amoeba"  , "🦠",
"anchor"  , "⚓",
"angel"   , "😇",
"angry"   , "😡",
"ant"     , "🐜",
"apple"   , "🍎",
"archer"  , "🏹",
"arrow"   , "💘",
"art"     , "🎭",
"artist"  , "👨‍🎨",
"ashes"   , "⚱",
"ask"     , "🙏",
"atm"     , "🏧",
"atom"    , "⚛",
"autumn"  , "🥮",
"b"       , "🅱",
"baby"    , "👶",
"back"    , "🔙",
"bacon"   , "🥓",
"badge"   , "📛",
"badger"  , "🦡",
"bag"     , "👜",
"bagel"   , "🥯",
"bakery"  , "🥯",
"bald"    , "🦲",
"ball"    , "🥍",
"ballot"  , "🗳",
"bamboo"  , "🎍",
"banana"  , "🍌",
"bank"    , "🏦",
"banner"  , "🎋",
"bar"     , "🧼",
"barber"  , "💇",
"basket"  , "🧺",
"bat"     , "🦇",
"bath"    , "🛀",
"beach"   , "🏖",
"beacon"  , "🚨",
"bead"    , "🧿",
"beads"   , "📿",
"bear"    , "🐻",
"beard"   , "🧔",
"bearer"  , "🐍",
"beauty"  , "💇",
"bed"     , "🛏",
"bee"     , "🐝",
"beer"    , "🍺",
"beetle"  , "🐞",
"bell"    , "🛎",
"bento"   , "🍱",
"berry"   , "🍓",
"biceps"  , "💪",
"bike"    , "🚵",
"biking"  , "🚴",
"bikini"  , "👙",
"bill"    , "💴",
"bird"    , "🦚",
"birdie"  , "🏸",
"bisque"  , "🦞",
"black"   , "🖤",
"blond"   , "👱",
"blonde"  , "👱‍♀",
"blow"    , "🍃",
"blue"    , "😰",
"blush"   , "😊",
"boar"    , "🐗",
"board"   , "🛹",
"boat"    , "🚣",
"body"    , "👂",
"bolt"    , "🔩",
"bomb"    , "💣",
"bone"    , "🦴",
"book"    , "📔",
"books"   , "📚",
"boom"    , "💥",
"boot"    , "🥾",
"bottle"  , "🍼",
"bow"     , "🙇",
"bowing"  , "🙇‍♂",
"bowl"    , "🍜",
"box"     , "🍱",
"boxing"  , "🥊",
"boy"     , "👦",
"brain"   , "🧠",
"bread"   , "🍞",
"break"   , "💔",
"breast"  , "🤱",
"brick"   , "🧱",
"bricks"  , "🧱",
"bride"   , "👰",
"bridge"  , "🌉",
"bright"  , "😎",
"broken"  , "💔",
"bronze"  , "🥉",
"broom"   , "🧹",
"bubble"  , "💬",
"bug"     , "🐛",
"bulb"    , "💡",
"bull"    , "🐂",
"bullet"  , "🚅",
"bunny"   , "🐰",
"burger"  , "🍔",
"bus"     , "🚌",
"bust"    , "👤",
"button"  , "🔼",
"cable"   , "🚠",
"cactus"  , "🌵",
"cake"    , "🍥",
"call"    , "🤙",
"camel"   , "🐪",
"camera"  , "🤳",
"can"     , "🥫",
"cancel"  , "✖",
"candle"  , "🕯",
"candy"   , "🍬",
"canoe"   , "🛶",
"cap"     , "🎓",
"car"     , "🏎",
"card"    , "♠",
"care"    , "💅",
"carp"    , "🎏",
"carrot"  , "🥕",
"cart"    , "🛒",
"castle"  , "🏯",
"cat"     , "😺",
"cd"      , "💿",
"cell"    , "📱",
"cereal"  , "🥣",
"chain"   , "⛓",
"chains"  , "⛓",
"chair"   , "💺",
"chapel"  , "💒",
"charm"   , "🧿",
"chart"   , "💹",
"check"   , "✅",
"cheese"  , "🧀",
"chef"    , "👨‍🍳",
"cherry"  , "🌸",
"chess"   , "♟",
"chest"   , "🧰",
"chick"   , "🐣",
"child"   , "🧒",
"chime"   , "🎐",
"chop"    , "🥩",
"church"  , "⛪",
"cinema"  , "🎥",
"circle"  , "⏺",
"circus"  , "🎪",
"citrus"  , "🍋",
"city"    , "🏙",
"cl"      , "🆑",
"claim"   , "🛄",
"clamp"   , "🗜",
"clap"    , "👏",
"claus"   , "🎅",
"claws"   , "🦞",
"clay"    , "🧱",
"clink"   , "🍻",
"clock"   , "⌚",
"closed"  , "😚",
"closet"  , "🚾",
"cloud"   , "☁",
"clover"  , "🍀",
"clown"   , "🤡",
"clue"    , "🧩",
"coat"    , "🧥",
"coder"   , "👨‍💻",
"coffee"  , "☕",
"coffin"  , "⚰",
"cog"     , "⚙",
"coin"    , "👛",
"cold"    , "🥶",
"comet"   , "☄",
"comic"   , "💪",
"congee"  , "🥣",
"cook"    , "👨‍🍳",
"cooked"  , "🍚",
"cookie"  , "🍪",
"cool"    , "😎",
"cop"     , "👮",
"cork"    , "🍾",
"corn"    , "🌽",
"couch"   , "🛋",
"couple"  , "👫",
"cover"   , "📔",
"cow"     , "🐮",
"cowboy"  , "🤠",
"crab"    , "🦀",
"crayon"  , "🖍",
"cream"   , "🍦",
"credit"  , "💳",
"cross"   , "🤞",
"crown"   , "👑",
"crush"   , "🥰",
"cry"     , "😢",
"cup"     , "🍵",
"cupid"   , "💘",
"curl"    , "📃",
"curly"   , "🦱",
"curry"   , "🍛",
"cygnet"  , "🦢",
"dagger"  , "🗡",
"dance"   , "🕺",
"dancer"  , "👯",
"danger"  , "⚡",
"dango"   , "🍡",
"dark"    , "🕶",
"dart"    , "🎯",
"dash"    , "💨",
"date"    , "📅",
"dazed"   , "😳",
"death"   , "💀",
"deer"    , "🦌",
"demon"   , "👿",
"desert"  , "🏜",
"devil"   , "👿",
"dharma"  , "☸",
"dialog"  , "💬",
"diaper"  , "🧷",
"dice"    , "🎲",
"die"     , "🎲",
"diesel"  , "⛽",
"dim"     , "🔅",
"dish"    , "📡",
"disk"    , "💽",
"dizzy"   , "🥴",
"djinn"   , "🧞",
"dna"     , "🧬",
"doctor"  , "🥼",
"dog"     , "🐶",
"doll"    , "🎎",
"dollar"  , "💰",
"donut"   , "🍩",
"door"    , "🚪",
"double"  , "⏩",
"doubt"   , "🤷",
"dove"    , "🕊",
"down"    , "👇",
"dragon"  , "🐲",
"dress"   , "👗",
"drink"   , "🍼",
"drop"    , "☔",
"drum"    , "🛢",
"duck"    , "🦆",
"dung"    , "💩",
"dupe"    , "♟",
"dusk"    , "🌆",
"dvd"     , "📀",
"eagle"   , "🦅",
"ear"     , "👂",
"earbud"  , "🎧",
"earth"   , "🌍",
"east"    , "➡",
"egg"     , "🥚",
"eight"   , "🕗",
"eject"   , "⏏",
"eleven"  , "🕚",
"elf"     , "🧝",
"email"   , "✉",
"emblem"  , "🔱",
"end"     , "🔚",
"engine"  , "🚂",
"entry"   , "⛔",
"euro"    , "💶",
"evil"    , "🦹",
"ewe"     , "🐑",
"eye"     , "😁",
"eyes"    , "🤩",
"face"    , "😀",
"fairy"   , "🧚",
"family"  , "👪",
"farmer"  , "👨‍🌾",
"fast"    , "⏩",
"father"  , "🎅",
"favor"   , "🙇‍♂",
"fax"     , "📠",
"fear"    , "😨",
"feet"    , "🐾",
"female"  , "🐑",
"fencer"  , "🤺",
"ferris"  , "🎡",
"ferry"   , "⛴",
"fever"   , "🦟",
"field"   , "🏑",
"file"    , "📁",
"filing"  , "🗄",
"film"    , "🎞",
"finger"  , "👈",
"fire"    , "🧯",
"first"   , "🥇",
"fish"    , "🐟",
"fist"    , "✊",
"five"    , "🕔",
"flame"   , "🔥",
"flash"   , "📸",
"flex"    , "💪",
"floor"   , "🤣",
"floppy"  , "💾",
"flower"  , "💐",
"fly"     , "🕊",
"fog"     , "🌁",
"foggy"   , "🌁",
"folder"  , "📁",
"food"    , "🦐",
"foot"    , "🦶",
"fork"    , "🍽",
"four"    , "🍀",
"fox"     , "🦊",
"frame"   , "🖼",
"frames"  , "🎞",
"free"    , "🆓",
"french"  , "🥐",
"fried"   , "🍤",
"fries"   , "🍟",
"frog"    , "🐸",
"frown"   , "☹",
"fruit"   , "🥭",
"frying"  , "🍳",
"fuel"    , "⛽",
"fuji"    , "🗻",
"full"    , "🌕",
"game"    , "🏐",
"garden"  , "🏡",
"gas"     , "⛽",
"gear"    , "⚙",
"geek"    , "🤓",
"gem"     , "💎",
"gene"    , "🧬",
"genie"   , "🧞",
"ghost"   , "👻",
"gift"    , "🧧",
"ginger"  , "🦰",
"girl"    , "👧",
"glass"   , "🥛",
"globe"   , "🌍",
"glove"   , "🥎",
"gloves"  , "🧤",
"glow"    , "🌟",
"goal"    , "🥍",
"goat"    , "🐐",
"goblin"  , "👺",
"gold"    , "🥇",
"golf"    , "🏌",
"good"    , "🦸",
"goofy"   , "🤪",
"grain"   , "🌾",
"grape"   , "🍇",
"grapes"  , "🍇",
"graph"   , "💹",
"gray"    , "🦳",
"green"   , "💚",
"grin"    , "😀",
"groom"   , "🤵",
"growth"  , "💹",
"guard"   , "💂",
"guitar"  , "🎸",
"gun"     , "🔫",
"gyro"    , "🥙",
"hair"    , "🦳",
"halo"    , "😇",
"hammer"  , "🔨",
"hand"    , "🙅",
"happy"   , "🙋",
"hashi"   , "🥢",
"hat"     , "🥳",
"head"    , "🗣",
"hear"    , "🙉",
"heart"   , "❤",
"heel"    , "👠",
"helmet"  , "⛑",
"help"    , "💁",
"herb"    , "🌿",
"hero"    , "🦸",
"hijab"   , "🧕",
"hike"    , "🚶",
"hiking"  , "🥾",
"hippo"   , "🦛",
"hit"     , "🎯",
"hocho"   , "🔪",
"hockey"  , "🏑",
"hold"    , "👫",
"hole"    , "🕳",
"home"    , "🏠",
"honey"   , "🍯",
"hoop"    , "🏀",
"hooray"  , "🙌",
"horn"    , "🥳",
"horns"   , "😈",
"horse"   , "🏇",
"hot"     , "🥵",
"hotdog"  , "🌭",
"hotel"   , "🛌",
"house"   , "🏚",
"houses"  , "🏘",
"hug"     , "🤗",
"hump"    , "🐪",
"hurt"    , "🤕",
"hushed"  , "😯",
"i"       , "ℹ",
"ice"     , "🍦",
"id"      , "🆔",
"idea"    , "💡",
"ill"     , "🤒",
"imp"     , "👿",
"inbox"   , "📥",
"index"   , "👈",
"injury"  , "🤕",
"ink"     , "🔏",
"input"   , "🔠",
"insect"  , "🦟",
"inside"  , "💠",
"ironic"  , "😼",
"islam"   , "🕌",
"island"  , "🏝",
"jack"    , "🎃",
"jacket"  , "🧥",
"jeans"   , "👖",
"jewel"   , "💎",
"jiaozi"  , "🥟",
"jigsaw"  , "🧩",
"jockey"  , "🏇",
"joey"    , "🦘",
"joke"    , "😜",
"joker"   , "🃏",
"joy"     , "😂",
"judge"   , "👩‍⚖",
"judo"    , "🥋",
"jug"     , "🏺",
"juggle"  , "🤹",
"juice"   , "🥤",
"jump"    , "🦘",
"kaaba"   , "🕋",
"kale"    , "🥬",
"karate"  , "🥋",
"kebab"   , "🥙",
"key"     , "🔐",
"kick"    , "🦵",
"kimono"  , "👘",
"king"    , "👑",
"kiss"    , "😘",
"kiwi"    , "🥝",
"knife"   , "🍽",
"knit"    , "🧶",
"knobs"   , "🎛",
"koala"   , "🐨",
"lab"     , "🧪",
"label"   , "🏷",
"lamp"    , "🛋",
"large"   , "🤪",
"lather"  , "🧼",
"latin"   , "🔠",
"laugh"   , "😂",
"leaf"    , "🌿",
"ledger"  , "📒",
"left"    , "◀",
"leg"     , "🦵",
"lemon"   , "🍋",
"letter"  , "💌",
"level"   , "🎚",
"lie"     , "🤥",
"life"    , "🧬",
"lifter"  , "🏋",
"light"   , "🚨",
"limb"    , "🦵",
"link"    , "🖇",
"lion"    , "🦁",
"lips"    , "👄",
"liquor"  , "🥃",
"litter"  , "🚮",
"lizard"  , "🦎",
"llama"   , "🦙",
"loaf"    , "🍞",
"lock"    , "🔓",
"locked"  , "🔒",
"locker"  , "🛅",
"loop"    , "➰",
"lorry"   , "🚛",
"lotion"  , "🧴",
"loud"    , "🔊",
"love"    , "😍",
"low"     , "🔅",
"luck"    , "🤞",
"m"       , "Ⓜ",
"mad"     , "😡",
"mage"    , "🧙",
"magnet"  , "🧲",
"mail"    , "💌",
"maize"   , "🌽",
"makeup"  , "💄",
"male"    , "🐏",
"man"     , "🦸‍♂",
"mango"   , "🥭",
"map"     , "🗺",
"maple"   , "🍁",
"mark"    , "❣",
"marker"  , "📑",
"mask"    , "😷",
"math"    , "➕",
"maze"    , "🌽",
"meat"    , "🍖",
"medal"   , "🎖",
"medium"  , "🔉",
"melon"   , "🍈",
"memo"    , "📝",
"men"     , "👯‍♂",
"mercy"   , "🥺",
"merman"  , "🧜",
"metro"   , "🚇",
"mic"     , "🎙",
"milk"    , "🍼",
"mining"  , "⛏",
"minus"   , "➖",
"moai"    , "🗿",
"mobile"  , "📱",
"mode"    , "📳",
"molusc"  , "🦑",
"money"   , "🧧",
"monkey"  , "🙈",
"moon"    , "🌑",
"mortar"  , "🧱",
"mosque"  , "🕌",
"mother"  , "🤶",
"motor"   , "🛵",
"mouse"   , "🐭",
"mouth"   , "😃",
"movie"   , "🎥",
"moyai"   , "🗿",
"mug"     , "🍺",
"munch"   , "😱",
"muscle"  , "💪",
"museum"  , "🖼",
"music"   , "🎼",
"mute"    , "🔇",
"nail"    , "💅",
"name"    , "📛",
"nazar"   , "🧿",
"neck"    , "🧣",
"needle"  , "🧵",
"nerd"    , "🤓",
"net"     , "🥅",
"new"     , "🆕",
"news"    , "📰",
"ng"      , "🆖",
"nib"     , "✒",
"night"   , "🌃",
"nine"    , "🕘",
"no"      , "⛔",
"noodle"  , "🍜",
"north"   , "⬆",
"nose"    , "👃",
"not"     , "⛔",
"note"    , "🎵",
"notes"   , "🎶",
"nurse"   , "👨‍⚕",
"nut"     , "🥜",
"o"       , "⭕",
"ocean"   , "🌊",
"oden"    , "🍢",
"off"     , "📴",
"ogre"    , "👹",
"oh"      , "🙀",
"oil"     , "🛢",
"old"     , "🦳",
"om"      , "🕉",
"on"      , "🔛",
"once"    , "🔂",
"one"     , "🕐",
"open"    , "😃",
"orange"  , "🧡",
"outbox"  , "📤",
"owl"     , "🦉",
"ox"      , "🐂",
"pad"     , "🗒",
"paddle"  , "🏓",
"paella"  , "🥘",
"page"    , "📃",
"pager"   , "📟",
"palm"    , "🤦",
"pan"     , "🍳",
"panda"   , "🐼",
"pants"   , "👖",
"paper"   , "📜",
"parcel"  , "📦",
"park"    , "🏞",
"parlor"  , "💇",
"parrot"  , "🦜",
"part"    , "〽",
"party"   , "🥳",
"pasta"   , "🍝",
"pastry"  , "🍥",
"patrol"  , "🚓",
"pause"   , "⏯",
"paw"     , "🐾",
"pc"      , "💻",
"peace"   , "🕊",
"peach"   , "🍑",
"peahen"  , "🦚",
"peanut"  , "🥜",
"pear"    , "🍐",
"pen"     , "✒",
"pencil"  , "✏",
"pepper"  , "🌶",
"person"  , "🧑",
"pester"  , "🦡",
"pet"     , "🐶",
"phone"   , "🤳",
"piano"   , "🎹",
"pick"    , "⛏",
"pickle"  , "🥒",
"picnic"  , "🧺",
"pie"     , "🥧",
"piece"   , "🧩",
"pig"     , "🐷",
"pill"    , "💊",
"pilot"   , "👨‍✈",
"pin"     , "📌",
"pine"    , "🎍",
"pirate"  , "🦜",
"pistol"  , "🔫",
"pizza"   , "🍕",
"plane"   , "👨‍✈",
"plant"   , "🏵",
"plate"   , "🍽",
"play"    , "▶",
"please"  , "🙏",
"plug"    , "🔌",
"plus"    , "➕",
"plush"   , "🧸",
"point"   , "👈",
"pole"    , "💈",
"police"  , "👮",
"polish"  , "💅",
"polo"    , "🤽",
"poo"     , "💩",
"poodle"  , "🐩",
"poop"    , "💩",
"popper"  , "🎉",
"porous"  , "🧽",
"post"    , "🏣",
"postal"  , "📯",
"pot"     , "🍲",
"potato"  , "🥔",
"pouch"   , "👝",
"pound"   , "💷",
"prawn"   , "🍤",
"pray"    , "🙏",
"prayer"  , "🤲",
"pretty"  , "🦋",
"prince"  , "🤴",
"print"   , "👣",
"prize"   , "🏆",
"proof"   , "🧾",
"proud"   , "🦚",
"puck"    , "🏒",
"pulse"   , "💗",
"pump"    , "⛽",
"punch"   , "✊",
"purple"  , "💜",
"purse"   , "👛",
"puzzle"  , "🧩",
"queen"   , "👑",
"quench"  , "🧯",
"quiet"   , "😶",
"rabbit"  , "🐰",
"racing"  , "🏃‍♂",
"radio"   , "📻",
"rage"    , "😡",
"rain"    , "⛈",
"raised"  , "🙋",
"ram"     , "🐏",
"ramen"   , "🍜",
"rat"     , "🐀",
"rays"    , "☀",
"record"  , "⏺",
"red"     , "😡",
"reload"  , "🔃",
"repeat"  , "🔁",
"resort"  , "⛵",
"rewind"  , "⏪",
"ribbon"  , "💝",
"rice"    , "🌾",
"right"   , "▶",
"ring"    , "💍",
"road"    , "🛣",
"robot"   , "🤖",
"rock"    , "👨‍🎤",
"rocket"  , "👨‍🚀",
"rolled"  , "🗞",
"roller"  , "🎢",
"rose"    , "🌹",
"rugby"   , "🏉",
"ruler"   , "📏",
"rushed"  , "😰",
"sad"     , "😢",
"sake"    , "🍶",
"salad"   , "🥗",
"salon"   , "💆",
"salt"    , "🧂",
"sand"    , "⌛",
"sandal"  , "👡",
"santa"   , "🎅",
"sash"    , "🎽",
"sassy"   , "💁",
"sauna"   , "🧖",
"sax"     , "🎷",
"scale"   , "⚖",
"scales"  , "👨‍⚖",
"scared"  , "😨",
"scarf"   , "🧣",
"school"  , "🎒",
"score"   , "🎼",
"scream"  , "😱",
"scroll"  , "📜",
"sea"     , "⛵",
"search"  , "🔍",
"seat"    , "💺",
"second"  , "🥈",
"secure"  , "🔐",
"see"     , "🙈",
"selfie"  , "🤳",
"semi"    , "🚛",
"sent"    , "📤",
"set"     , "📐",
"seven"   , "🕖",
"sewing"  , "🧵",
"shake"   , "🤝",
"shaker"  , "🧂",
"shark"   , "🦈",
"shaved"  , "🍧",
"shaven"  , "🦲",
"sheep"   , "🐏",
"shell"   , "🐚",
"shield"  , "🛡",
"shinto"  , "⛩",
"ship"    , "⚓",
"shirt"   , "👕",
"shoe"    , "👞",
"shot"    , "🥃",
"shower"  , "🚿",
"shrimp"  , "🦐",
"shrine"  , "⛩",
"shrug"   , "🤷",
"shush"   , "🤫",
"sick"    , "😷",
"sign"    , "🛑",
"signal"  , "🚥",
"silent"  , "😶",
"silver"  , "🥈",
"singer"  , "👨‍🎤",
"six"     , "🕕",
"skate"   , "⛸",
"skewer"  , "🍢",
"ski"     , "⛷",
"skier"   , "⛷",
"skill"   , "🤹",
"skis"    , "🎿",
"skull"   , "💀",
"sled"    , "🛷",
"sledge"  , "🛷",
"sleep"   , "😪",
"sleigh"  , "🛷",
"sleuth"  , "🕵",
"slice"   , "🍕",
"slider"  , "🎚",
"slot"    , "🎰",
"sly"     , "🦝",
"small"   , "🤪",
"smile"   , "😁",
"smirk"   , "😏",
"snail"   , "🐌",
"snake"   , "🐍",
"sneeze"  , "🤧",
"snow"    , "⛷",
"soap"    , "🧼",
"sob"     , "😭",
"soccer"  , "⚽",
"socks"   , "🧦",
"soda"    , "🥤",
"soft"    , "🍦",
"soon"    , "🔜",
"sorry"   , "🙇",
"sos"     , "🆘",
"south"   , "⬇",
"sow"     , "🐖",
"space"   , "🌌",
"speak"   , "🙊",
"speech"  , "💬",
"speed"   , "🚄",
"spider"  , "🕷",
"spiny"   , "🦔",
"spiral"  , "🐚",
"spock"   , "🖖",
"sponge"  , "🧽",
"spool"   , "🧵",
"spoon"   , "🥄",
"spots"   , "🦒",
"spy"     , "🕵",
"square"  , "⏹",
"squid"   , "🦑",
"staff"   , "⚕",
"star"    , "🤩",
"statue"  , "🗽",
"steak"   , "🥩",
"steam"   , "🚂",
"stew"    , "🍲",
"stick"   , "🥍",
"stomp"   , "🦶",
"stop"    , "🚏",
"store"   , "🏪",
"string"  , "🧵",
"stripe"  , "🦓",
"studio"  , "🎙",
"stuffy"  , "🧐",
"subway"  , "🚇",
"suit"    , "🕴",
"sun"     , "😎",
"sunny"   , "☀",
"sunset"  , "🌆",
"sushi"   , "🍣",
"swan"    , "🦢",
"sweat"   , "😅",
"sweet"   , "🧁",
"swim"    , "🏊",
"swirl"   , "🍥",
"sword"   , "🤺",
"swords"  , "⚔",
"tabs"    , "📑",
"taco"    , "🌮",
"tada"    , "🎉",
"talk"    , "🦜",
"tao"     , "☯",
"taoist"  , "☯",
"tape"    , "📼",
"target"  , "🎯",
"taste"   , "😝",
"taxi"    , "🚕",
"tea"     , "☕",
"teacup"  , "🍵",
"tear"    , "😂",
"teller"  , "🏧",
"temple"  , "🕍",
"ten"     , "🕙",
"tennis"  , "🎾",
"tent"    , "⛺",
"thanks"  , "🙏",
"third"   , "🥉",
"thirty"  , "🕧",
"thread"  , "🧵",
"three"   , "🕒",
"thumb"   , "👍",
"tichel"  , "🧕",
"ticket"  , "🎟",
"tie"     , "👔",
"tiger"   , "🐯",
"timer"   , "⌛",
"tipsy"   , "🥴",
"tired"   , "😫",
"tm"      , "™",
"toilet"  , "🚽",
"tomato"  , "🍅",
"tongue"  , "😛",
"tool"    , "🧰",
"tooth"   , "🦷",
"top"     , "🎩",
"tophat"  , "🎩",
"torch"   , "🔦",
"tower"   , "🗼",
"toy"     , "🧸",
"train"   , "🚂",
"tram"    , "🚃",
"travel"  , "🧳",
"tray"    , "📤",
"tree"    , "🌲",
"trend"   , "📈",
"trophy"  , "🏆",
"truck"   , "🚒",
"tshirt"  , "👕",
"tulip"   , "🌷",
"turban"  , "👳",
"turkey"  , "🦃",
"turtle"  , "🐢",
"tuxedo"  , "🤵",
"tv"      , "📺",
"twelve"  , "🕛",
"twins"   , "👬",
"two"     , "🕑",
"ufo"     , "👽",
"undead"  , "🧛",
"unlock"  , "🔓",
"up"      , "☝",
"upward"  , "📈",
"urn"     , "⚱",
"v"       , "✌",
"veil"    , "👰",
"versus"  , "🆚",
"vhs"     , "📼",
"vice"    , "🗜",
"video"   , "📻",
"violin"  , "🎻",
"virus"   , "🦟",
"vomit"   , "🤢",
"vs"      , "🆚",
"vulcan"  , "🖖",
"walk"    , "🚶",
"wall"    , "🧱",
"waning"  , "🌖",
"watch"   , "⌚",
"water"   , "🤽",
"wave"    , "👋",
"waving"  , "👋",
"wavy"    , "〰",
"waxing"  , "🌒",
"wc"      , "🚹",
"weapon"  , "🔪",
"weary"   , "😩",
"web"     , "🕸",
"weight"  , "🏋",
"west"    , "⬅",
"whale"   , "🐳",
"wheel"   , "🎡",
"whew"    , "😥",
"whisky"  , "🥃",
"white"   , "🦳",
"whoops"  , "🤭",
"wicked"  , "🖤",
"wilted"  , "🥀",
"wind"    , "🍃",
"wine"    , "🍷",
"wings"   , "💸",
"wink"    , "😉",
"wise"    , "🦉",
"witch"   , "🧹",
"wizard"  , "🧙",
"wolf"    , "🐺",
"woman"   , "🦸‍♀",
"women"   , "👯‍♀",
"won"     , "😤",
"wool"    , "🦙",
"worker"  , "👨‍🏭",
"world"   , "🌍",
"wrap"    , "🌯",
"wrench"  , "🛠",
"write"   , "✍",
"wry"     , "😼",
"x"       , "✖",
"yacht"   , "⛵",
"yang"    , "☯",
"yarn"    , "🧶",
"yellow"  , "💛",
"yen"     , "💴",
"yin"     , "☯",
"yoga"    , "🧘",
"young"   , "👶",
"yum"     , "😋",
"zap"     , "⚡",
"zebra"   , "🦓",
"zipper"  , "🤐",
"zodiac"  , "👧",
"zombie"  , "🧟",
"zzz"     , "😴"
};

const EmojiItem chinese_emoji_table[] = {
"一"       , "🕐",
"一次"      , "🔂",
"一点"      , "🕐",
"七"       , "🕖",
"七点"      , "🕖",
"万岁"      , "🙌",
"三"       , "🕒",
"三十"      , "🕧",
"三点"      , "🕒",
"上"       , "☝",
"上升"      , "💹",
"上锁"      , "🔒",
"下"       , "👇",
"下跌"      , "📉",
"不"       , "🙈",
"不久"      , "🔜",
"不准"      , "⛔",
"不可"      , "⛔",
"世界"      , "🌍",
"业务"      , "👨‍💼",
"东"       , "➡",
"东京"      , "🗼",
"东北"      , "↗",
"东南"      , "↘",
"丝带"      , "🎗",
"两点"      , "🕑",
"个人"      , "💻",
"中心"      , "🎯",
"中性"      , "🧒",
"中指"      , "🖕",
"中等"      , "🔉",
"串"       , "🍡",
"串烧"      , "🍢",
"丸子"      , "🍡",
"举手"      , "🙋",
"举起"      , "🤚",
"举重"      , "🏋",
"乐谱"      , "🎼",
"乒乓"      , "🏓",
"乘"       , "✖",
"乘客"      , "🛳",
"乘法"      , "✖",
"九"       , "🕘",
"九点"      , "🕘",
"乞嚏"      , "🤧",
"书"       , "📔",
"书包"      , "🎒",
"书签"      , "📑",
"乳房"      , "🤱",
"二"       , "🕑",
"亏"       , "🌖",
"云"       , "☁",
"五"       , "🕔",
"五点"      , "🕔",
"亚洲"      , "🌏",
"亡灵"      , "🧛",
"交叉"      , "🤞",
"交通"      , "🚥",
"亮度"      , "🔅",
"人鱼"      , "🧜",
"仓鼠"      , "🐹",
"仙子"      , "🧚",
"仪器"      , "🎷",
"仪式"      , "🎑",
"企鹅"      , "🐧",
"传真"      , "📠",
"伤心"      , "😢",
"低"       , "🔅",
"体操"      , "🤸",
"佛教"      , "☸",
"佛法"      , "☸",
"侦探"      , "🕵",
"便当"      , "🍱",
"便条"      , "📝",
"信"       , "💌",
"信号"      , "🚥",
"信封"      , "✉",
"信用"      , "💳",
"信箱"      , "📫",
"修甲"      , "💅",
"停"       , "🚏",
"停止"      , "🛑",
"健康"      , "🤧",
"傍晚"      , "🌆",
"傻笑"      , "😏",
"光"       , "🕯",
"光亮"      , "☀",
"光学"      , "💽",
"光环"      , "😇",
"光碟"      , "💽",
"免费"      , "🈚",
"兑换"      , "💱",
"兔"       , "🐰",
"兔耳"      , "👯",
"兔脸"      , "🐰",
"入场"      , "🎟",
"八"       , "🕗",
"八点"      , "🕗",
"公"       , "🐏",
"公主"      , "👸",
"公园"      , "🏞",
"公牛"      , "🐂",
"公羊"      , "🐏",
"公路"      , "🛣",
"公鸡"      , "🐓",
"六"       , "🕕",
"六点"      , "🕕",
"关闭"      , "📫",
"兴奋"      , "💖",
"内"       , "💠",
"冇位"      , "🈵",
"写字"      , "✍",
"军事"      , "🎖",
"农夫"      , "👨‍🌾",
"冥想"      , "🧘",
"冬甩"      , "🍩",
"冰"       , "🍦",
"冰冷"      , "😓",
"冰球"      , "🏒",
"冲凉"      , "🛀",
"冻"       , "😅",
"凉鞋"      , "👡",
"凋谢"      , "🥀",
"减"       , "➖",
"几何"      , "▪",
"出发"      , "🛫",
"击中"      , "🎯",
"刀"       , "🍽",
"分数"      , "💯",
"分类"      , "🗂",
"分量"      , "🥃",
"划艇"      , "🚣",
"刨"       , "🍧",
"刨冰"      , "🍧",
"到达"      , "🛬",
"制服"      , "🥋",
"券"       , "🎟",
"刺"       , "🦔",
"刺猬"      , "🦔",
"剑"       , "🤺",
"剑击"      , "🤺",
"剔号"      , "✅",
"剧场"      , "🎭",
"剪"       , "✂",
"剪影"      , "🗣",
"割"       , "🈹",
"加"       , "➕",
"包头"      , "🧕",
"包装"      , "🎁",
"包裹"      , "📦",
"匆忙"      , "😰",
"匕首"      , "🗡",
"化妆"      , "💄",
"化学"      , "⚗",
"北"       , "⬆",
"匙羮"      , "🥄",
"医生"      , "😷",
"医药"      , "💉",
"医院"      , "🏥",
"十"       , "🕙",
"十一"      , "🕦",
"十二"      , "🕛",
"十点"      , "🕙",
"半"       , "🚛",
"单车"      , "🚴",
"单轨"      , "🚝",
"南"       , "⬇",
"南瓜"      , "🎃",
"卡"       , "💳",
"卡片"      , "🗂",
"卡车"      , "🚒",
"卫星"      , "🛰",
"印"       , "👣",
"危险"      , "⚡",
"卷"       , "📃",
"卷曲"      , "➰",
"卷起"      , "🗞",
"卷页"      , "📃",
"卷饼"      , "🌯",
"压"       , "🗜",
"厌倦"      , "🙀",
"厕所"      , "🚽",
"原子"      , "⚛",
"厨师"      , "👨‍🍳",
"叉"       , "🍽",
"双"       , "⏸",
"双子"      , "♊",
"双眼"      , "👀",
"双重"      , "⏩",
"反手"      , "👈",
"发光"      , "🌟",
"发出"      , "📩",
"发疯"      , "😡",
"发癫"      , "😠",
"发誓"      , "🤬",
"发送"      , "📩",
"取消"      , "✖",
"受伤"      , "🤕",
"口罩"      , "😷",
"口震"      , "😱",
"古典"      , "🏛",
"可"       , "🉑",
"台风"      , "🌀",
"叶"       , "🌿",
"号角"      , "📯",
"合"       , "🈴",
"合埋"      , "😚",
"合手"      , "🙏",
"合格"      , "🈴",
"吊钟"      , "🔔",
"同情"      , "😮",
"同意"      , "🤝",
"名牌"      , "📛",
"向上"      , "💹",
"向下"      , "⬇",
"向右"      , "🤜",
"向左"      , "🤛",
"吓亲"      , "😲",
"吓惊"      , "😯",
"听"       , "🙉",
"吸烟"      , "🚬",
"吹"       , "🍃",
"吻"       , "😘",
"呕吐"      , "🤢",
"呕心"      , "🤢",
"员工"      , "⚕",
"呜咽"      , "😭",
"呢度"      , "🈁",
"呼"       , "😥",
"呼叫"      , "🤭",
"咀唇"      , "👄",
"和平"      , "🕊",
"和服"      , "👘",
"咖哩"      , "🍛",
"咖啡"      , "☕",
"咪"       , "🎙",
"哺乳"      , "🤱",
"唇印"      , "💋",
"唇膏"      , "💄",
"唔准"      , "🙈",
"唔好"      , "🙈",
"唵"       , "🕉",
"商业"      , "🕴",
"商人"      , "👨‍🔧",
"商店"      , "🏪",
"商标"      , "™",
"啤酒"      , "🍺",
"啧水"      , "🐳",
"喇叭"      , "🔇",
"喊"       , "😢",
"嗯"       , "😋",
"嘘"       , "🤫",
"嘭嘭"      , "‼",
"嘴"       , "😃",
"噢"       , "🙀",
"四"       , "🍀",
"四点"      , "🕓",
"回带"      , "◀",
"团"       , "🍙",
"园丁"      , "👨‍🌾",
"困惑"      , "😖",
"国王"      , "👑",
"图"       , "💹",
"图片"      , "🖼",
"图表"      , "💹",
"圆形"      , "⏺",
"圈"       , "➰",
"在"       , "🔛",
"地下"      , "🤣",
"地图"      , "🗺",
"地球"      , "🌍",
"地铁"      , "🚇",
"场所"      , "🛐",
"坠落"      , "🌠",
"垂直"      , "⏸",
"垃圾"      , "🚮",
"垫"       , "🗒",
"城堡"      , "🏯",
"城市"      , "🏙",
"基点"      , "⬆",
"塔"       , "🗼",
"增长"      , "💹",
"墨水"      , "🔏",
"壳"       , "🐚",
"处女"      , "👧",
"夏日"      , "🍹",
"外套"      , "🧥",
"外星"      , "👽",
"外框"      , "❔",
"多谢"      , "🙏",
"夜晚"      , "🌃",
"大"       , "🤪",
"大卫"      , "✡",
"大厦"      , "🏢",
"大厨"      , "👨‍🍳",
"大声"      , "🔊",
"大桥"      , "🌉",
"大虾"      , "🍤",
"大象"      , "🐘",
"大阶"      , "🔠",
"大雾"      , "🌁",
"天使"      , "😇",
"天房"      , "🕋",
"天气"      , "🌡",
"天父"      , "🎅",
"天真"      , "😇",
"天秤"      , "⚖",
"天线"      , "📡",
"太空"      , "🌌",
"太阳"      , "😎",
"夫妇"      , "👫",
"失望"      , "😥",
"头"       , "🗣",
"头巾"      , "👳",
"头晕"      , "😵",
"头盔"      , "⛑",
"奇怪"      , "🤓",
"奖"       , "🏆",
"奖杯"      , "🏆",
"奖牌"      , "🎖",
"女"       , "👩‍⚕",
"女人"      , "👩",
"女仔"      , "👧",
"女厕"      , "🚺",
"女士"      , "👠",
"女巫"      , "🧙",
"女王"      , "👑",
"女装"      , "👚",
"奶"       , "🍼",
"好累"      , "😩",
"好食"      , "😋",
"妈妈"      , "🤶",
"妖"       , "👿",
"姓名"      , "📛",
"姿势"      , "🙇",
"娃娃"      , "🎎",
"娱乐"      , "🚙",
"婚礼"      , "👰",
"婴儿"      , "👶",
"嬲"       , "😡",
"子弹"      , "🚅",
"孕妇"      , "🤰",
"字母"      , "🔠",
"学校"      , "🎒",
"学生"      , "👨‍🎓",
"孵化"      , "🐣",
"安全"      , "🔐",
"安静"      , "🔇",
"完全"      , "😲",
"宗教"      , "📿",
"宝石"      , "💎",
"宠物"      , "🐶",
"客厅"      , "💇",
"客船"      , "🛳",
"害怕"      , "😨",
"家"       , "🏠",
"家庭"      , "👪",
"家禽"      , "🍗",
"寄信"      , "💌",
"寄存"      , "🛅",
"密码"      , "🔑",
"富士"      , "🗻",
"寒冷"      , "🌨",
"对"       , "🆚",
"对话"      , "💬",
"寺庙"      , "🕍",
"寿司"      , "🍣",
"封面"      , "📔",
"射击"      , "🌠",
"射手"      , "🏹",
"射箭"      , "🏹",
"射线"      , "☀",
"小"       , "🦐",
"小丑"      , "🤡",
"小巴"      , "🚐",
"小童"      , "🧒",
"小阶"      , "🔡",
"小鸡"      , "🐣",
"屋"       , "🏘",
"屎"       , "💩",
"山"       , "🏔",
"山地"      , "🚵",
"山羊"      , "🐐",
"岗位"      , "🚩",
"岛"       , "🏝",
"巡逻"      , "🚓",
"工业"      , "👨‍🏭",
"工人"      , "👨‍🏭",
"工具"      , "🔪",
"工厂"      , "👨‍🏭",
"巨灵"      , "🧞",
"巨蛇"      , "🐍",
"巫婆"      , "🧙",
"巫师"      , "🧙",
"巴士"      , "🚌",
"市场"      , "💹",
"布甸"      , "🍮",
"帆船"      , "⛵",
"帐单"      , "💴",
"帐篷"      , "⛺",
"帕克"      , "🧚",
"带"       , "📼",
"帮助"      , "💁",
"帽"       , "🤠",
"平行"      , "🤹",
"年青"      , "👶",
"幸运"      , "🤞",
"幻想"      , "😇",
"幼小"      , "🌱",
"幼苗"      , "🌱",
"庆祝"      , "🎅",
"床"       , "🛏",
"座位"      , "💺",
"座灯"      , "🛋",
"建筑"      , "👷",
"建造"      , "🏗",
"开"       , "🔓",
"开会"      , "🤝",
"开花"      , "🌸",
"弓"       , "🏹",
"弓箭"      , "🏹",
"张开"      , "🖐",
"弦月"      , "🌒",
"录制"      , "⏺",
"彗星"      , "☄",
"彩虹"      , "🌈",
"影片"      , "📻",
"得"       , "🉐",
"微笑"      , "😀",
"徽章"      , "🔱",
"心"       , "❤",
"心跳"      , "💓",
"忌廉"      , "🍦",
"忧心"      , "😔",
"快"       , "⏩",
"快乐"      , "😂",
"快到"      , "🚔",
"快艇"      , "🚤",
"快走"      , "💨",
"快进"      , "⏩",
"快速"      , "💨",
"念珠"      , "📿",
"怀孕"      , "🤰",
"怀疑"      , "🤨",
"怪物"      , "👹",
"恐布"      , "😝",
"恭喜"      , "㊗",
"恶魔"      , "👿",
"悬架"      , "🚟",
"情人"      , "💝",
"情信"      , "💌",
"惊叫"      , "😱",
"惊恐"      , "😨",
"惊慌"      , "😨",
"惊讶"      , "😯",
"惧怕"      , "😱",
"想法"      , "💡",
"感谢"      , "🙇‍♂",
"愤怒"      , "😡",
"戏"       , "🎞",
"戏院"      , "🎥",
"成人"      , "🧑",
"戒指"      , "💍",
"房屋"      , "🏚",
"手"       , "🙅",
"手势"      , "🙈",
"手套"      , "🧤",
"手指"      , "👈",
"手掌"      , "🤦",
"手机"      , "🤳",
"手枪"      , "🔫",
"手球"      , "🤾",
"手瓜"      , "💪",
"手表"      , "⌚",
"手袋"      , "👜",
"扒"       , "🥩",
"打"       , "✊",
"打开"      , "😃",
"打气"      , "📣",
"托盘"      , "📤",
"扭歪"      , "😼",
"扭纹"      , "🥨",
"扳手"      , "🛠",
"批"       , "🥧",
"技工"      , "👨‍🔧",
"技术"      , "🤹",
"投票"      , "🗳",
"折扣"      , "🈹",
"护士"      , "👨‍⚕",
"护照"      , "🛂",
"护理"      , "💅",
"报纸"      , "📰",
"抵达"      , "🛬",
"担心"      , "😟",
"拉丁"      , "🔠",
"拉链"      , "🤐",
"拉面"      , "🍜",
"拍手"      , "👏",
"拍板"      , "🎬",
"拖"       , "👫",
"招牌"      , "💈",
"拥抱"      , "🤗",
"拳击"      , "🥊",
"拳头"      , "✊",
"拳套"      , "🥊",
"指"       , "👈",
"指向"      , "👈",
"指甲"      , "💅",
"按摩"      , "💆",
"按钮"      , "🔼",
"挑"       , "⛏",
"挥手"      , "👋",
"损伤"      , "🤕",
"换片"      , "🚼",
"掌"       , "🐾",
"掌印"      , "🐾",
"排球"      , "🏐",
"接受"      , "🉑",
"接收"      , "📨",
"控制"      , "🎛",
"提子"      , "🍇",
"提示"      , "💁",
"插头"      , "🔌",
"握"       , "🤝",
"握手"      , "🤝",
"握紧"      , "✊",
"揽"       , "🤗",
"搜寻"      , "🔍",
"搞笑"      , "💤",
"摇滚"      , "👨‍🎤",
"摔交"      , "🤼",
"摧毁"      , "⚡",
"摩艾"      , "🗿",
"撅嘴"      , "😡",
"播放"      , "▶",
"收到"      , "📲",
"收费"      , "🈶",
"放低"      , "📪",
"放大"      , "🔍",
"放松"      , "☺",
"教堂"      , "⛪",
"教师"      , "👨‍🏫",
"教授"      , "👨‍🏫",
"散子"      , "👛",
"敬礼"      , "🖖",
"数字"      , "🔢",
"数学"      , "➕",
"文件"      , "📃",
"斑点"      , "🦒",
"斑马"      , "🦓",
"新娘"      , "👰",
"新月"      , "🌑",
"新郎"      , "🤵",
"新闻"      , "📰",
"方便"      , "🏪",
"方向"      , "⬆",
"旋转"      , "💞",
"旋风"      , "🌪",
"旗"       , "🎏",
"无"       , "🈚",
"无声"      , "😶",
"无知"      , "🤷",
"日元"      , "💹",
"日出"      , "🌄",
"日历"      , "📅",
"日圆"      , "💴",
"日式"      , "🏣",
"日期"      , "📅",
"日本"      , "🍙",
"日落"      , "🌆",
"旧"       , "🗝",
"早上"      , "🌄",
"早餐"      , "🥣",
"时钟"      , "⌚",
"时髦"      , "💁",
"昆虫"      , "🦋",
"明星"      , "🤩",
"星"       , "💫",
"星夜"      , "🌃",
"星座"      , "👧",
"星星"      , "🌃",
"晕"       , "😳",
"晚上"      , "🌉",
"景观"      , "🌆",
"晴朗"      , "☀",
"智力"      , "🧠",
"智慧"      , "🦉",
"暂停"      , "⏯",
"暗"       , "🔅",
"暴龙"      , "🦖",
"曲奇"      , "🍪",
"月"       , "🌒",
"月亮"      , "🌑",
"月费"      , "🈷",
"有"       , "🈶",
"有雾"      , "🌁",
"服装"      , "👣",
"杂耍"      , "🤹",
"条"       , "🍫",
"条纹"      , "🦓",
"来"       , "📨",
"杯"       , "🥛",
"松树"      , "🎍",
"板手"      , "🔧",
"板球"      , "🏏",
"果仁"      , "🥜",
"果汁"      , "🥤",
"枪"       , "🎉",
"枫叶"      , "🍁",
"枫树"      , "🍁",
"柑桔"      , "🍊",
"柑橘"      , "🍋",
"柔软"      , "🔈",
"柔道"      , "🥋",
"柜"       , "🗄",
"柠檬"      , "🍋",
"标志"      , "🛑",
"标签"      , "📑",
"标记"      , "📑",
"树"       , "🌲",
"树熊"      , "🐨",
"栗子"      , "🌰",
"格子"      , "🏁",
"桃"       , "🍑",
"框架"      , "🖼",
"框画"      , "🖼",
"桌球"      , "🎱",
"桌面"      , "🖥",
"桑拿"      , "🧖",
"档案"      , "📁",
"桶"       , "🛢",
"梅花"      , "♣",
"梨"       , "🍐",
"梳打"      , "🥤",
"检查"      , "🛂",
"棒"       , "🍢",
"棒球"      , "⚾",
"棕榈"      , "🌴",
"棺材"      , "⚰",
"植物"      , "🏵",
"椰子"      , "🥥",
"榄球"      , "🏉",
"槿"       , "🌺",
"模式"      , "📳",
"横额"      , "🎋",
"樱花"      , "🌸",
"樽"       , "🍼",
"橙"       , "🍊",
"橙色"      , "🧡",
"櫈"       , "💺",
"欧元"      , "💶",
"欧洲"      , "🌍",
"歌手"      , "👨‍🎤",
"正义"      , "👨‍⚖",
"武器"      , "🔪",
"武术"      , "🥋",
"死"       , "💀",
"死亡"      , "☠",
"残月"      , "🌘",
"殭尸"      , "🧟",
"毒菌"      , "🍄",
"比赛"      , "🏐",
"毕业"      , "👨‍🎓",
"气体"      , "⛽",
"气球"      , "💬",
"水"       , "🤽",
"水晶"      , "🔮",
"水点"      , "☔",
"水牛"      , "🐃",
"水球"      , "🤽",
"水龟"      , "🐢",
"求助"      , "🆘",
"汗"       , "😅",
"汽球"      , "🎈",
"汽车"      , "🚞",
"沉默"      , "😯",
"沙"       , "⌛",
"沙发"      , "🛋",
"沙律"      , "🥗",
"沙漏"      , "⏳",
"沙漠"      , "🏜",
"沮丧"      , "😔",
"油"       , "🛢",
"油桶"      , "🛢",
"泉"       , "♨",
"泊车"      , "🅿",
"法国"      , "🥐",
"法式"      , "🥖",
"泡泡"      , "💬",
"泡菜"      , "🥒",
"波"       , "🏌",
"波浪"      , "🌊",
"注册"      , "®",
"注射"      , "💉",
"注释"      , "🗒",
"泵"       , "⛽",
"洞"       , "⛳",
"派对"      , "👯",
"流动"      , "📱",
"流星"      , "🌠",
"浅"       , "🥘",
"浪漫"      , "💒",
"浴缸"      , "🛀",
"海"       , "⛵",
"海关"      , "🛃",
"海洋"      , "🌊",
"海浪"      , "🌊",
"海滩"      , "🏖",
"海豚"      , "🐬",
"海鲜"      , "🍢",
"海龟"      , "🐢",
"清酒"      , "🍶",
"渡船"      , "⛴",
"温泉"      , "♨",
"游戏"      , "🥌",
"游水"      , "🏊",
"游艇"      , "⛵",
"溅"       , "💦",
"溜冰"      , "⛸",
"滑块"      , "🎚",
"滑浪"      , "🏄",
"滑雪"      , "⛷",
"滚动"      , "📜",
"滚筒"      , "🎢",
"满"       , "🌕",
"满分"      , "💯",
"满意"      , "😆",
"满月"      , "🌕",
"滴汗"      , "💦",
"演员"      , "👨‍🎤",
"漩涡"      , "🍥",
"漫画"      , "💩",
"澳洲"      , "🌏",
"火"       , "🚒",
"火山"      , "🌋",
"火焰"      , "🔥",
"火箭"      , "👨‍🚀",
"火花"      , "🎇",
"火车"      , "🚂",
"火鸡"      , "🦃",
"灯"       , "🚨",
"灯泡"      , "💡",
"灯笼"      , "🎃",
"灯胆"      , "💡",
"灰烬"      , "⚱",
"炖"       , "🍲",
"炸"       , "🍤",
"炸弹"      , "💣",
"炸虾"      , "🍤",
"点"       , "🕛",
"烈酒"      , "🥃",
"烛台"      , "🕎",
"烟肉"      , "🥓",
"烟花"      , "🎆",
"烩"       , "🍠",
"热"       , "☕",
"热带"      , "🐠",
"热狗"      , "🌭",
"热饮"      , "☕",
"煎"       , "🍳",
"煮熟"      , "🍚",
"煮食"      , "🍳",
"熊"       , "🐻",
"熊猫"      , "🐼",
"熊脸"      , "🐻",
"燃油"      , "⛽",
"燕麦"      , "🥣",
"爆发"      , "🌋",
"爆谷"      , "🍿",
"爱"       , "😍",
"爱情"      , "💌",
"片"       , "🍕",
"片装"      , "🍰",
"版权"      , "©",
"牌"       , "📛",
"牛"       , "🐮",
"牛仔"      , "🤠",
"牛女"      , "🤠",
"牛扒"      , "🥩",
"牛脸"      , "🐮",
"牛角"      , "😈",
"牧人"      , "👨‍🌾",
"犀牛"      , "🦏",
"狐狸"      , "🦊",
"狗"       , "🐶",
"狗脸"      , "🐶",
"狮子"      , "🦁",
"狼"       , "🐺",
"狼脸"      , "🐺",
"猪"       , "🐷",
"猪公"      , "🐗",
"猪扒"      , "🥩",
"猪脸"      , "🐷",
"猪鼻"      , "🐽",
"猫"       , "😺",
"猫脸"      , "🐱",
"玉米"      , "🌽",
"王子"      , "🤴",
"玩"       , "🎴",
"玫瑰"      , "🌹",
"玻璃"      , "🥃",
"珠"       , "📿",
"珠宝"      , "💎",
"班戟"      , "🥞",
"球"       , "🤾",
"球场"      , "🏑",
"球拍"      , "🏓",
"球棒"      , "🏏",
"理发"      , "💇",
"瑜伽"      , "🧘",
"瓮"       , "⚱",
"甜"       , "🍡",
"甜品"      , "🍡",
"生果"      , "🍇",
"生物"      , "👹",
"生病"      , "🤒",
"生肖"      , "⛎",
"甲虫"      , "🐞",
"申"       , "🈸",
"申请"      , "🈸",
"电"       , "🚃",
"电力"      , "⚡",
"电压"      , "⚡",
"电工"      , "👨‍🔧",
"电影"      , "🎥",
"电池"      , "🔋",
"电筒"      , "🔦",
"电脑"      , "💻",
"电话"      , "📱",
"电车"      , "🚃",
"电邮"      , "✉",
"男"       , "👨‍⚕",
"男人"      , "👨",
"男仔"      , "👦",
"男厕"      , "🚹",
"男士"      , "👞",
"男巫"      , "🧙",
"画画"      , "🖌",
"画笔"      , "🖌",
"画面"      , "🎞",
"番茄"      , "🍅",
"番薯"      , "🍠",
"病"       , "😷",
"痛苦"      , "😬",
"痢"       , "😛",
"白兔"      , "🐰",
"白花"      , "💮",
"白领"      , "👨‍💼",
"百"       , "💯",
"的士"      , "🚕",
"皇冠"      , "👑",
"皱眉"      , "☹",
"盈"       , "🌒",
"盒"       , "🍱",
"盒子"      , "📥",
"目标"      , "🥅",
"直尺"      , "📏",
"直边"      , "📏",
"相机"      , "🤳",
"盾"       , "🛡",
"眨眼"      , "😉",
"眼"       , "😁",
"眼泪"      , "😂",
"眼睛"      , "🤩",
"眼镜"      , "😎",
"睇"       , "🙈",
"石"       , "🥌",
"砂锅"      , "🥘",
"破碎"      , "💔",
"碌地"      , "🤣",
"碎"       , "💔",
"碗"       , "🍜",
"碟"       , "🍽",
"碰撞"      , "💥",
"磁碟"      , "💾",
"礼物"      , "🎁",
"祈祷"      , "🤲",
"祝"       , "㊗",
"神奇"      , "🧝",
"神教"      , "⛩",
"神社"      , "⛩",
"祷告"      , "📿",
"禁"       , "🈲",
"禁止"      , "🙈",
"禁钉"      , "📌",
"离境"      , "🛫",
"禾束"      , "🌾",
"科学"      , "🔬",
"秒表"      , "⏱",
"秘"       , "㊙",
"秘密"      , "㊙",
"秤"       , "👨‍⚖",
"穗"       , "🌾",
"空"       , "🈳",
"空中"      , "🚡",
"突起"      , "🌔",
"窿"       , "🕳",
"竖起"      , "👍",
"章鱼"      , "🐙",
"童话"      , "👼",
"竹"       , "🎍",
"竿"       , "🎣",
"笑"       , "😂",
"笑脸"      , "😀",
"笔"       , "✒",
"笔尖"      , "✒",
"符号"      , "❣",
"第一"      , "🥇",
"第三"      , "🥉",
"第二"      , "🥈",
"筷子"      , "🥢",
"箭"       , "💘",
"箭咀"      , "📲",
"箭头"      , "🏹",
"箭靶"      , "🎯",
"篮圈"      , "🏀",
"篮球"      , "🏀",
"米"       , "🌾",
"米饼"      , "🍘",
"粟米"      , "🌽",
"粥"       , "🥣",
"粪便"      , "💩",
"粱龙"      , "🦕",
"糕点"      , "🍥",
"糖果"      , "🍬",
"索引"      , "🗂",
"紧张"      , "💗",
"紫色"      , "💜",
"累"       , "😫",
"红"       , "😡",
"红心"      , "♥",
"红色"      , "🍎",
"级别"      , "🎚",
"纪念"      , "🎗",
"纸"       , "📜",
"纸屑"      , "🎊",
"纸币"      , "💴",
"纸牌"      , "♠",
"组合"      , "📐",
"细"       , "🤪",
"经理"      , "👨‍💼",
"结他"      , "🎸",
"结束"      , "🔚",
"绘画"      , "🖼",
"绵羊"      , "🐏",
"绷带"      , "🤕",
"绿色"      , "💚",
"缆"       , "🚠",
"缆车"      , "🚠",
"罐"       , "🍯",
"罐头"      , "🥫",
"网"       , "🕸",
"网球"      , "🎾",
"羊扒"      , "🥩",
"美元"      , "💵",
"美容"      , "💇",
"美式"      , "🏈",
"美洲"      , "🌎",
"翼"       , "💸",
"老人"      , "🧓",
"老年"      , "🧓",
"老虎"      , "🐯",
"老鼠"      , "🐭",
"耳仔"      , "👂",
"耳机"      , "🎧",
"耸肩"      , "🤷",
"肉"       , "🍖",
"肉块"      , "🥩",
"肌肉"      , "💪",
"肤色"      , "🏻",
"肩带"      , "🎽",
"胜利"      , "✌",
"胸像"      , "👤",
"脉动"      , "💓",
"脑"       , "🧠",
"脚"       , "🐾",
"脚印"      , "👣",
"脱落"      , "🌳",
"脸"       , "😀",
"脸红"      , "😳",
"腕龙"      , "🦕",
"腮红"      , "😊",
"自拍"      , "🤳",
"自然"      , "😐",
"自由"      , "🗽",
"臭"       , "💩",
"船"       , "⚓",
"艇"       , "🚣",
"艺人"      , "👨‍🎤",
"艺术"      , "🎭",
"节日"      , "🎎",
"芝士"      , "🧀",
"花"       , "💐",
"花园"      , "🏡",
"花束"      , "💐",
"花洒"      , "🚿",
"花环"      , "🏵",
"花生"      , "🥜",
"苦恼"      , "😧",
"英镑"      , "💷",
"苹果"      , "🍎",
"茄子"      , "🍆",
"茶"       , "☕",
"茶杯"      , "🍵",
"草"       , "🍀",
"草蜢"      , "🦗",
"荒岛"      , "🏝",
"荒废"      , "🏚",
"药"       , "😷",
"药丸"      , "💊",
"莓"       , "🍓",
"莫伊"      , "🗿",
"菠萝"      , "🍍",
"菱形"      , "🔶",
"营"       , "🈺",
"营业"      , "🈺",
"落叶"      , "🍁",
"落雨"      , "🌈",
"葬礼"      , "⚱",
"葵扇"      , "♠",
"蒸气"      , "🍜",
"蒸汽"      , "🚂",
"蓝光"      , "📀",
"蓝色"      , "😰",
"蔬菜"      , "🍅",
"薄饼"      , "🍕",
"薯仔"      , "🥔",
"薯条"      , "🍟",
"蘑菇"      , "🍄",
"虫"       , "🐛",
"虾"       , "🦐",
"蚂蚁"      , "🐜",
"蚊"       , "💰",
"蚝桶"      , "🥡",
"蛇"       , "🐍",
"蛋"       , "🥚",
"蛋糕"      , "🎂",
"蜗牛"      , "🐌",
"蜘蛛"      , "🕷",
"蜜瓜"      , "🍈",
"蜜糖"      , "🍯",
"蜜蜂"      , "🐝",
"蜡烛"      , "🕯",
"蜡笔"      , "🖍",
"蜥蜴"      , "🦎",
"蝎子"      , "🦂",
"蝙蝠"      , "🦇",
"蝴蝶"      , "🦋",
"螺"       , "🐚",
"螺旋"      , "🗒",
"螺栓"      , "🔩",
"螺母"      , "🔩",
"蟹"       , "🦀",
"血型"      , "🅰",
"行人"      , "🚸",
"行尸"      , "🧟",
"行李"      , "🛄",
"行路"      , "🚶",
"表情"      , "🙍",
"表演"      , "🎭",
"衫"       , "🎽",
"袋"       , "👝",
"袜"       , "🧦",
"装配"      , "👨‍🏭",
"装饰"      , "📔",
"裇衫"      , "👕",
"裙"       , "👗",
"裤"       , "👖",
"西"       , "⬅",
"西北"      , "↖",
"西南"      , "↙",
"西瓜"      , "🍉",
"西装"      , "🕴",
"见证"      , "👁‍🗨",
"解锁"      , "🔓",
"警告"      , "⚠",
"警员"      , "👮",
"警官"      , "👮",
"警察"      , "👮",
"警报"      , "⏰",
"警车"      , "🚓",
"训觉"      , "😪",
"讯号"      , "📶",
"讲"       , "🙊",
"讲价"      , "🉐",
"讲师"      , "👨‍🏫",
"讲野"      , "🗣",
"讽刺"      , "😼",
"试味"      , "😝",
"试食"      , "😋",
"请"       , "🙏",
"谂野"      , "🤔",
"谷物"      , "🌾",
"豹"       , "🐆",
"账簿"      , "📒",
"货币"      , "💴",
"货船"      , "🎢",
"购物"      , "🛍",
"资讯"      , "💁",
"赏月"      , "🎑",
"赛跑"      , "🏃‍♂",
"赛车"      , "🏎",
"赛马"      , "🏇",
"赢"       , "😤",
"赢咗"      , "😤",
"趋势"      , "💹",
"足球"      , "⚽",
"跑"       , "💨",
"跑步"      , "🏃",
"跑鞋"      , "👟",
"路"       , "🛣",
"跳动"      , "💓",
"跳舞"      , "💃",
"踢"       , "🛴",
"踫杯"      , "🍻",
"身份"      , "🆔",
"身体"      , "👂",
"车"       , "🏎",
"车站"      , "🚉",
"车辆"      , "🚝",
"轮"       , "🎡",
"轮廓"      , "☺",
"软"       , "🍦",
"软件"      , "👨‍💻",
"轰"       , "💥",
"轻铁"      , "🚈",
"较剪"      , "✂",
"辅助"      , "⛑",
"输入"      , "🔠",
"辣"       , "🌶",
"辣椒"      , "🌶",
"过路"      , "🚸",
"运动"      , "👟",
"返回"      , "🔙",
"进入"      , "⛔",
"远足"      , "🚶",
"连住"      , "🖇",
"连结"      , "🔗",
"迷茫"      , "😕",
"退出"      , "⏏",
"送礼"      , "🎁",
"送货"      , "🚚",
"选框"      , "☑",
"速度"      , "🚄",
"道"       , "☯",
"道教"      , "☯",
"道歉"      , "🙇",
"遮"       , "🏖",
"邋遢"      , "🧐",
"邪恶"      , "🙈",
"邮件"      , "📧",
"邮局"      , "🏤",
"邮政"      , "🏣",
"邮箱"      , "📫",
"部门"      , "🏬",
"酒"       , "🍷",
"酒吧"      , "🍶",
"酒塞"      , "🍾",
"酒店"      , "🛌",
"酷"       , "😎",
"醒"       , "😎",
"采矿"      , "⛏",
"重覆"      , "🔁",
"重量"      , "⚖",
"金"       , "🥇",
"金牌"      , "🥇",
"针"       , "💉",
"针筒"      , "💉",
"钟"       , "🛎",
"钢琴"      , "🎹",
"钢笔"      , "🖋",
"钮"       , "🎛",
"钱"       , "🤑",
"钱袋"      , "💰",
"钳"       , "🗜",
"钻石"      , "💍",
"铁路"      , "🚂",
"铃"       , "🎐",
"铅笔"      , "✏",
"铜"       , "🥉",
"铜牌"      , "🥉",
"银"       , "🥈",
"银河"      , "🌌",
"银牌"      , "🥈",
"银纸"      , "💴",
"银行"      , "🏦",
"链"       , "⛓",
"锁"       , "🔓",
"锁匙"      , "🔐",
"锅"       , "🍲",
"锚"       , "⚓",
"锤"       , "🔨",
"键盘"      , "🎹",
"镜片"      , "🔍",
"长大"      , "💗",
"长条"      , "🏮",
"长裤"      , "👖",
"门"       , "🚪",
"门券"      , "🎫",
"闩"       , "📴",
"闩埋"      , "📕",
"闪"       , "💖",
"闪光"      , "📸",
"闪电"      , "🌩",
"闪耀"      , "🌟",
"闪闪"      , "❇",
"问"       , "🙏",
"问号"      , "❓",
"问题"      , "⁉",
"间尺"      , "📏",
"间谍"      , "🕵",
"闹钟"      , "⏰",
"阳"       , "☯",
"阴"       , "☯",
"阴阳"      , "☯",
"阶砖"      , "♦",
"陆龟"      , "🐢",
"降落"      , "🛬",
"除"       , "➗",
"隐私"      , "🔏",
"雀"       , "🦃",
"雀仔"      , "🐦",
"雌性"      , "🐑",
"雕像"      , "🗽",
"雨"       , "⛈",
"雨云"      , "🌧",
"雪"       , "⛷",
"雪云"      , "🌨",
"雪人"      , "☃",
"雪山"      , "🏔",
"雪橇"      , "🛷",
"雪糕"      , "🍦",
"雪花"      , "❄",
"雷电"      , "⛈",
"雷龙"      , "🦕",
"雾"       , "🌫",
"震动"      , "📳",
"震惊"      , "🤯",
"露营"      , "🏕",
"青瓜"      , "🥒",
"青色"      , "🍏",
"青蛙"      , "🐸",
"靓"       , "🦋",
"静"       , "😶",
"静音"      , "🔇",
"非洲"      , "🌍",
"面"       , "🍜",
"面具"      , "🎭",
"面包"      , "🍞",
"面纱"      , "🧕",
"靴子"      , "👢",
"靶"       , "🎯",
"靶心"      , "🎯",
"鞋"       , "👞",
"鞠躬"      , "🙇",
"音乐"      , "🎼",
"音符"      , "🎵",
"页"       , "📃",
"顶帽"      , "🎩",
"顶部"      , "🔝",
"项链"      , "📿",
"须"       , "🧔",
"预言"      , "🥠",
"预订"      , "🈯",
"领取"      , "🛄",
"领呔"      , "👔",
"颈"       , "🧣",
"颈巾"      , "🧣",
"风"       , "🍃",
"风脸"      , "🌬",
"风铃"      , "🎐",
"飘动"      , "🍃",
"飞"       , "🕊",
"飞机"      , "👨‍✈",
"飞碟"      , "👽",
"飞镖"      , "🎯",
"食物"      , "🦐",
"餐具"      , "🥄",
"饭"       , "🍙",
"饭团"      , "🍙",
"饮"       , "☕",
"饮品"      , "🍼",
"饮水"      , "🚰",
"饮用"      , "🚰",
"饮酒"      , "🍶",
"饺子"      , "🥟",
"饼"       , "🍘",
"馅料"      , "🥧",
"馅饼"      , "🥙",
"香烟"      , "🚬",
"香肠"      , "🌭",
"香草"      , "🌿",
"香蕉"      , "🍌",
"马"       , "🏇",
"马脸"      , "🐴",
"马骝"      , "🙈",
"驼峰"      , "🐪",
"骆驼"      , "🐪",
"骑师"      , "🏇",
"骨"       , "🍖",
"骰子"      , "🎲",
"高压"      , "⚡",
"鬼"       , "👻",
"魔鬼"      , "👿",
"鱼"       , "🐟",
"鱿鱼"      , "🦑",
"鲤鱼"      , "🎏",
"鲨鱼"      , "🦈",
"鲸鱼"      , "🐳",
"鳄鱼"      , "🐊",
"鳍"       , "🐬",
"鸡"       , "🐔",
"鸡仔"      , "🐤",
"鸡肶"      , "🍗",
"鸭"       , "🦆",
"鸽"       , "🕊",
"鹰"       , "🦅",
"鹿"       , "🦌",
"麻雀"      , "🀄",
"黄昏"      , "🌆",
"黄色"      , "💛",
"黎紧"      , "🚍",
"黑暗"      , "🕶",
"黑色"      , "🖤",
"鼓"       , "🥁",
"鼓棍"      , "🥁",
"鼠"       , "🐀",
"鼻"       , "👃",
"齿轮"      , "⚙",
"龙"       , "🐲",
"龙脸"      , "🐲",
"龙门"      , "🥅"
};

};

#endif
