<?php

//    include/functions.inc.php
//    General functions
//
//    Part of the ht://Check package
//
//    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
//    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
//
//    For copyright details, see the file COPYING in your distribution
//    or the GNU General Public License version 2 or later 
//    <http://www.gnu.org/copyleft/gpl.html>
//
//    $Id: functions.inc.php,v 1.11 2004/06/01 08:56:19 angusgb Exp $

if ( defined( '__FUNCTIONS_INC' ) ) return;
define( '__FUNCTIONS_INC', 1 );

include ("./include/global.inc.php");

// Get the translation table for characters
$XSS_table = get_html_translation_table(HTML_ENTITIES);
$XSS_table['('] = '&#40;';
$XSS_table[')'] = '&#41;';

// Function for XSS safe writing (www.cgisecurity.com)
function WriteHTML($str)
{
   global $XSS_table;
   return strtr($str, $XSS_table);
}

function DisplayErrMsg($errmsg)
{

?>
   <B><?php echo WriteHTML($errmsg); ?></B><BR>
<?php

}


///////
   // Page Management
///////

function WritePageLink($initpage,$pagesize,$count,$dbname,$otherinfo="")
{
   $nextoffset=$initpage+$pagesize;
   $justone=false;
   global $PHP_SELF;
   global $strNext;
   global $strPrevious;

   if ($initpage >= $pagesize)
   {
      $justone=true;
      
      if ($initpage >= $pagesize*2)
      {
         // Show the first page Link
         global $strFirst;
?>
   | <A href="<?php echo $PHP_SELF; ?>?dbname=<?php echo $dbname; ?>&amp;initpage=0&amp;pagesize=<?php echo $pagesize; ?>&amp;count=<?php echo $count; ?><?php echo $otherinfo; ?>"><?php echo $strFirst; ?></A>
<?php         
      }
?>
   | <A href="<?php echo $PHP_SELF; ?>?dbname=<?php echo $dbname; ?>&amp;initpage=<?php echo $initpage-$pagesize; ?>&amp;pagesize=<?php echo $pagesize; ?>&amp;count=<?php echo $count; ?><?php echo $otherinfo; ?>"><?php echo $strPrevious; ?></A>
<?php
   }
      
   if ($nextoffset < $count)
   {
      $justone=true;
?>
   | <A href="<?php echo $PHP_SELF; ?>?dbname=<?php echo $dbname; ?>&amp;initpage=<?php echo $nextoffset; ?>&amp;pagesize=<?php echo $pagesize; ?>&amp;count=<?php echo $count; ?><?php echo $otherinfo; ?>"><?php echo $strNext; ?></A>
<?php
      if ($nextoffset+$pagesize < $count)
      {
         // Show the last page Link
         global $strLast;
         $lastoffset=((int)((int)($count-1)/$pagesize))*$pagesize;
?>
   | <A href="<?php echo $PHP_SELF; ?>?dbname=<?php echo $dbname; ?>&amp;initpage=<?php echo $lastoffset; ?>&pagesize=<?php echo $pagesize; ?>&amp;count=<?php echo $count; ?><?php echo $otherinfo; ?>"><?php echo $strLast; ?></A>
<?php         
      }

   }

   if ($justone)
   {
      echo "|";
      // Show the full list Link
      ?>
      <a href="<?php echo $PHP_SELF; ?>?dbname=<?php echo $dbname; ?>&amp;initpage=0&amp;pagesize=<?php echo $count; ?>&amp;count=<?php echo $count; ?><?php echo $otherinfo; ?>">Elenco completo</a> |
<?php
   }
}


function GetTextString($str)
{
   if (empty($str))
      $str='Unknown';

   $str2 = "\$str" . (string) $str;
   eval("global $str2;");
   eval("\$tmp=$str2;");
   return $tmp;
}

function GetURL($url)
{
   global $MaxURLStrLength;
   if ($MaxURLStrLength > 0 && strlen($url) > $MaxURLStrLength)
      return WriteHTML(substr($url, 0, $MaxURLStrLength) . '[...]');
   else return WriteHTML($url);
}

?>
