% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combplotp.r
\name{combplotp}
\alias{combplotp}
\title{Combination Plot}
\usage{
combplotp(
  formula,
  data = NULL,
  subset,
  na.action = na.retain,
  vnames = c("labels", "names"),
  includenone = FALSE,
  showno = FALSE,
  maxcomb = NULL,
  minfreq = NULL,
  N = NULL,
  pos = function(x) 1 * (toupper(x) \%in\% c("true", "yes", "y", "positive", "+",
    "present", "1")),
  obsname = "subjects",
  ptsize = 35,
  width = NULL,
  height = NULL,
  ...
)
}
\arguments{
\item{formula}{a formula containing all the variables to be cross-tabulated, on the formula's right hand side.  There is no left hand side variable.  If \code{formula} is omitted, then all variables from \code{data} are analyzed.}

\item{data}{input data frame.  If none is specified the data are assumed to come from the parent frame.}

\item{subset}{an optional subsetting expression applied to \code{data}}

\item{na.action}{see \code{lm} etc.}

\item{vnames}{set to \code{"names"} to use variable names to label axes instead of variable labels.  When using the default \code{labels}, any variable not having a label will have its name used instead.}

\item{includenone}{set to \code{TRUE} to include the combination where all conditions are absent}

\item{showno}{set to \code{TRUE} to show a light dot for conditions that are not part of the currently tabulated combination}

\item{maxcomb}{maximum number of combinations to display}

\item{minfreq}{if specified, any combination having a frequency less than this will be omitted from the display}

\item{N}{set to an integer to override the global denominator, instead of using the number of rows in the data}

\item{pos}{a function of vector returning a logical vector with \code{TRUE} values indicating positive}

\item{obsname}{character string noun describing observations, default is \code{"subjects"}}

\item{ptsize}{point size, defaults to 35}

\item{width}{width of \code{plotly} plot}

\item{height}{height of \code{plotly} plot}

\item{\dots}{optional arguments to pass to \code{table}}
}
\value{
\code{plotly} object
}
\description{
Generates a plotly attribute plot given a series of possibly overlapping binary variables
}
\details{
Similar to the \code{UpSetR} package, draws a special dot chart sometimes called an attribute plot that depicts all possible combination of the binary variables.  By default a positive value, indicating that a certain condition pertains for a subject, is any of logical \code{TRUE}, numberic 1, \code{"yes"}, \code{"y"}, \code{"positive"}, \code{"+"} or \code{"present"} value, and all others are considered negative.  The user can override this determination by specifying her own \code{pos} function.  Case is ignored in the variable values.

The plot uses solid dots arranged in a vertical line to indicate which combination of conditions is being considered.  Frequencies of all possible combinations are shown above the dot chart.  Marginal frequencies of positive values for the input variables are shown to the left of the dot chart.  More information for all three of these component symbols is provided in hover text.

Variables are sorted in descending order of marginal frqeuencies and likewise for combinations of variables.
}
\examples{
g <- function() sample(0:1, n, prob=c(1 - p, p), replace=TRUE)
set.seed(2); n <- 100; p <- 0.5
x1 <- g(); label(x1) <- 'A long label for x1 that describes it'
x2 <- g()
x3 <- g(); label(x3) <- 'This is<br>a label for x3'
x4 <- g()
combplotp(~ x1 + x2 + x3 + x4, showno=TRUE, includenone=TRUE)

n <- 1500; p <- 0.05
pain       <- g()
anxiety    <- g()
depression <- g()
soreness   <- g()
numbness   <- g()
tiredness  <- g()
sleepiness <- g()
combplotp(~ pain + anxiety + depression + soreness + numbness +
          tiredness + sleepiness, showno=TRUE)
}
\author{
Frank Harrell
}
