
BEGIN {
  print("#ifndef main_gameitems_h");
  print("#define main_gameitems_h");
  print("");
  print("#include \"membertable.h\"");
  print("#include <stdlib.h>");
  print("");
}

END {
  print("#endif");
}

/^begin [^ ]+ [^ ]+$/ {
  for(i in members) delete members[i];
  name1 = $2;
  name2 = $3;
}

/^(str|int)( [^ ]+)+/ {
  for(i=2; i<=NF; i++) {
    if(split($i, f, "=") == 2) {
      members[f[1]] = $1;
      default[f[1]] = f[2];
    }
  }
}

/^end$/ {
  print("struct "name1);
  print("{");
  for(i in members)
    print(" "((members[i] == "str")? "char* " : "int ")i";");
  print("};");
  print("");

  print("#ifdef main_gameitems_c");
  print("struct MemberTable "name2"Members[] =");
  print("{");
  for(i in members)
    print(" { mt_"members[i]", \""i"\", &(((struct "name1"*)0)->"i") },");
  print(" { mt_end, NULL, NULL }");
  print("};");
  print("struct "name1" "name2"DefaultStruct =");
  print("{");
  for(i in members)
    print(" "default[i]",");
  print("};");
  print("struct "name1"* "name2"Default = &"name2"DefaultStruct;");
  print("#else");
  print("# ifdef __cplusplus");
  print("extern \"C\" MemberTable "name2"Members[];");
  print("extern \"C\" "name1"* "name2"Default;");
  print("# else");
  print("extern struct MemberTable "name2"Members[];");
  print("extern struct "name1"* "name2"Default;");
  print("# endif");
  print("#endif");
  print("");
}
