/*C* $Id: pos.h,v 1.2 1997/08/11 19:21:31 james Exp $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef main_Pos_h
#define main_Pos_h

#include "../util/Object.h"

class Pos : public Object
{
public:
 int x, y;
 Pos() { x = y = 0; }
 Pos(int _x, int _y) { x = _x; y = _y; }
 Pos operator = (int i) { x = y = i; return Pos(x, y); }
 Pos operator = (const Pos& pos) { return Pos(x = pos.x, y = pos.y); }
 Pos operator + (const Pos& pos) { return Pos(x + pos.x, y + pos.y); }
 Pos operator += (const Pos& pos) { return Pos(x += pos.x, y += pos.y); }
 Pos operator * (const Pos& pos) { return Pos(x * pos.x, y * pos.y); }
 Pos operator * (int i) { return Pos(x * i, y * i); }
 bool contains(Pos p) const { return (p.x >= 0 && p.y >= 0 && p.x < x && p.y < y)? true : false; }
 bool operator == (const Pos& pos) { return (x == pos.x && y == pos.y)? true : false; }
 void set(int _x, int _y) { x = _x; y = _y; }
};
#endif
