/*
 *  $Id: wrap_calls.h 19268 2016-11-15 12:48:19Z yeti-dn $
 *  Copyright (C) 2008 Jan Horak, 2015-2016 David Necas (Yeti)
 *  E-mail: xhorak@gmail.com, yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *  Description: This file contains custom fuctions for automatically
 *  generated wrapping by using pygwy-codegen.
 */

#ifndef __PYGWY_WRAP_CALLS_H__
#define __PYGWY_WRAP_CALLS_H__

#include <libgwyddion/gwyddion.h>
#include <libprocess/gwyprocess.h>
#include <libdraw/gwydraw.h>
#include <libgwydgets/gwydgets.h>
#include <libgwymodule/gwymodule.h>
#include <app/gwyapp.h>

typedef gboolean GwyArrayFuncStatus;

typedef GArray *GwyDoubleArrayOutArg;
typedef GArray GwyDoubleArray;
typedef GArray *GwyIntArrayOutArg;
typedef GArray GwyIntArray;

gdouble            gwy_math_median_pygwy                           (GwyDoubleArray *array);
GwyArrayFuncStatus gwy_math_curvature_pygwy                        (GwyDoubleArray *coeffs,
                                                                    gint *dimen,
                                                                    gdouble *kappa1,
                                                                    gdouble *kappa2,
                                                                    gdouble *phi1,
                                                                    gdouble *phi2,
                                                                    gdouble *xc,
                                                                    gdouble *yc,
                                                                    gdouble *zc);
GwyArrayFuncStatus gwy_math_refine_maximum_pygwy                   (GwyDoubleArray *z,
                                                                    gdouble *x,
                                                                    gdouble *y,
                                                                    gboolean *refined);
GwyArrayFuncStatus gwy_math_is_in_polygon_pygwy                    (gdouble x,
                                                                    gdouble y,
                                                                    GwyDoubleArray *poly,
                                                                    gboolean *is_inside);
GwyArrayFuncStatus gwy_math_find_nearest_line_pygwy                (gdouble x,
                                                                    gdouble y,
                                                                    GwyDoubleArray *coords,
                                                                    GwyDoubleArray *metric,
                                                                    gint *idx,
                                                                    gdouble *d2min);
GwyArrayFuncStatus gwy_math_find_nearest_point_pygwy               (gdouble x,
                                                                    gdouble y,
                                                                    GwyDoubleArray *coords,
                                                                    GwyDoubleArray *metric,
                                                                    gint *idx,
                                                                    gdouble *d2min);
GwyArrayFuncStatus gwy_math_fit_polynom_pygwy                      (GwyDoubleArray *xdata,
                                                                    GwyDoubleArray *ydata,
                                                                    gint n,
                                                                    GwyDoubleArrayOutArg coeffs);
GwyDoubleArray*    gwy_fft_window_pygwy                            (GwyDoubleArray *data,
                                                                    GwyWindowingType windowing);
GwyDoubleArray*    gwy_selection_get_data_pygwy                    (GwySelection *selection);
GwyDoubleArray*    gwy_selection_get_object_pygwy                  (GwySelection *selection,
                                                                    gint i);
GwyArrayFuncStatus gwy_selection_set_data_pygwy                    (GwySelection *selection,
                                                                    GwyDoubleArray *data);
GwyArrayFuncStatus gwy_selection_set_object_pygwy                  (GwySelection *selection,
                                                                    gint i,
                                                                    GwyDoubleArray *data);
GwyDoubleArray*    gwy_data_line_get_data_pygwy                    (GwyDataLine *data_line);
GwyDoubleArray*    gwy_data_field_get_data_pygwy                   (GwyDataField *data_field);
GwyDoubleArray*    gwy_brick_get_data_pygwy                        (GwyBrick *brick);
GwyArrayFuncStatus gwy_data_line_set_data_pygwy                    (GwyDataLine *data_line,
                                                                    GwyDoubleArray *data);
GwyArrayFuncStatus gwy_data_field_set_data_pygwy                   (GwyDataField *data_field,
                                                                    GwyDoubleArray *data);
GwyArrayFuncStatus gwy_brick_set_data_pygwy                        (GwyBrick *brick,
                                                                    GwyDoubleArray *data);
GwyDoubleArray*    gwy_data_field_fit_polynom_pygwy                (GwyDataField *data_field,
                                                                    gint col_degree,
                                                                    gint row_degree);
GwyDoubleArray*    gwy_data_field_area_fit_polynom_pygwy           (GwyDataField *data_field,
                                                                    gint col,
                                                                    gint row,
                                                                    gint width,
                                                                    gint height,
                                                                    gint col_degree,
                                                                    gint row_degree);
GwyArrayFuncStatus gwy_data_field_subtract_polynom_pygwy           (GwyDataField *data_field,
                                                                    gint col_degree,
                                                                    gint row_degree,
                                                                    GwyDoubleArray *coeffs);
GwyArrayFuncStatus gwy_data_field_area_subtract_polynom_pygwy      (GwyDataField *data_field,
                                                                    gint col,
                                                                    gint row,
                                                                    gint width,
                                                                    gint height,
                                                                    gint col_degree,
                                                                    gint row_degree,
                                                                    GwyDoubleArray *coeffs);
GwyDoubleArray*    gwy_data_field_fit_legendre_pygwy               (GwyDataField *data_field,
                                                                    gint col_degree,
                                                                    gint row_degree);
GwyDoubleArray*    gwy_data_field_area_fit_legendre_pygwy          (GwyDataField *data_field,
                                                                    gint col,
                                                                    gint row,
                                                                    gint width,
                                                                    gint height,
                                                                    gint col_degree,
                                                                    gint row_degree);
GwyArrayFuncStatus gwy_data_field_subtract_legendre_pygwy          (GwyDataField *data_field,
                                                                    gint col_degree,
                                                                    gint row_degree,
                                                                    GwyDoubleArray *coeffs);
GwyArrayFuncStatus gwy_data_field_area_subtract_legendre_pygwy     (GwyDataField *data_field,
                                                                    gint col,
                                                                    gint row,
                                                                    gint width,
                                                                    gint height,
                                                                    gint col_degree,
                                                                    gint row_degree,
                                                                    GwyDoubleArray *coeffs);
GwyDoubleArray*    gwy_data_field_fit_poly_max_pygwy               (GwyDataField *data_field,
                                                                    gint max_degree);
GwyDoubleArray*    gwy_data_field_area_fit_poly_max_pygwy          (GwyDataField *data_field,
                                                                    gint col,
                                                                    gint row,
                                                                    gint width,
                                                                    gint height,
                                                                    gint max_degree);
GwyArrayFuncStatus gwy_data_field_subtract_poly_max_pygwy          (GwyDataField *data_field,
                                                                    gint max_degree,
                                                                    GwyDoubleArray *coeffs);
GwyArrayFuncStatus gwy_data_field_area_subtract_poly_max_pygwy     (GwyDataField *data_field,
                                                                    gint col,
                                                                    gint row,
                                                                    gint width,
                                                                    gint height,
                                                                    gint max_degree,
                                                                    GwyDoubleArray *coeffs);
GwyArrayFuncStatus gwy_data_field_fit_poly_pygwy                   (GwyDataField *data_field,
                                                                    GwyDataField *mask_field,
                                                                    GwyIntArray *term_powers,
                                                                    gboolean exclude,
                                                                    GwyDoubleArrayOutArg coeffs);
GwyArrayFuncStatus gwy_data_field_area_fit_poly_pygwy              (GwyDataField *data_field,
                                                                    GwyDataField *mask_field,
                                                                    gint col,
                                                                    gint row,
                                                                    gint width,
                                                                    gint height,
                                                                    GwyIntArray *term_powers,
                                                                    gboolean exclude,
                                                                    GwyDoubleArrayOutArg coeffs);
GwyArrayFuncStatus gwy_data_field_subtract_poly_pygwy              (GwyDataField *data_field,
                                                                    GwyIntArray *term_powers,
                                                                    GwyDoubleArray *coeffs);
GwyArrayFuncStatus gwy_data_field_area_subtract_poly_pygwy         (GwyDataField *data_field,
                                                                    gint col,
                                                                    gint row,
                                                                    gint width,
                                                                    gint height,
                                                                    GwyIntArray *term_powers,
                                                                    GwyDoubleArray *coeffs);
GwyDoubleArray*    gwy_data_field_elliptic_area_extract_pygwy      (GwyDataField *data_field,
                                                                    gint col,
                                                                    gint row,
                                                                    gint width,
                                                                    gint height);
GwyArrayFuncStatus gwy_data_field_elliptic_area_unextract_pygwy    (GwyDataField *data_field,
                                                                    gint col,
                                                                    gint row,
                                                                    gint width,
                                                                    gint height,
                                                                    GwyDoubleArray *data);
GwyDoubleArray*    gwy_data_field_circular_area_extract_pygwy      (GwyDataField *data_field,
                                                                    gint col,
                                                                    gint row,
                                                                    gdouble radius);
GwyArrayFuncStatus gwy_data_field_circular_area_unextract_pygwy    (GwyDataField *data_field,
                                                                    gint col,
                                                                    gint row,
                                                                    gdouble radius,
                                                                    GwyDoubleArray *data);
GwyArrayFuncStatus gwy_data_field_affine_pygwy                     (GwyDataField *data_field,
                                                                    GwyDataField *dest,
                                                                    GwyDoubleArray *affine,
                                                                    GwyInterpolationType interp,
                                                                    GwyExteriorType exterior,
                                                                    gdouble fill_value);
void               gwy_data_field_get_local_maxima_list_pygwy      (GwyDataField *dfield,
                                                                    GwyDoubleArrayOutArg xdata,
                                                                    GwyDoubleArrayOutArg ydata,
                                                                    GwyDoubleArrayOutArg zdata,
                                                                    gint ndata,
                                                                    gint skip,
                                                                    gdouble threshold,
                                                                    gboolean subpixel);
GwyPlaneSymmetry   gwy_data_field_unrotate_find_corrections_pygwy  (GwyDataLine *derdist,
                                                                    GwyDoubleArrayOutArg correction);
GwyDoubleArray*    gwy_data_line_part_fit_polynom_pygwy            (GwyDataLine *data_line,
                                                                    gint n,
                                                                    gint from,
                                                                    gint to);
GwyDoubleArray*    gwy_data_line_fit_polynom_pygwy                 (GwyDataLine *data_line,
                                                                    gint n);
void               gwy_data_line_part_subtract_polynom_pygwy       (GwyDataLine *data_line,
                                                                    GwyDoubleArray *coeffs,
                                                                    gint from,
                                                                    gint to);
void               gwy_data_line_subtract_polynom_pygwy            (GwyDataLine *data_line,
                                                                    GwyDoubleArray *coeffs);
GQuark             gwy_key_from_name_pygwy                         (const gchar *name);
const gchar*       gwy_name_from_key_pygwy                         (GQuark key);
GwyIntArray*       gwy_container_keys_pygwy                        (GwyContainer *container);
GwyIntArray*       gwy_app_data_browser_get_data_ids_pygwy         (GwyContainer *container);
GwyIntArray*       gwy_app_data_browser_get_graph_ids_pygwy        (GwyContainer *container);
GwyIntArray*       gwy_app_data_browser_get_spectra_ids_pygwy      (GwyContainer *container);
GwyIntArray*       gwy_app_data_browser_get_volume_ids_pygwy       (GwyContainer *container);
GwyIntArray*       gwy_app_data_browser_get_xyz_ids_pygwy          (GwyContainer *container);
GwyIntArray*       gwy_app_data_browser_find_data_by_title_pygwy   (GwyContainer *data,
                                                                    const gchar *titleglob);
GwyIntArray*       gwy_app_data_browser_find_graphs_by_title_pygwy (GwyContainer *data,
                                                                    const gchar *titleglob);
GwyIntArray*       gwy_app_data_browser_find_spectra_by_title_pygwy(GwyContainer *data,
                                                                    const gchar *titleglob);
GwyIntArray*       gwy_app_data_browser_find_volume_by_title_pygwy (GwyContainer *data,
                                                                    const gchar *titleglob);
GwyIntArray*       gwy_app_data_browser_find_xyz_by_title_pygwy    (GwyContainer *data,
                                                                    const gchar *titleglob);
GwyIntArray*       gwy_data_field_number_grains_pygwy              (GwyDataField *mask_field);
GwyIntArray*       gwy_data_field_number_grains_periodic_pygwy     (GwyDataField *mask_field);
GwyArrayFuncStatus gwy_data_field_get_grain_sizes_pygwy            (GwyDataField *data_field,
                                                                    GwyIntArray *grains,
                                                                    GwyIntArrayOutArg sizes);
GwyArrayFuncStatus gwy_data_field_get_grain_bounding_boxes_pygwy   (GwyDataField *data_field,
                                                                    GwyIntArray *grains,
                                                                    GwyIntArrayOutArg bboxes);
GwyArrayFuncStatus gwy_data_field_grains_get_values_pygwy          (GwyDataField *data_field,
                                                                    GwyIntArray *grains,
                                                                    GwyGrainQuantity quantity,
                                                                    GwyDoubleArrayOutArg values);
GwyDataLine*       gwy_data_field_grains_get_distribution_pygwy    (GwyDataField *data_field,
                                                                    GwyDataField *grain_field,
                                                                    GwyIntArray *grains,
                                                                    GwyGrainQuantity quantity,
                                                                    gint nstats);
GwyDataField*      gwy_tip_dilation_pygwy                          (GwyDataField *tip,
                                                                    GwyDataField *surface);
GwyDataField*      gwy_tip_erosion_pygwy                           (GwyDataField *tip,
                                                                    GwyDataField *surface);
GwyDataField*      gwy_tip_cmap_pygwy                              (GwyDataField *tip,
                                                                    GwyDataField *surface);
GwyDataField*      gwy_data_field_create_full_mask_pygwy           (GwyDataField *d);
gboolean           gwy_get_grain_quantity_needs_same_units_pygwy   (GwyGrainQuantity quantity);
GwySIUnit*         gwy_construct_grain_quantity_units_pygwy        (GwyGrainQuantity quantity,
                                                                    GwySIUnit *siunitxy,
                                                                    GwySIUnit *siunitz);
void               gwy_surface_set_pygwy                           (GwySurface *surface,
                                                                    guint pos,
                                                                    const GwyXYZ *point);
GwyIntArray*       gwy_spectra_find_nearest_pygwy                  (GwySpectra *spectra,
                                                                    gdouble x,
                                                                    gdouble y,
                                                                    guint n);
GwyDoubleArray*    gwy_graph_curve_model_get_xdata_pygwy           (GwyGraphCurveModel *gcmodel);
GwyDoubleArray*    gwy_graph_curve_model_get_ydata_pygwy           (GwyGraphCurveModel *gcmodel);
GwyArrayFuncStatus gwy_graph_curve_model_set_data_pygwy            (GwyGraphCurveModel *gcmodel,
                                                                    GwyDoubleArray *xdata,
                                                                    GwyDoubleArray *ydata);
GwyArrayFuncStatus gwy_graph_curve_model_set_data_interleaved_pygwy(GwyGraphCurveModel *gcmodel,
                                                                    GwyDoubleArray *xydata);
void               gwy_graph_area_set_x_grid_data_pygwy            (GwyGraphArea *area,
                                                                    GwyDoubleArray *grid_data);
void               gwy_graph_area_set_y_grid_data_pygwy            (GwyGraphArea *area,
                                                                    GwyDoubleArray *grid_data);
GwyDoubleArray*    gwy_graph_area_get_x_grid_data_pygwy            (GwyGraphArea *area);
GwyDoubleArray*    gwy_graph_area_get_y_grid_data_pygwy            (GwyGraphArea *area);
GwyDoubleArray*    gwy_draw_data_field_map_adaptive_pygwy          (GwyDataField *data_field,
                                                                    GwyDoubleArray *z);
GwyDoubleArray*    gwy_data_view_get_metric_pygwy                  (GwyDataView *data_view);
GwyDoubleArray*    gwy_axis_get_major_ticks_pygwy                  (GwyAxis *axis);
gulong             gwy_app_undo_qcheckpoint_pygwy                  (GwyContainer *container,
                                                                    GwyIntArray *keys);
GObject*           gwy_inventory_get_item_pygwy                    (GwyInventory *inventory,
                                                                    const gchar *name);
GObject*           gwy_inventory_get_item_or_default_pygwy         (GwyInventory *inventory,
                                                                    const gchar *name);
GObject*           gwy_inventory_get_nth_item_pygwy                (GwyInventory *inventory,
                                                                    guint n);
GObject*           gwy_inventory_get_default_item_pygwy            (GwyInventory *inventory);
void               gwy_inventory_insert_item_pygwy                 (GwyInventory *inventory,
                                                                    GObject *object);
void               gwy_inventory_insert_nth_item_pygwy             (GwyInventory *inventory,
                                                                    GObject *object,
                                                                    guint n);
void               gwy_inventory_rename_item_pygwy                 (GwyInventory *inventory,
                                                                    const gchar *name,
                                                                    const gchar *newname);
GObject*           gwy_inventory_new_item_pygwy                    (GwyInventory *inventory,
                                                                    const gchar *name,
                                                                    const gchar *newname);
GwyArrayFuncStatus gwy_cdline_fit_pygwy                            (GwyCDLine *cdline,
                                                                    GwyDoubleArray *x,
                                                                    GwyDoubleArray *y,
                                                                    GwyDoubleArrayOutArg params,
                                                                    GwyDoubleArrayOutArg err);
GwyArrayFuncStatus gwy_cdline_get_value_pygwy                      (GwyCDLine *cdline,
                                                                    gdouble x,
                                                                    GwyDoubleArray *params,
                                                                    gdouble *value,
                                                                    gboolean *fres);
GwyArrayFuncStatus gwy_peaks_analyze_pygwy                         (GwyPeaks *peaks,
                                                                    GwyDoubleArray *xdata,
                                                                    GwyDoubleArray *ydata,
                                                                    guint maxpeaks,
                                                                    guint *npeaks);
GwyDoubleArray*    gwy_peaks_get_quantity_pygwy                    (GwyPeaks *peaks,
                                                                    GwyPeakQuantity quantity);
GwyDoubleArray*    gwy_marker_box_get_markers_pygwy                (GwyMarkerBox *mbox);
void               gwy_marker_box_set_markers_pygwy                (GwyMarkerBox *mbox,
                                                                    GwyDoubleArray *markers);

#endif

/* vim: set cin et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
