/* $Id: View.h,v 1.11 2005/04/05 12:02:56 ellson Exp $ $Revision: 1.11 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#include "createLayoutServer.h"

// basic stuff to handle an engine/layout pair with named nodes & edges.
// applications (e.g. the dynagraph executable & dynagraph COM component)
// derive from this and override the Incr...() methods to share a basic 
// understanding of how to deal with names, how to create/replace the layout server, etc.

struct View;
typedef std::map<DString,View*> Views;
extern Views g_views; // in incrcmds
struct View {
	typedef std::map<DString,Layout::Node*> nodeDict;
	typedef std::map<DString,Layout::Edge*> edgeDict;
	nodeDict nodes;
	edgeDict edges;
	Layout layout, // everything the client has created
        current, // what's currently being controlled by engine
        old; // when switching engines, the stuff that was already here
	ChangeQueue Q;
	Server *dgserver;
	int locks;
	bool allowAnOpen; // when created outside incrface but want to allow "open view"

	// implement these to respond to incrface events
	virtual void IncrHappened() = 0;
	virtual void IncrNewNode(Layout::Node *n) = 0;
	virtual void IncrNewEdge(Layout::Edge *e) = 0;

	View(Name name = Name());
	virtual ~View();
    // create or replace engine based on "engines" attribute of layout
    void createServer();
    // complete an engine replacement by changing the insertions into new engine into modifies
    // (call after dgserver->Process but before dealing with Q
    void completeReplacement();
	// tricky problem: if client doesn't specify a name, we need to generate one
	// can't use e.g. e17 because the client might already have something named that!
	// so generate a random name
	static DString randomName(char prefix);
	// to detect those bad names that agraph is generating
	static bool poorEdgeName(const char *name);
	std::pair<Layout::Node*,bool> getNode(DString id,bool create);
	Layout::Node *getNode(DString id);
	std::pair<Layout::Edge*,bool> getEdge(DString id,Layout::Node *t,Layout::Node *h,bool create);
	std::pair<Layout::Edge*,bool> getEdge(DString id,DString tail,DString head,bool create);
	Layout::Edge *getEdge(DString id,DString tail,DString head);
	Layout::Edge *getEdge(DString id);
	void rename(Layout *l,DString newName);
	void rename(Layout::Node *n,DString newName);
	void rename(Layout::Edge *e,DString newName);
	void forget(Layout::Node *n);
	void forget(Layout::Edge *e);
	// important to destroy edges because graph representation won't allow
	// you to draw two edges t->h
	void destroy(Layout::Node *n);
	void destroy(Layout::Edge *e);
};
