/* $Id: derivable_dt.h,v 1.5 2005/04/05 12:02:55 ellson Exp $ $Revision: 1.5 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

// cdt does not allow you to allocate your own Dt_t, which is annoying
// because you always want to put something with it for all the callbacks!
// so, fool it: on open, allow it to allocate, then copy & free
// on close, make a copy which it can free
struct derivable_dt : Dt_t {
	void open(Dtdisc_t* disc, Dtmethod_t* meth) {
		Dt_t *dt = dtopen(disc,meth);
		memcpy(static_cast<Dt_t*>(this),dt,sizeof(Dt_t));
		free(dt);
	}
	void close() {
		Dt_t *cp = (Dt_t*)malloc(sizeof(Dt_t));
		memcpy(cp,this,sizeof(Dt_t));
		dtclose(cp);
	}
};
