/* $Id: PathPlan.h,v 1.10 2005/04/05 12:02:55 ellson Exp $ $Revision: 1.10 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#include "common/Geometry.h"

namespace PathPlan {
	typedef std::vector<Segment> SegmentV;
	typedef std::vector<Line> LineV;

    struct InvalidBoundary : DGException {
	  InvalidBoundary() : DGException("the shortest path algorithm requires a polygon boundary") {}
	};
	struct EndpointNotInPolygon : DGException { 
	  bool which; 
	  EndpointNotInPolygon(bool which) : 
	    DGException("the shortest path algorithm requires end-points within the boundary polygon"),
	    which(which) {}
	};
	/* find shortest euclidean path within a simple polygon */
	void Shortest(const Line &boundary, Segment endpoints, Line &out);

	/* fit a spline to an input polyline, without touching barrier segments */
	bool Route(const SegmentV &barriers, const Line &inputRoute,
		Segment endSlopes,Line &out);

	/* utility function to convert from a set of polygonal obstacles to barriers */
	void PolyBarriers(const LineV &polygons, SegmentV &out);
}
