/*
 * GPG Keys 
 * cmainwindow.h
 * (c) 2001 Peter Mathiasson <peter@mathiasson.nu>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation
 */

#ifndef __CMAINWINDOW_H__
#define __CMAINWINDOW_H__
 
#include <qmainwindow.h>

class CKeyServer;
class QString;
class QListView;
class CListViewItem;
class QListViewItem;
class QProcess;
class QPopupMenu;
class QIconSet;
class QTabBar;

class CMainWindow : public QMainWindow
{
    Q_OBJECT

public:
    CMainWindow();
    ~CMainWindow();

public slots:
    void processDone();
    void readFromStdout();
    void tabSelected( int id );
    void menuEvent( int item );
    void reReadPublic();
    void contextMenuRequested( QListViewItem *tmpItem, const QPoint &pos, int );
    void tcpStatusChange( int newStatus );
    void tcpSendDone();
    void exportProcDone();
    void gnupgProcMessage( QString message, int timeout );
    //void exportReadStdout();

private:
    void addMenuItem( QPopupMenu *menu, const char *text, int menuItem, int accel = 0 );
    void addMenuItem( QPopupMenu *menu, QIconSet iconSet, const char *text, int menuItem,
                      int accel = 0 );
    void applySettings();
    void readKeys( bool publicKey );

    void about();
    void properties();
    void keyInfo();
    void serverSearch( bool quickSearch );
    void sendKey();
#ifdef CLIPBOARD_SUPPORT
    void toClipboard();
    void fromClipboard();
#endif
    void toFile();
    void fromFile();
    void signKey();
    void doDelete();
    void exportKey( QString keyID );

    int checkCurrentItem();

    CKeyServer *keyServer;
    QTabBar *tabBar;
    QListView *listMain;
    CListViewItem *itemCurrent;
    CListViewItem *itemPub;
    CListViewItem *itemUid;
    QProcess *gpgProc;

    QString listCommand;
    QString fileName;

    QPopupMenu *menuFile;
    QPopupMenu *menuCmd;
    QPopupMenu *menuHelp;
    QPopupMenu *menuPublic;
    QPopupMenu *menuSignature;
    int exportOperation;
};

#endif // __CMAINWINDOW_H__
