/*
 * GPG Keys 
 * cgpgproc.cpp
 * (c) 2001 Peter Mathiasson <peter@mathiasson.nu>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation
 */

#include <qapp.h>
#include <qobject.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qprocess.h>
#include "cgpgproc.h"
#include "functions.h"
#include "config.h"

/* --------------------------------------------------------------------------------- */

CGPGProc::CGPGProc( QObject *parent ) : QObject( parent, "CGPGProc" )
{
    proc = new QProcess( this );    
}

/* --------------------------------------------------------------------------------- */

bool CGPGProc::import( const QString importData )
{    
    /* Check for running GPG */
    if ( proc->isRunning() )
        return ALREADYRUNNING;

    /* Setup Arguments */
    proc->clearArguments();
    proc->addArgument( readConfigString( "gpgpath", GPGPATH ) );
    proc->addArgument( "--import" );

    /* Run GPG */
    emit message( tr( "Importing key(s)" ), 0 );
    if ( !proc->launch( importData ) ) {
        emit message( tr( "Run failed"), 2000 );
        return RUNFAILED;
    }

    /* Wait */
    while ( proc->isRunning() ) {
        qApp->processEvents();
    }

    /* Check Exit Status */
    if ( proc->normalExit() && !proc->exitStatus() ) {
        emit message( tr( "Key(s) sucessfully imported" ), 2000 );
        return OK;
    } else {
        emit message( tr( "Import failed" ), 2000 );
        return ERROR;
    }
    
}

/* --------------------------------------------------------------------------------- */

int CGPGProc::run( QObject *parent, const QStringList args, const QString stdin,
                   bool terminal )
{

    /* Create Process */
    QProcess *gpgProc = new QProcess( parent );
    if ( terminal ) {
        QStringList term = QStringList::split( ' ', readConfigString( "terminal", TERMINAL ) );
        for ( unsigned int i = 0; i < term.size(); i++ ) {
            gpgProc->addArgument( term[i] );
        }
    }
    gpgProc->addArgument( readConfigString( "gpgpath", GPGPATH ) );
    for ( unsigned int i = 0; i < args.size(); i++ ) {
        gpgProc->addArgument( args[i] );
    }
    
    /* Run GPG */
    int retval;
    if ( stdin == QString::null ) {
        retval = gpgProc->start();
    } else {
        retval = gpgProc->launch( stdin );
    }

    if ( !retval ) {
        return RUNFAILED;
    }

    /* Wait */
    while ( gpgProc->isRunning() ) {
        qApp->processEvents();
    }

    /* Check Exit Status */
    if ( gpgProc->normalExit() && !gpgProc->exitStatus() ) {
        return OK;
    } else {
        return ERROR;
    }

}

/* --------------------------------------------------------------------------------- */


