/* util.c -- functions for initializing new tree elements, and other things.
   Copyright (C) 1990, 91, 92, 93, 94 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <config.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include "defs.h"
#include "pred.h"
#include "error.h"

#if 0
/* Return the last component of pathname FNAME, with leading slashes
   compressed into one slash. */

char *
basename (fname)
     const char *fname;
{
  char *p;

  /* For "/", "//", etc., return "/". */
  for (p = (char *)fname; *p == '/'; ++p)
    /* Do nothing. */ ;
  if (*p == '\0')
    return p - 1;
  p = strrchr (fname, '/');
  return (p == NULL ? (char *)fname : p + 1);
}
#endif

/* Return a pointer to a new predicate structure, which has been
   linked in as the last one in the predicates list.

   Set `predicates' to point to the start of the predicates list.
   Set `last_pred' to point to the new last predicate in the list.
   
   Set all cells in the new structure to the default values. */

struct predicate *
get_new_pred (win_t *w)
{
  register struct predicate *new_pred;

  if (w->predicates == NULL)
    {
      w->predicates = g_new(struct predicate, 1);
      w->last_pred = w->predicates;
    }
  else
    {
      new_pred = g_new(struct predicate, 1);
      w->last_pred->pred_next = new_pred;
      w->last_pred = new_pred;
    }
  w->last_pred->pred_func = NULL;
#ifdef	DEBUG
  w->last_pred->p_name = NULL;
#endif	/* DEBUG */
  w->last_pred->p_type = NO_TYPE;
  w->last_pred->p_prec = NO_PREC;
  w->last_pred->side_effects = false;
  w->last_pred->need_stat = true;
  w->last_pred->args.str = NULL;
  w->last_pred->pred_next = NULL;
  w->last_pred->pred_left = NULL;
  w->last_pred->pred_right = NULL;
  return (w->last_pred);
}

/* Return a pointer to a new predicate, with operator check.
   Like get_new_pred, but it checks to make sure that the previous
   predicate is an operator.  If it isn't, the AND operator is inserted. */

struct predicate *
get_new_pred_chk_op (win_t *w)
{
  struct predicate *new_pred;

  if (w->last_pred)
    switch (w->last_pred->p_type)
      {
      case NO_TYPE:
	error (w, -1, 0, "oops -- invalid default insertion of and!");
	return NULL;
	break;

      case PRIMARY_TYPE:
      case CLOSE_PAREN:
	new_pred = get_new_pred (w);
	new_pred->pred_func = pred_and;
#ifdef	DEBUG
	new_pred->p_name = find_pred_name (pred_and);
#endif	/* DEBUG */
	new_pred->p_type = BI_OP;
	new_pred->p_prec = AND_PREC;
	new_pred->need_stat = false;
	new_pred->args.str = NULL;

      default:
	break;
      }
  return (get_new_pred (w));
}

/* Add a primary of predicate type PRED_FUNC to the predicate input list.

   Return a pointer to the predicate node just inserted.

   Fills in the following cells of the new predicate node:

   pred_func	    PRED_FUNC
   args(.str)	    NULL
   p_type	    PRIMARY_TYPE
   p_prec	    NO_PREC

   Other cells that need to be filled in are defaulted by
   get_new_pred_chk_op, which is used to insure that the prior node is
   either not there at all (we are the very first node) or is an
   operator. */

struct predicate *
insert_primary (w, pred_func)
     win_t *w;
     boolean (*pred_func) ();
{
  struct predicate *new_pred;

  new_pred = get_new_pred_chk_op (w);
  new_pred->pred_func = pred_func;
#ifdef	DEBUG
  new_pred->p_name = find_pred_name (pred_func);
#endif	/* DEBUG */
  new_pred->args.str = NULL;
  new_pred->p_type = PRIMARY_TYPE;
  new_pred->p_prec = NO_PREC;
  return (new_pred);
}

void
usage (w, msg)
     win_t *w;
     char *msg;
{
  if (msg)
    fprintf (stderr, "%s: %s\n", w->program_name, msg);
  fprintf (stderr, "\
Usage: %s [path...] [expression]\n", w->program_name);
  exit (1);
}
