/* vi:set ts=8 sts=0 sw=8:
 * $Id: multiple.c,v 1.1 2000/07/15 20:02:46 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "win.h"
#include "main.h"
#include "misc.h"
#include "prefs.h"
#include "search.h"
#include "multiple.h"


enum Ef_mf_id_e {
	Ef_mf_dialog,
	Ef_mf_filename,		/* entry */
	Ef_mf_add,		/* button */
	Ef_mf_list,		/* clist */
	Ef_mf_toolbar,		/* toolbar */
	Ef_mf_up,		/* button */
	Ef_mf_down,		/* button */
	Ef_mf_del,		/* button */
	Ef_mf_clear,		/* button */
	Ef_mf_close,		/* button */
	Ef_mf_MAX
};
typedef enum Ef_mf_id_e Ef_mf_id_t;

enum Ef_md_id_e {
	Ef_md_dialog,
	Ef_md_dirname,		/* entry */
	Ef_md_add,		/* button */
	Ef_md_list,		/* clist */
	Ef_md_toolbar,		/* toolbar */
	Ef_md_up,		/* button */
	Ef_md_down,		/* button */
	Ef_md_del,		/* button */
	Ef_md_clear,		/* button */
	Ef_md_close,		/* button */
	Ef_md_MAX
};
typedef enum Ef_md_id_e Ef_md_id_t;


/*** PRIVATE FUNCTION PROTOTYPES ***/
static void entry_mult_files_cb(GtkWidget *wgt, gpointer cbdata);
static void entry_mult_dirs_cb(GtkWidget *wgt, gpointer cbdata);
static void mult_files_close_cb(GtkWidget *wgt, gpointer cbdata);
static void mult_files_add_cb(GtkWidget *wgt, gpointer cbdata);
static void mult_dirs_close_cb(GtkWidget *wgt, gpointer cbdata);
static void mult_dirs_add_cb(GtkWidget *wgt, gpointer cbdata);
static int list_items_add(win_t *, int list_id, GSList *argvl, gboolean is_dir);
static gboolean is_multi_common(GtkWidget **wgts, int list_id);
static int list_menu_popup_cb(GtkWidget *, GdkEventButton *ev, gpointer cbdata);
static GtkWidget **mult_dialog_create_common(win_t *w, GtkWidget **wgts,
					     int num, ef_t ef_wgts[],
					     char *name, int top_id,
					     int max_id, int list_id);
static void mult_dialog_create(win_t *w, gboolean is_dir);
static void entry_mult_common_cb(win_t *w, GtkWidget **wgts, int entry_id,
				 int add_id);
static void mult_clear_common(win_t *w, GtkWidget **wgts, int list_id,
			      gboolean is_dir);
static void mult_add_common(win_t *w, GtkWidget **wgts, int entry_id,
			    int list_id, gboolean is_dir);
static void mult_dim_save_common(GtkWidget **wgts, int top_id, int prefs_id_w,
				 int prefs_id_h);
static gboolean mult_dialog_key_press(GtkWidget *wgt, GdkEventKey *ev,
				      GtkWidget *toplev);
static void mult_files_del_cb(GtkWidget *wgt, gpointer cbdata);
static void mult_dirs_del_cb(GtkWidget *wgt, gpointer cbdata);
static void mult_files_up_cb(GtkWidget *wgt, gpointer cbdata);
static void mult_dirs_up_cb(GtkWidget *wgt, gpointer cbdata);
static void mult_files_down_cb(GtkWidget *wgt, gpointer cbdata);
static void mult_dirs_down_cb(GtkWidget *wgt, gpointer cbdata);


static ef_t ef_mf_widgets[] = {
	{
		"Multiple Files",
		Ef_mf_dialog,
		Ef_wgt_dialog
	},
	{
		"entry_mult_files",
		Ef_mf_filename,
		Ef_wgt_entry,
		GTK_SIGNAL_FUNC(entry_mult_files_cb),
	},
	{
		"but_mult_files_add",
		Ef_mf_add,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(mult_files_add_cb),
	},
	{
		"clist_mult_files",
		Ef_mf_list,
		Ef_wgt_clist,
	},
	{
		"tb_mult_files",
		Ef_mf_toolbar,
		Ef_wgt_toolbar,
	},
	{
		"but_mult_files_up",
		Ef_mf_up,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(mult_files_up_cb)
	},
	{
		"but_mult_files_down",
		Ef_mf_down,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(mult_files_down_cb)
	},
	{
		"but_mult_files_del",
		Ef_mf_del,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(mult_files_del_cb),
	},
	{
		"but_mult_files_clear",
		Ef_mf_clear,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(mult_files_clear_cb),
	},
	{
		"but_mult_files_close",
		Ef_mf_close,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(mult_files_close_cb),
	},
	{ NULL }
}; /* ef_mf_widgets[] */


static ef_t ef_md_widgets[] = {
	{
		"Multiple Directories",
		Ef_md_dialog,
		Ef_wgt_dialog
	},
	{
		"entry_mult_dirs",
		Ef_md_dirname,
		Ef_wgt_entry,
		GTK_SIGNAL_FUNC(entry_mult_dirs_cb),
	},
	{
		"but_mult_dirs_add",
		Ef_md_add,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(mult_dirs_add_cb),
	},
	{
		"clist_mult_dirs",
		Ef_md_list,
		Ef_wgt_clist,
	},
	{
		"tb_mult_dirs",
		Ef_md_toolbar,
		Ef_wgt_toolbar,
	},
	{
		"but_mult_dirs_up",
		Ef_md_up,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(mult_dirs_up_cb)
	},
	{
		"but_mult_dirs_down",
		Ef_md_down,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(mult_dirs_down_cb)
	},
	{
		"but_mult_dirs_del",
		Ef_md_del,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(mult_dirs_del_cb),
	},
	{
		"but_mult_dirs_clear",
		Ef_md_clear,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(mult_dirs_clear_cb),
	},
	{
		"but_mult_dirs_close",
		Ef_md_close,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(mult_dirs_close_cb),
	},
	{ NULL }
}; /* ef_md_widgets[] */


/*** PUBLIC FUNCTION DEFINITIONS ***/
gboolean
is_multi_file_search(win_t *w)
{
	return is_multi_common(w->filewgts, Ef_mf_list);
} /* is_multi_file_search */


gboolean
is_multi_dir_search(win_t *w)
{
	return is_multi_common(w->dirwgts, Ef_md_list);
} /* is_multi_dir_search */


int
multi_dir_add(win_t *w, GSList *argvl)
{
	return list_items_add(w, Ef_md_list, argvl, TRUE);
} /* multi_dir_add */


int
multi_file_add(win_t *w, GSList *argvl)
{
	return list_items_add(w, Ef_mf_list, argvl, FALSE);
} /* multi_file_add */


void
mult_files_cb(GtkWidget *wgt, gpointer cbdata)
{
	mult_dialog_create(cbdata, FALSE);
} /* mult_files_cb */


void
mult_dirs_cb(GtkWidget *wgt, gpointer cbdata)
{
	mult_dialog_create(cbdata, TRUE);
} /* mult_dirs_cb */


void
mult_files_clear_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	mult_clear_common(w, w->filewgts, Ef_mf_list, FALSE);
} /* mult_files_clear_cb */


void
mult_dirs_clear_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	mult_clear_common(w, w->dirwgts, Ef_md_list, TRUE);
} /* mult_dirs_clear_cb */


void
mult_prefs_toolbar_set(win_t *w)
{
	if (w->filewgts) {
		prefs_toolbar_set(Prefs_mfile_tbstyle,
				  w->filewgts[Ef_mf_toolbar]);
	}

	if (w->dirwgts) {
		prefs_toolbar_set(Prefs_mdir_tbstyle,
				  w->dirwgts[Ef_md_toolbar]);
	}
} /* mult_prefs_toolbar_set */


/*
 * Saves width & height of the dialogs.  Called only when closing the main
 * toplevel window.
 */
void
mult_prefs_save(win_t *w)
{
	mult_dim_save_common(w->filewgts, Ef_mf_dialog,
			     Prefs_mfile_win_w, Prefs_mfile_win_h);
	mult_dim_save_common(w->dirwgts, Ef_md_dialog,
			     Prefs_mdir_win_w, Prefs_mdir_win_h);
} /* mult_prefs_save */


/*** PRIVATE FUNCTION DEFINITIONS ***/
/*
 * Common routine for adding list item entries to the "find" command.  Called
 * from multi_dir_add() and multi_file_add().
 */
static int
list_items_add(win_t *w, int list_id, GSList *argvl, gboolean is_dir)
{
	GtkWidget *list;
	GtkCList *clist;
	char *name;
	int rownum, argc = 0;

	if ((is_dir && is_multi_dir_search(w)) || is_multi_file_search(w)) {
		list = (is_dir) ? w->dirwgts[list_id] : w->filewgts[list_id];
		g_assert(GTK_IS_CLIST(list));
		clist = GTK_CLIST(list);
		if (!is_dir) {
			argvl = g_slist_append(argvl, g_strdup("("));
			argc++;
		}

		for (rownum = 0; rownum < clist->rows; rownum++) {
			(void)gtk_clist_get_text(clist, rownum, 0, &name);
			g_assert(name);

			if (is_dir) {
				argvl = g_slist_append(argvl,
						      my_dir_expand_home(name));
				argc++;
			} else {
				argc += search_fname_add(w, argvl, name);
				if (rownum < clist->rows - 1) {
					argvl = g_slist_append(argvl,
							       g_strdup("-o"));
					argc++;
				}
			}
		}

		if (!is_dir) {
			argvl = g_slist_append(argvl, g_strdup(")"));
			argc++;
		}
	}

	return argc;
} /* list_items_add */


static gboolean
is_multi_common(GtkWidget **wgts, int list_id)
{
	GtkCList *clist;

	if (!wgts)
		return FALSE;

	g_assert(GTK_IS_CLIST(wgts[list_id]));
	clist = GTK_CLIST(wgts[list_id]);
	return (clist->rows) ? TRUE : FALSE;
} /* is_multi_common */


static int
list_menu_popup_cb(GtkWidget *wgt, GdkEventButton *event, gpointer cbdata)
{
	return FALSE;
} /* list_menu_popup_cb */


static GtkWidget **
mult_dialog_create_common(win_t *w, GtkWidget **wgts, int num,
			  ef_t ef_wgts[], char *name, int top_id, int max_id,
			  int list_id)
{
	wgts = my_widgets_setup(w, wgts, num, ef_wgts, name, top_id, max_id,
				FALSE);
	gtk_signal_connect(GTK_OBJECT(wgts[list_id]),
			   "button_press_event",
			   GTK_SIGNAL_FUNC(list_menu_popup_cb), w);
	gtk_signal_connect(GTK_OBJECT(wgts[top_id]), "key_press_event",
			   GTK_SIGNAL_FUNC(mult_dialog_key_press),
			   wgts[top_id]);
	gtk_signal_connect(GTK_OBJECT(wgts[top_id]), "delete_event",
			   GTK_SIGNAL_FUNC(gtk_true), NULL);
	return wgts;
} /* mult_dialog_create_common */


static void
mult_dialog_create(win_t *w, gboolean is_dir)
{
	int num;

	g_assert(w);

	if (is_dir) {
		num = (sizeof(ef_md_widgets) / sizeof(ef_md_widgets[0])) - 1;
		w->dirwgts = mult_dialog_create_common(w, w->dirwgts, num,
						       ef_md_widgets,
						       "Multiple Directories",
						       Ef_md_dialog,
						       Ef_md_MAX,
						       Ef_md_list);
		mult_prefs_toolbar_set(w);
		my_prefs_window_set_size(w->dirwgts[Ef_md_dialog],
					 Prefs_save_mdir_win,
					 Prefs_mdir_win_w,
					 Prefs_mdir_win_h);
		gtk_widget_show(w->dirwgts[Ef_md_dialog]);
	} else {
		num = (sizeof(ef_mf_widgets) / sizeof(ef_mf_widgets[0])) - 1;
		w->filewgts = mult_dialog_create_common(w, w->filewgts, num,
						        ef_mf_widgets,
						        "Multiple Files",
						        Ef_mf_dialog,
						        Ef_mf_MAX,
						        Ef_mf_list);
		mult_prefs_toolbar_set(w);
		my_prefs_window_set_size(w->filewgts[Ef_mf_dialog],
					 Prefs_save_mfile_win,
					 Prefs_mfile_win_w,
					 Prefs_mfile_win_h);
		gtk_widget_show(w->filewgts[Ef_mf_dialog]);
	}
} /* mult_dialog_create */


static void
entry_mult_common_cb(win_t *w, GtkWidget **wgts, int entry_id, int add_id)
{
	char *txt;

	g_assert(GTK_IS_ENTRY(wgts[entry_id]));
	txt = gtk_entry_get_text(GTK_ENTRY(wgts[entry_id]));
	gtk_widget_set_sensitive(wgts[add_id], (txt && strlen(txt) > 0));
} /* entry_mult_cb */


static void
entry_mult_files_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	entry_mult_common_cb(w, w->filewgts, Ef_mf_filename, Ef_mf_add);
} /* entry_mult_files_cb */


static void
entry_mult_dirs_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	entry_mult_common_cb(w, w->dirwgts, Ef_md_dirname, Ef_md_add);
} /* entry_mult_dirs_cb */


static void
mult_clear_common(win_t *w, GtkWidget **wgts, int list_id, gboolean is_dir)
{
	if (!wgts)	/* can be NULL if only one out of the two */
		return; /* (multi-file or multi-dir) dialogs was used */
	gtk_clist_clear(GTK_CLIST(wgts[list_id]));
	win_fd_entry_setclear(w, TRUE, is_dir);
	win_fd_entry_sensitive(w, TRUE, is_dir);
} /* mult_clear_common */


static void
mult_files_close_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	gtk_widget_hide(w->filewgts[Ef_mf_dialog]);
} /* mult_files_close_cb */


static void
mult_add_common(win_t *w, GtkWidget **wgts, int entry_id, int list_id,
		gboolean is_dir)
{
	char *txt[2];

	g_assert(GTK_IS_ENTRY(wgts[entry_id]));
	txt[0] = gtk_entry_get_text(GTK_ENTRY(wgts[entry_id]));
	g_assert(txt[0]);
	g_assert(strlen(txt[0]) > 0);
	g_assert(GTK_IS_CLIST(wgts[list_id]));
	txt[1] = NULL;
	gtk_clist_append(GTK_CLIST(wgts[list_id]), txt);
	gtk_editable_delete_text(GTK_EDITABLE(wgts[entry_id]),
				 0, strlen(txt[0]));
	win_fd_entry_setclear(w, FALSE, is_dir);
	win_fd_entry_sensitive(w, FALSE, is_dir);
} /* mult_add_common */


static void
mult_files_add_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	mult_add_common(w, w->filewgts, Ef_mf_filename, Ef_mf_list, FALSE);
} /* mult_files_add_cb */


static void
mult_dirs_close_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	gtk_widget_hide(w->dirwgts[Ef_md_dialog]);
} /* mult_dirs_close_cb */


static void
mult_dirs_add_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	mult_add_common(w, w->dirwgts, Ef_md_dirname, Ef_md_list, TRUE);
} /* mult_dirs_add_cb */


static void
mult_dim_save_common(GtkWidget **wgts, int top_id,
		     int prefs_id_w, int prefs_id_h)
{
	int width, height;

	if (!wgts)
		return;

	gdk_window_get_size(wgts[top_id]->window, &width, &height);
	prefs_int_set(prefs_id_w, width);
	prefs_int_set(prefs_id_h, height);
} /* mult_dim_save_common */


static gboolean
mult_dialog_key_press(GtkWidget *wgt, GdkEventKey *ev, GtkWidget *toplev)
{
	if (ev->keyval == GDK_Escape) {
		gtk_widget_hide(toplev);
		return TRUE;
	}

	return FALSE;
} /* mult_dialog_key_press */


static void
mult_files_del_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	my_clist_del(w->filewgts, Ef_mf_list);
} /* mult_files_del_cb */


static void
mult_dirs_del_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	my_clist_del(w->dirwgts, Ef_md_list);
} /* mult_dirs_del_cb */


static void
mult_files_up_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	my_clist_up(w->filewgts, Ef_mf_list);
} /* mult_files_up_cb */


static void
mult_dirs_up_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	my_clist_up(w->dirwgts, Ef_md_list);
} /* mult_dirs_up_cb */


static void
mult_files_down_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	my_clist_down(w->filewgts, Ef_mf_list);
} /* mult_files_down_cb */


static void
mult_dirs_down_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	my_clist_down(w->dirwgts, Ef_md_list);
} /* mult_dirs_down_cb */


/* the end */
