dnl ac_lib_upnp.m4 - Check for libupnp availability
dnl
dnl Copyright (C) 2005, 2006 Oskar Liljeblad
dnl
dnl   This program is free software; you can redistribute it and/or modify
dnl   it under the terms of the GNU General Public License as published by
dnl   the Free Software Foundation; either version 2 of the License, or
dnl   (at your option) any later version.
dnl
dnl   This program is distributed in the hope that it will be useful,
dnl   but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl   GNU Library General Public License for more details.
dnl
dnl   You should have received a copy of the GNU General Public License along
dnl   with this program; if not, write to the Free Software Foundation,
dnl   Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
dnl
dnl @synopsis AC_LIB_UPNP([ACTION-IF-TRUE], [ACTION-IF-FALSE])
dnl
dnl This macro will check for the existence of libupnp
dnl (http://upnp.sourceforge.net/). It does this by checking for the
dnl header file upnp.h and the upnp library object file. A --with-libupnp
dnl option is supported as well. The following output variables are set
dnl with AC_SUBST:
dnl
dnl   UPNP_CFLAGS
dnl   UPNP_LIBS
dnl
dnl You can use them like this in Makefile.am:
dnl
dnl   AM_CFLAGS = $(UPNP_CFLAGS)
dnl   program_LDADD = $(UPNP_LIBS)
dnl
dnl Additionally, the C preprocessor symbol HAVE_LIBUPNP will be defined
dnl with AC_DEFINE if libupnp is available.
dnl
dnl On FreeBSD libupnp need to be linked with pthreads as well. The
dnl environment variables PTHREAD_CFLAGS and PTHREAD_LIBS are consulted
dnl for this purpose. The reason for not using UPNP_CPPFLAGS and
dnl UPNP_LDFLAGS is because of these FreeBSD environment variables.
dnl
dnl @category InstalledPackages
dnl @author Oskar Liljeblad <oskar@osk.mine.nu>
dnl @version 1.2
dnl @license GPL

AC_DEFUN([AC_LIB_UPNP], [
  AH_TEMPLATE([HAVE_LIBUPNP], [Define if libupnp is available])
  AC_ARG_WITH(libupnp, [  --with-libupnp=DIR      prefix for upnp library files and headers], [
    if test "$withval" = "no"; then
      ac_upnp_path=
      $2
    elif test "$withval" = "yes"; then
      ac_upnp_path="/usr/local /usr"
    else
      ac_upnp_path="$withval"
    fi
  ],[ac_upnp_path="/usr/local /usr"])
  if test "$ac_upnp_path" != ""; then
    foundupnp=
    for prefixupnp in $ac_upnp_path; do
      saved_CPPFLAGS="$CPPFLAGS"
      CPPFLAGS="$CPPFLAGS -I$prefixupnp/include"
      saved_CFLAGS="$CFLAGS"
      CFLAGS="$CFLAGS $PTHREAD_CFLAGS"
      AC_CHECK_HEADER([upnp/upnp.h], [
        saved_LIBS="$LIBS"
        LIBS="$LIBS $PTHREAD_LIBS -L$prefixupnp/lib"
        AC_CHECK_LIB(upnp, UpnpInit, [
          AC_SUBST(UPNP_CFLAGS, ["$PTHREAD_CFLAGS -I$prefixupnp/include"])
          AC_SUBST(UPNP_LIBS, ["$PTHREAD_LIBS -L$prefixupnp/lib -lupnp"])
	  AC_DEFINE([HAVE_LIBUPNP])
	  foundupnp=1
          $1
        ])
        LIBS="$saved_LIBS"
      ])
      CPPFLAGS="$saved_CPPFLAGS"
      CFLAGS="$saved_CFLAGS"
      if test "$foundupnp" != ""; then
        break
      fi
      # Inspired by http://lists.gnu.org/archive/html/autoconf/2003-08/msg00087.html
      unset ac_cv_header_upnp_h
      unset ac_cv_lib_upnp_UpnpInit
    done
    if test "$foundupnp" = ""; then
      $2
      :
    fi
  fi
])
