#include "includes.h"

extern GladeXML *guixml, *configxml, *plxml, *addxml, *streamxml;

void gui_create_tooltips() {
  GtkTooltips *controls = GTK_TOOLBAR(glade_xml_get_widget(guixml, "toolbar_controls"))->tooltips;
  GtkTooltips *playlist = GTK_TOOLBAR(glade_xml_get_widget(guixml, "toolbar_playlist_controls"))->tooltips;
  GtkToolItem *i = NULL;

  i = GTK_TOOL_ITEM(glade_xml_get_widget(guixml, "button_prev"));
  gtk_tool_item_set_tooltip(i, controls, _("Previous (z)"), "");

  i = GTK_TOOL_ITEM(glade_xml_get_widget(guixml, "button_play"));
  gtk_tool_item_set_tooltip(i, controls, _("Play (x)"), "");

  i = GTK_TOOL_ITEM(glade_xml_get_widget(guixml, "button_pause"));
  gtk_tool_item_set_tooltip(i, controls, _("Pause (c)"), "");

  i = GTK_TOOL_ITEM(glade_xml_get_widget(guixml, "button_stop"));
  gtk_tool_item_set_tooltip(i, controls, _("Stop (v)"), "");

  i = GTK_TOOL_ITEM(glade_xml_get_widget(guixml, "button_next"));
  gtk_tool_item_set_tooltip(i, controls, _("Next (b)"), "");


  i = GTK_TOOL_ITEM(glade_xml_get_widget(guixml, "button_config"));
  gtk_tool_item_set_tooltip(i, controls, _("Config"), "");

  i = GTK_TOOL_ITEM(glade_xml_get_widget(guixml, "togglebutton_playlist"));
  gtk_tool_item_set_tooltip(i, controls, _("Show playlist (p)"), "");

  i = GTK_TOOL_ITEM(glade_xml_get_widget(guixml, "togglebutton_repeat"));
  gtk_tool_item_set_tooltip(i, controls, _("Repeat (e)"), "");

  i = GTK_TOOL_ITEM(glade_xml_get_widget(guixml, "togglebutton_random"));
  gtk_tool_item_set_tooltip(i, controls, _("Random (a)"), "");

  i = GTK_TOOL_ITEM(glade_xml_get_widget(guixml, "button_server_disconnect"));
  gtk_tool_item_set_tooltip(i, controls, _("Connect"), "");

  i = GTK_TOOL_ITEM(glade_xml_get_widget(guixml, "button_server_connect"));
  gtk_tool_item_set_tooltip(i, controls, _("Disonnect"), "");


  i = GTK_TOOL_ITEM(glade_xml_get_widget(guixml, "toggletoolbutton_pl_add"));
  gtk_tool_item_set_tooltip(i, playlist, _("Add to playlist"), "");
  
  i = GTK_TOOL_ITEM(glade_xml_get_widget(guixml, "toggletoolbutton_pl_remove"));
  gtk_tool_item_set_tooltip(i, playlist, _("Remove from playlist"), "");

  i = GTK_TOOL_ITEM(glade_xml_get_widget(guixml, "button_pl_file"));
  gtk_tool_item_set_tooltip(i, playlist, _("Playlists"), "");
  
  i = GTK_TOOL_ITEM(glade_xml_get_widget(guixml, "button_pl_shuffle"));
  gtk_tool_item_set_tooltip(i, playlist, _("Shuffle playlist"), "");
}
