{
    $Id: syscall.inc,v 1.16 2004/05/28 21:43:25 marco Exp $
    This file is part of the Free Pascal run time library.
    Copyright (c) 1999-2000 by Michael Van Canneyt,
    member of the Free Pascal development team.

    The syscalls for the new RTL, moved to platform dependant dir.
    Old linux calling convention is stil kept.

    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}


{$ASMMODE ATT}

function FpSysCall(sysnr:TSysParam):TSysResult; assembler; {$ifndef VER1_0} oldfpccall; {$endif}[public,alias:'FPC_SYSCALL0'];

asm
{ load the registers... }
  movl  sysnr,%eax
  int   $0x80
  testl %eax,%eax
  jns   .LSyscOK
  negl  %eax
{$ifdef VER1_0}
  movl  %eax,Errno
{$else}
{$ifdef REGCALL}
  movl  fpc_threadvar_relocate_proc,%ecx
  testl %ecx,%ecx
  jne   .LThread
  movl  %eax,Errno+4
  jmp   .LNoThread
.LThread:
  movl  %eax,%ebx
  movl Errno,%eax
  call  *%ecx
  movl  %ebx,(%eax)
.LNoThread:
{$else}
  movl  %eax,%edx
  movl  fpc_threadvar_relocate_proc,%eax
  testl %eax,%eax
  jne   .LThread
  movl  %edx,Errno+4
  jmp   .LNoThread
.LThread:
  pushl %edx
  pushl Errno
  call  *%eax
  popl  %edx
  movl  %edx,(%eax)
.LNoThread:
{$endif REGCALL}
{$endif ver1_0}
  movl  $-1,%eax
.LSyscOK:
end;

function FpSysCall(sysnr,param1 : TSysParam):TSysResult; assembler; {$ifndef VER1_0} oldfpccall; {$endif}[public,alias:'FPC_SYSCALL1'];

asm
{ load the registers... }
  movl sysnr,%eax
  movl param1,%ebx
  int $0x80
  cmpl  $-4095,%eax
  jb   .LSyscOK
  negl  %eax
{$ifdef VER1_0}
  movl  %eax,Errno
{$else}
{$ifdef REGCALL}
  movl  fpc_threadvar_relocate_proc,%ecx
  testl %ecx,%ecx
  jne   .LThread
  movl  %eax,Errno+4
  jmp   .LNoThread
.LThread:
  movl  %eax,%ebx
  movl Errno,%eax
  call  *%ecx
  movl  %ebx,(%eax)
.LNoThread:
{$else}
  movl  %eax,%edx
  movl  fpc_threadvar_relocate_proc,%eax
  testl %eax,%eax
  jne   .LThread
  movl  %edx,Errno+4
  jmp   .LNoThread
.LThread:
  pushl %edx
  pushl Errno
  call  *%eax
  popl  %edx
  movl  %edx,(%eax)
.LNoThread:
{$endif REGCALL}
{$endif ver1_0}
  movl  $-1,%eax
.LSyscOK:
end;

function FpSysCall(sysnr,param1,param2 : TSysParam):TSysResult; assembler; {$ifndef VER1_0} oldfpccall; {$endif} [public,alias:'FPC_SYSCALL2'];

asm
{ load the registers... }
  movl sysnr,%eax
  movl param1,%ebx
  movl param2,%ecx
  int $0x80
  testl %eax,%eax
  jns   .LSyscOK
  negl  %eax
{$ifdef VER1_0}
  movl  %eax,Errno
{$else}
{$ifdef REGCALL}
  movl  fpc_threadvar_relocate_proc,%ecx
  testl %ecx,%ecx
  jne   .LThread
  movl  %eax,Errno+4
  jmp   .LNoThread
.LThread:
  movl  %eax,%ebx
  movl Errno,%eax
  call  *%ecx
  movl  %ebx,(%eax)
.LNoThread:
{$else}
  movl  %eax,%edx
  movl  fpc_threadvar_relocate_proc,%eax
  testl %eax,%eax
  jne   .LThread
  movl  %edx,Errno+4
  jmp   .LNoThread
.LThread:
  pushl %edx
  pushl Errno
  call  *%eax
  popl  %edx
  movl  %edx,(%eax)
.LNoThread:
{$endif REGCALL}
{$endif ver1_0}
  movl  $-1,%eax
.LSyscOK:
end;

function FpSysCall(sysnr,param1,param2,param3:TSysParam):TSysResult; assembler; {$ifndef VER1_0} oldfpccall; {$endif} [public,alias:'FPC_SYSCALL3'];

asm
{ load the registers... }
  movl sysnr,%eax
  movl param1,%ebx
  movl param2,%ecx
  movl param3,%edx
  int $0x80
  testl %eax,%eax
  jns   .LSyscOK
  negl  %eax
{$ifdef VER1_0}
  movl  %eax,Errno
{$else}
{$ifdef REGCALL}
  movl  fpc_threadvar_relocate_proc,%ecx
  testl %ecx,%ecx
  jne   .LThread
  movl  %eax,Errno+4
  jmp   .LNoThread
.LThread:
  movl  %eax,%ebx
  movl Errno,%eax
  call  *%ecx
  movl  %ebx,(%eax)
.LNoThread:
{$else}
  movl  %eax,%edx
  movl  fpc_threadvar_relocate_proc,%eax
  testl %eax,%eax
  jne   .LThread
  movl  %edx,Errno+4
  jmp   .LNoThread
.LThread:
  pushl %edx
  pushl Errno
  call  *%eax
  popl  %edx
  movl  %edx,(%eax)
.LNoThread:
{$endif REGCALL}
{$endif ver1_0}
  movl  $-1,%eax
.LSyscOK:
end;

function FpSysCall(sysnr,param1,param2,param3,param4:TSysParam):TSysResult; assembler; {$ifndef VER1_0} oldfpccall; {$endif} [public,alias:'FPC_SYSCALL4'];

asm
{ load the registers... }
  movl sysnr,%eax
  movl param1,%ebx
  movl param2,%ecx
  movl param3,%edx
  movl param4,%esi
  int $0x80
  testl %eax,%eax
  jns   .LSyscOK
  negl  %eax
{$ifdef VER1_0}
  movl  %eax,Errno
{$else}
{$ifdef REGCALL}
  movl  fpc_threadvar_relocate_proc,%ecx
  testl %ecx,%ecx
  jne   .LThread
  movl  %eax,Errno+4
  jmp   .LNoThread
.LThread:
  movl  %eax,%ebx
  movl Errno,%eax
  call  *%ecx
  movl  %ebx,(%eax)
.LNoThread:
{$else}
  movl  %eax,%edx
  movl  fpc_threadvar_relocate_proc,%eax
  testl %eax,%eax
  jne   .LThread
  movl  %edx,Errno+4
  jmp   .LNoThread
.LThread:
  pushl %edx
  pushl Errno
  call  *%eax
  popl  %edx
  movl  %edx,(%eax)
.LNoThread:
{$endif REGCALL}
{$endif ver1_0}
  movl  $-1,%eax
.LSyscOK:
end;

function FpSysCall(sysnr,param1,param2,param3,param4,param5 : TSysParam):TSysResult; assembler; {$ifndef VER1_0} oldfpccall; {$endif}[public,alias:'FPC_SYSCALL5'];

asm
{ load the registers... }
  movl sysnr,%eax
  movl param1,%ebx
  movl param2,%ecx
  movl param3,%edx
  movl param4,%esi
  movl param5,%edi
  int $0x80
  testl %eax,%eax
  jns   .LSyscOK
  negl  %eax
{$ifdef VER1_0}
  movl  %eax,Errno
{$else}
{$ifdef REGCALL}
  movl  fpc_threadvar_relocate_proc,%ecx
  testl %ecx,%ecx
  jne   .LThread
  movl  %eax,Errno+4
  jmp   .LNoThread
.LThread:
  movl  %eax,%ebx
  movl Errno,%eax
  call  *%ecx
  movl  %ebx,(%eax)
.LNoThread:
{$else}
  movl  %eax,%edx
  movl  fpc_threadvar_relocate_proc,%eax
  testl %eax,%eax
  jne   .LThread
  movl  %edx,Errno+4
  jmp   .LNoThread
.LThread:
  pushl %edx
  pushl Errno
  call  *%eax
  popl  %edx
  movl  %edx,(%eax)
.LNoThread:
{$endif REGCALL}
{$endif ver1_0}
  movl  $-1,%eax
.LSyscOK:
end;

{$ifdef notsupported}
{ Only 5 params are pushed, so it'll not work as expected (PFV) }
function FpSysCall(sysnr,param1,param2,param3,param4,param5,param6 : TSysParam):TSysResult; assembler; {$ifndef VER1_0} oldfpccall; {$endif}[public,alias:'FPC_SYSCALL6'];

asm
{ load the registers... }
  movl sysnr,%eax
  movl param1,%ebx
  movl param2,%ecx
  movl param3,%edx
  movl param4,%esi
  movl param5,%edi
  int $0x80
  testl %eax,%eax
  jns   .LSyscOK
  negl  %eax
{$ifdef VER1_0}
  movl  %eax,Errno
{$else}
{$ifdef REGCALL}
  movl  fpc_threadvar_relocate_proc,%ecx
  testl %ecx,%ecx
  jne   .LThread
  movl  %eax,Errno+4
  jmp   .LNoThread
.LThread:
  movl  %eax,%ebx
  movl Errno,%eax
  call  *%ecx
  movl  %ebx,(%eax)
.LNoThread:
{$else}
  movl  %eax,%edx
  movl  fpc_threadvar_relocate_proc,%eax
  testl %eax,%eax
  jne   .LThread
  movl  %edx,Errno+4
  jmp   .LNoThread
.LThread:
  pushl %edx
  pushl Errno
  call  *%eax
  popl  %edx
  movl  %edx,(%eax)
.LNoThread:
{$endif REGCALL}
{$endif ver1_0}
  movl  $-1,%eax
.LSyscOK:
end;
{$endif notsupported}

{No debugging for syslinux include !}
{$IFDEF SYS_LINUX}
  {$UNDEF SYSCALL_DEBUG}
{$ENDIF SYS_LINUX}


{
  $Log: syscall.inc,v $
  Revision 1.16  2004/05/28 21:43:25  marco
   * and now for others too

  Revision 1.15  2004/05/28 21:41:49  marco
   * added mov errno,%eax

  Revision 1.14  2004/03/10 21:41:53  jonas
    * fixed syscall return value checking

  Revision 1.13  2004/03/03 22:10:48  peter
    * fixed previous commit

  Revision 1.12  2004/03/03 22:03:10  peter
    * regcall fix for threadvar

  Revision 1.11  2004/02/06 23:06:16  florian
    - killed tsyscallregs

  Revision 1.10  2004/01/06 21:32:53  peter
    * use relocate_proc

  Revision 1.9  2003/09/14 20:15:01  marco
   * Unix reform stage two. Remove all calls from Unix that exist in Baseunix.

  Revision 1.7  2002/12/24 19:45:59  peter
    * only set errno when syscall fails

  Revision 1.6  2002/12/23 21:17:53  peter
    * MT fix

  Revision 1.5  2002/12/23 20:56:32  peter
    * Reset Errno to 0 if call is successfull
    * Fix broken 1.0.x Errno which does not have threadvar

  Revision 1.4  2002/12/18 20:41:33  peter
    * Threadvar support for Errno
    * Fixed syscall error return check
    * Uncommented Syscall with 6 parameters, only 5 were really set

  Revision 1.3  2002/12/18 16:46:37  marco
   * Some mods.

  Revision 1.2  2002/11/16 15:37:47  marco
   * TSysParam + result moved to -h

  Revision 1.1  2002/11/12 13:31:32  marco
   * New syscall.inc


}
 
