{
    $Id: mmx.pp,v 1.10 2002/11/29 00:06:24 florian Exp $
    This file is part of the Free Pascal run time library.
    Copyright (c) 1999-2000 by Florian Klaempfl
    member of the Free Pascal development team

    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}
{ This unit contains some helpful stuff to deal with the mmx extensions }
unit mmx;

  interface

    type
       tmmxshortint = array[0..7] of shortint;
       tmmxbyte = array[0..7] of byte;
       tmmxword = array[0..3] of word;
       tmmxinteger = array[0..3] of integer;
       tmmxlongint = array[0..1] of longint;
       tmmxcardinal = array[0..1] of cardinal;
       { for the AMD 3D }
       tmmxsingle = array[0..1] of single;

       pmmxshortint = ^tmmxshortint;
       pmmxbyte = ^tmmxbyte;
       pmmxword = ^tmmxword;
       pmmxinteger = ^tmmxinteger;
{$ifdef HASFIXED}
       pmmxfixed = ^tmmxfixed;
{$endif HASFIXED}
       pmmxlongint = ^tmmxlongint;
       pmmxcardinal = ^tmmxcardinal;
       { for the AMD 3D }
       pmmxsingle = ^tmmxsingle;

    const
       is_mmx_cpu : boolean = false;
       is_sse_cpu : boolean = false;
       is_sse2_cpu : boolean = false;
       is_amd_3d_cpu : boolean = false;
       is_amd_3d_dsp_cpu : boolean = false;
       is_amd_3d_mmx_cpu : boolean = false;

    { sets all floating point registers to empty
      (use this after mmx usage)
    }
    procedure emms;
    procedure femms;

  implementation

    uses
       cpu;

  {$ASMMODE ATT}

    { return base type of processor: 0 - is Unknown, 10 - is AMD (AuthenticAMD), }
    {                                20 - is Intel (GenuineIntel) }
    function getdevel:byte;

      var
         _ebx,_ecx,_edx : longint;
      begin
        getdevel:=0;
        if cpuid_support then
        begin
            asm
                movl $0,%eax
                cpuid
                movl %ebx,_ebx
                movl %ecx,_ecx
                movl %edx,_edx
            end;
            if ((_ebx=$68747541) and (_ecx=$444D4163) and (_edx=$69746E65)) then getdevel:=10;
            if ((_ebx=$756E6547) and (_ecx=$6C65746E) and (_edx=$49656E69)) then getdevel:=20;
        end
    end;


    { returns true, if the processor supports the mmx instructions }
    function mmx_support : boolean;

      var
         _edx : longint;

      begin
         if cpuid_support then
           begin
              asm
                 movl $1,%eax
                 cpuid
                 movl %edx,_edx
              end;
              mmx_support:=(_edx and $800000)<>0;
           end
         else
           { a cpu with without cpuid instruction supports never mmx }
           mmx_support:=false;
      end;

    function amd_3d_support : boolean;

      var
         _edx : longint;

      begin
         if cpuid_support then
           begin
              asm
                 movl $0x80000001,%eax
                 cpuid
                 movl %edx,_edx
              end;
              amd_3d_support:=(_edx and $80000000)<>0;
           end
         else
           { a cpu with without cpuid instruction supports never mmx }
           amd_3d_support:=false;
      end;

    function amd_3d_dsp_support : boolean;

      var
         _edx : longint;

      begin
         if cpuid_support then
           begin
              asm
                 movl $0x80000001,%eax
                 cpuid
                 movl %edx,_edx
              end;
              amd_3d_dsp_support:=(_edx and $40000000)<>0;
           end
         else
           { a cpu with without cpuid instruction supports never mmx }
           amd_3d_dsp_support:=false;
      end;

    function amd_3d_mmx_support : boolean;

      var
         _edx : longint;

      begin
         if cpuid_support then
           begin
              asm
                 movl $0x80000001,%eax
                 cpuid
                 movl %edx,_edx
              end;
              amd_3d_mmx_support:=(_edx and $400000)<>0;
           end
         else
           { a cpu with without cpuid instruction supports never mmx }
           amd_3d_mmx_support:=false;
      end;

    function sse_support : boolean;

      var
         _edx : longint;

      begin
         if cpuid_support then
           begin
              asm
                 movl $1,%eax
                 cpuid
                 movl %edx,_edx
              end;
              sse_support:=(_edx and $2000000)<>0;
           end
         else
           { a cpu with without cpuid instruction supports never sse }
           sse_support:=false;
      end;

    function sse2_support : boolean;

      var
         _edx : longint;

      begin
         if cpuid_support then
           begin
              asm
                 movl $1,%eax
                 cpuid
                 movl %edx,_edx
              end;
              sse2_support:=(_edx and $4000000)<>0;
           end
         else
           { a cpu with without cpuid instruction supports never sse2 }
           sse2_support:=false;
      end;

    procedure emms;assembler;

      asm
         emms
      end;

    procedure femms;assembler;

      asm
          .byte 0x0f, 0x0e
{         femms instruction not supported with older as versions }
      end;


   var
      oldexitproc : pointer;

   procedure mmxexitproc;

     begin
        exitproc:=oldexitproc;
        if is_amd_3d_cpu then femms else emms;
     end;

begin
   if mmx_support then
     begin
        is_mmx_cpu:=true;
        if amd_3d_support then
          begin
             is_amd_3d_cpu:=true;
             is_amd_3d_dsp_cpu:=amd_3d_dsp_support;
             is_amd_3d_mmx_cpu:=amd_3d_mmx_support;
          end;
        is_sse_cpu:=sse_support;
        is_sse2_cpu:=sse2_support;
        { the exit code sets the fpu stack to empty }
        oldexitproc:=exitproc;
        exitproc:=@mmxexitproc;
     end;
end.
{
  $Log: mmx.pp,v $
  Revision 1.10  2002/11/29 00:06:24  florian
    * AMD CPUs could have SSE as well

  Revision 1.9  2002/09/23 18:55:19  hajny
    * Opcode syntax corrected

  Revision 1.8  2002/09/23 18:25:55  hajny
    * femms replaced with opcode to allow older as

  Revision 1.7  2002/09/07 21:33:05  carl
    - removed unused defines

  Revision 1.6  2002/09/07 16:01:19  peter
    * old logs removed and tabs fixed

  Revision 1.5  2002/03/16 12:01:24  peter
    * femms added

  Revision 1.4  2002/03/16 11:51:50  peter
    * sse and 3dnow extensions from Michail added

}
