/*
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk.h"
#include "glue-gui-gtk-mouse.h"
#include "simsetup.h"
#include "glue.h"

#include "ps2_gen_mouse_4_gui_gtk.h"

#define COMP "ps2_gen_mouse_4"

struct cpssp {
	struct sig_integer *port_deltax;
	struct sig_integer *port_deltay;
	struct sig_integer *port_deltaz;
	struct sig_boolean *port_button1;
	struct sig_boolean *port_button2;
	struct sig_boolean *port_button3;
	struct sig_boolean *port_button4;
	struct sig_boolean *port_button5;

	GtkWidget *gui;
};

/*
 * Simulator Callbacks
 */

/*
 * GUI Callbacks
 */
static void
ps2_gen_mouse_4_gui_mouse_motion(GtkWidget *w, int val, void *_cpssp)
{
	unsigned int dir = val >> 16;
	int delta = (int16_t) val;
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	if (! simsetup.interactive) {
		return;
	}

	switch (dir) {
	case 0: sig_integer_set(cpssp->port_deltax, cpssp, delta); break;
	case 1: sig_integer_set(cpssp->port_deltay, cpssp, delta); break;
	case 2: sig_integer_set(cpssp->port_deltaz, cpssp, delta); break;
	default: assert(0); break;
	}
}

static void
ps2_gen_mouse_4_gui_mouse_button(GtkWidget *w, int val, void *_cpssp)
{
	unsigned int nr = val >> 16;
	int pressed = (int16_t) val;
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	if (! simsetup.interactive) {
		return;
	}

	switch (nr) {
	case 0: sig_boolean_set(cpssp->port_button1, cpssp, pressed); break;
	case 1: sig_boolean_set(cpssp->port_button2, cpssp, pressed); break;
	case 2: sig_boolean_set(cpssp->port_button3, cpssp, pressed); break;
	case 3: sig_boolean_set(cpssp->port_button4, cpssp, pressed); break;
	case 4: sig_boolean_set(cpssp->port_button5, cpssp, pressed); break;
	default: assert(0); break;
	}
}

void *
ps2_gen_mouse_4_gui_gtk_create(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_ps2_conn *port_ps2,
	struct sig_integer *port_deltax,
	struct sig_integer *port_deltay,
	struct sig_integer *port_deltaz,
	struct sig_boolean *port_button1,
	struct sig_boolean *port_button2,
	struct sig_boolean *port_button3,
	struct sig_boolean *port_button4,
	struct sig_boolean *port_button5
)
{
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->gui = gui_gtk_mouse_new();
	g_signal_connect(G_OBJECT(cpssp->gui), "mouse-motion",
			G_CALLBACK(ps2_gen_mouse_4_gui_mouse_motion), cpssp);
	g_signal_connect(G_OBJECT(cpssp->gui), "mouse-button",
			G_CALLBACK(ps2_gen_mouse_4_gui_mouse_button), cpssp);

	gtk_widget_show(cpssp->gui);
	gui_gtk_comp_add(page, COMP, name, cpssp->gui, FALSE, FALSE, NULL);

	cpssp->port_deltax = port_deltax;
	cpssp->port_deltay = port_deltay;
	cpssp->port_deltaz = port_deltaz;

	cpssp->port_button1 = port_button1;
	cpssp->port_button2 = port_button2;
	cpssp->port_button3 = port_button3;
	cpssp->port_button4 = port_button4;
	cpssp->port_button5 = port_button5;

	/* Out */
#if 0
	sig_integer_connect_out(port_deltax, cpssp, 0);
	sig_integer_connect_out(port_deltay, cpssp, 0);
	sig_integer_connect_out(port_deltaz, cpssp, 0);
#endif

	sig_boolean_connect_out(port_button1, cpssp, 0);
	sig_boolean_connect_out(port_button2, cpssp, 0);
	sig_boolean_connect_out(port_button3, cpssp, 0);
	sig_boolean_connect_out(port_button4, cpssp, 0);
	sig_boolean_connect_out(port_button5, cpssp, 0);

	return cpssp;
}

void
ps2_gen_mouse_4_gui_gtk_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
ps2_gen_mouse_4_gui_gtk_suspend(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;

	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
ps2_gen_mouse_4_gui_gtk_resume(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;

	GtkWidget *savegui = cpssp->gui;

	generic_resume(cpssp, sizeof(*cpssp), fComp);

	cpssp->gui = savegui;
	fprintf(stdout, "\t\t\ttoDo: Handle GtkWidget Mouse, refer to glue-gui-gtk-mouse\n", 0);
}
