/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __FRACFRAME_H
#define __FRACFRAME_H

//--- system includes ---
#include <string>
#include <vector>
#include <set>
#include <utility>
#include <map>

using std::string;
using std::vector;
using std::set;
using std::pair;
using std::map;

//--- project includes ---
#include "Foundation/vec3.h"

class FracFrame
{
 private:
  set<pair<int,int> > m_bonds;
  map<int,Vec3> posmap;
  map<int,float> radmap;

  // private helper functions
  int get_version(const string&);
  vector<string> get_filenames(const string&, int);

 public:
  // types
  struct fdata
  {
    Vec3 pos;
    Vec3 normal;
    double size;
    int id1, id2;
  };

  FracFrame();

  void readFile(const string&);
  void readFileRot(const string&,bool);
  void readFileTagged(const string&,int);
  void readFileRotTagged(const string&,int);
  vector<fdata> getFrac(FracFrame&);
};

#endif // __FRACFRAME_H
