/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////


#ifndef CHECKPOINTER_H
#define CHECKPOINTER_H

// --- MPI includes ---
#include <mpi.h>

//--- TML includes ---
#include "tml/comm/comm.h"

#include <string>
#include <iostream>


namespace esys
{
  namespace lsm
  {
    class CheckPointable;
  }
}

/**
 * Saves the state of a model.
*/
class CheckPointer
{
public:
  /**
  */
  CheckPointer(esys::lsm::CheckPointable &checkPointable, MPI_Comm mpiComm=MPI_COMM_WORLD);

  /**
  */
  virtual ~CheckPointer();

  /**
   * Saves the state of a model.
   */
  virtual void saveRestartable();
  virtual void saveDump();
  virtual void saveThroughMaster(TML_Comm&);
  virtual void loadCheckPoint();

  /**
   * Saves the state of a model to specified stream.
   */
  virtual void save(std::ostream &oStream);

  MPI_Comm getMpiComm() const;
  
  void setMpiComm(MPI_Comm mpiComm);

private:
  esys::lsm::CheckPointable *m_pCheckPointable;
  MPI_Comm m_mpiComm;
};

#endif
