C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C


      SUBROUTINE DECFP (FVAL,IEXP,IMANT)
C---->
C
C*
C*    NAME      : DECFP
C*
C*    FUNCTION  : DECODE GRIB CODE REPRESENTATION TO
C*                FLOATING POINT NUMBER.
C*
C*    INPUT     : IEXP  - 8 BIT SIGNED EXPONENT
C*                IMANT - 24 BIT MANTISSA
C*
C*    OUTPUT    : FVAL  - FLOATING POINT NUMBER
C*                IEXP  - UNCHANGED
C*                IMANT - UNCHANGED
C*
C*    JOHN HENNESSY , ECMWF , 15TH APRIL 1985
C*
C     ---------------------------------------------------------------
C----<
C
C
      IF (IEXP.EQ.128.AND.IMANT.EQ.0)
     C   THEN
             FVAL = 0.0
             RETURN
         ENDIF
C
C
C
C     SIGN OF VALUE
C
      JEXP  = IEXP
      ISIGN = 1
C
      IF (JEXP.GE.128)
     C     THEN
               JEXP  = JEXP - 128
               ISIGN = -1
           END IF
C
C     DECODE VALUE.
C
      FVAL = ISIGN*2.**(-24)*IMANT*16.**(JEXP-64)
C
C
      RETURN
      END
