(ert-deftest elpy-xref--apropos-should-give-an-xref-buffer ()
  (when (featurep 'xref)
    (elpy-testcase ((:project project-root "test.py"))
        (find-file (f-join project-root "test.py"))
        (python-mode)
        (elpy-mode)
        (insert "def foo(x, y):\n"
                "    return x + y\n"
                "var1 = foo(5, 2)")
        (let ((xref-items (elpy-xref--apropos "fo"))
            (basefile (f-join project-root "test.py")))

        (let* ((foo-defs (car xref-items))
                (summary (xref-item-summary foo-defs))
                (location (xref-item-location foo-defs))
                (pos (xref-elpy-location-pos location))
                (file (xref-elpy-location-file location)))
            (should (string-equal summary "1:	def foo(x, y):"))
            (should (string-equal file basefile))
            (should (equal pos 5)))
        (let* ((foo-defs (car (cdr xref-items)))
                (summary (xref-item-summary foo-defs))
                (location (xref-item-location foo-defs))
                (pos (xref-elpy-location-pos location))
                (file (xref-elpy-location-file location)))
        (should (string-equal summary "3:	var1 = foo(5, 2)"))
        (should (string-equal file basefile))
        (should (equal pos 40)))))))
