-- Copyright (C) 2000 Oliver Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--

indexing

   description:	"GNOME_HELP: Routines for displaying help"
   author:		"Oliver Elphick"
   cvs:		"$Id: gnome_help.e,v 1.3 2002/02/26 16:47:26 elphick Exp $"

class GNOME_HELP

   -- These routines provide simple wrappers for invoking the help 
   -- system in GNOME. They will take care of invoking the help 
   -- browser with the help file you provide.

feature

   -- In these routines, <application> is the name of the 
   -- application.  This should be the name of a directory under 
   -- /usr/share/gnome/help, containing the help files for the 
   -- application. 
   -- <path> is the name of the help file path relative to the help 
   -- directory identified by <application> in combination with the 
   -- current language setting.

   find_help_file (application, path: STRING): STRING is
	 -- Returns a fully resolved file name 
      require
	 app_ok: application /= Void and then not application.is_empty
	 path_ok: path /= Void and then not path.is_empty
      do
	 Result := gnpc.gnpc_help_file_find_file(application, path)
      ensure
	 not_void: Result /= Void
      end

   help_path (application, path: STRING): STRING is
	 -- Returns a fully resolved file name
	 -- [How does this differ from find_help_file? ORE]
      require
	 app_ok: application /= Void and then not application.is_empty
	 path_ok: path /= Void and then not path.is_empty
      do
	 Result := gnpc.gnpc_help_file_path(application, path)
      ensure
	 not_void: Result /= Void
      end

   display (application, path: STRING) is
	 -- Cause a help viewer to display the indicated help entry 
      require
	 app_ok: application /= Void and then not application.is_empty
	 path_ok: path /= Void and then not path.is_empty
      do
	 gnpc.gnpc_help_display(application, path)
      end

   goto (file: STRING) is
	 -- Cause a help viewer to display the file
      require
	 file_ok: file /= Void and then not file.is_empty
      do
	 gnpc.gnpc_help_goto (file)
      end

   pbox_display (page_num: INTEGER; application, path: STRING) is
	 -- Cause a help viewer to display the indicated help entry. 
	 -- This function is meant to be connected to the "help" 
	 -- signal of a GnomePropertyBox. <page_num> should contain 
	 -- the number of the current notebook page in the properties box.
      require
	 app_ok: application /= Void and then not application.is_empty
	 path_ok: path /= Void and then not path.is_empty
      do
	 gnpc.gnpc_help_pbox_display (page_num, application, path)
      end 

   pbox_goto (application, path: STRING) is
	 -- Cause a help viewer to display the indicated help entry.
	 -- This function is meant to be connected to the help button
	 -- of a GnomePropertyBox, when you don't want any munging of 
	 -- the help path done. Most of the time, you can use 
	 -- pbox_display.
      require
	 app_ok: application /= Void and then not application.is_empty
	 path_ok: path /= Void and then not path.is_empty
      do
	 gnpc.gnpc_help_pbox_goto (application, path)
      end 

feature {NONE}

   gnpc: GNOME_NON_PORTABLE_CALLS is
      once
	 !!Result
      end

end -- GNOME_HELP
