/* Dia -- a diagram creation/manipulation program
 * Copyright (C) 1998 Alexander Larsson
 *
 * sheets_dialog.c : a sheets and objects dialog
 * Copyright (C) 2002 M.C. Nelson
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */

/*
 * DO NOT EDIT THIS FILE - it is generated by Glade and then hand-coded
 *                         to make GNOME optional and add the underline
 *                         for accelerated buttons.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#ifdef HAVE_UNISTD_H
#  include <unistd.h>
#endif
#include <string.h>

#undef GTK_DISABLE_DEPRECATED /* GtkOptionMenu, ... */
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "sheets.h"
#include "sheets_dialog_callbacks.h"
#include "sheets_dialog.h"

#include "intl.h"
#include "persistence.h"

static void
sheets_dialog_destroyed (GtkWidget *widget, gpointer user_data)
{
  GObject *builder = g_object_get_data (G_OBJECT(widget), "_sheet_dialogs_builder");
  if (builder)
    g_object_unref (builder);
  g_object_set_data (G_OBJECT(widget), "_sheet_dialogs_builder", NULL);
}

/* FIXME: header? */
gchar *build_ui_filename (const gchar* name);

static GtkBuilder *
builder_new_from_file (const char *filename)
{
  GError *error = NULL;
  gchar *uifile;
  GtkBuilder *builder;

  builder = gtk_builder_new();
  uifile = build_ui_filename (filename);
  if (!gtk_builder_add_from_file (builder, uifile, &error)) {
    g_warning ("Couldn't load builder file: %s", error->message);
    g_error_free(error);
  }
  g_free (uifile);
  return builder;
}

GtkWidget*
create_sheets_main_dialog (void)
{
  GtkWidget *sheets_main_dialog;
  GtkWidget *optionmenu_left, *optionmenu_right;
  GtkWidget *optionmenu_left_menu, *optionmenu_right_menu;
  GtkWidget *glade_menuitem;
  GtkBuilder *builder;

  builder = builder_new_from_file ("ui/sheets-main-dialog.xml");
  sheets_main_dialog = GTK_WIDGET (gtk_builder_get_object (builder, "sheets_main_dialog"));
  g_object_set_data (G_OBJECT(sheets_main_dialog), "_sheet_dialogs_builder", builder);

  g_signal_connect (G_OBJECT (sheets_main_dialog), "destroy",
		    G_CALLBACK (sheets_dialog_destroyed), NULL);

  optionmenu_right = GTK_WIDGET (gtk_builder_get_object (builder, "optionmenu_right"));
  optionmenu_right_menu = gtk_menu_new ();
  gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu_right), optionmenu_right_menu);

  optionmenu_left = GTK_WIDGET (gtk_builder_get_object (builder, "optionmenu_left"));
  optionmenu_left_menu = gtk_menu_new ();
  glade_menuitem = gtk_menu_item_new_with_label ("");
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (optionmenu_left_menu), glade_menuitem);
  gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu_left), optionmenu_left_menu);

  g_signal_connect (gtk_builder_get_object (builder,"sheets_main_dialog"), "delete_event",
                      G_CALLBACK (on_sheets_main_dialog_delete_event),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder,"button_copy"), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_copy_clicked),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder,"button_copy_all"), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_copy_all_clicked),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder,"button_move"), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_move_clicked),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder,"button_move_all"), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_move_all_clicked),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder,"button_new"), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_new_clicked),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder,"button_move_up"), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_move_up_clicked),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder,"button_move_down"), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_move_down_clicked),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder,"button_edit"), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_edit_clicked),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder,"button_remove"), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_remove_clicked),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder,"button_apply"), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_apply_clicked),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder,"button_revert"), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_revert_clicked),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder,"button_close"), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_close_clicked),
                      NULL);

  persistence_register_window(GTK_WINDOW(sheets_main_dialog));

  return sheets_main_dialog;
}

GtkWidget*
create_sheets_new_dialog (void)
{
  GtkWidget *sheets_new_dialog;
  GtkBuilder *builder;

  builder = builder_new_from_file ("ui/sheets-new-dialog.xml");
  sheets_new_dialog = GTK_WIDGET (gtk_builder_get_object (builder, "sheets_new_dialog"));
  g_object_set_data (G_OBJECT(sheets_new_dialog), "_sheet_dialogs_builder", builder);

  g_signal_connect (G_OBJECT (sheets_new_dialog), "destroy",
		    G_CALLBACK (sheets_dialog_destroyed), NULL);

  g_signal_connect (gtk_builder_get_object (builder,"radiobutton_svg_shape"), "toggled",
                      G_CALLBACK (on_sheets_new_dialog_radiobutton_svg_shape_toggled),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder,"radiobutton_sheet"), "toggled",
                      G_CALLBACK (on_sheets_new_dialog_radiobutton_sheet_toggled),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder,"radiobutton_line_break"), "toggled",
                      G_CALLBACK (on_sheets_new_dialog_radiobutton_line_break_toggled),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder,"button_ok"), "clicked",
                      G_CALLBACK (on_sheets_new_dialog_button_ok_clicked),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder,"button_cancel"), "clicked",
                      G_CALLBACK (on_sheets_new_dialog_button_cancel_clicked),
                      NULL);

  return sheets_new_dialog;
}

GtkWidget*
create_sheets_edit_dialog (void)
{
  GtkWidget *sheets_edit_dialog;
  GtkBuilder *builder;

  builder = builder_new_from_file ("ui/sheets-edit-dialog.xml");
  sheets_edit_dialog = GTK_WIDGET (gtk_builder_get_object (builder,"sheets_edit_dialog"));
  g_object_set_data (G_OBJECT(sheets_edit_dialog), "_sheet_dialogs_builder", builder);

  g_signal_connect (G_OBJECT (sheets_edit_dialog), "destroy",
		    G_CALLBACK (sheets_dialog_destroyed), NULL);

  g_signal_connect (gtk_builder_get_object (builder, "entry_object_description"), "changed",
                      G_CALLBACK (on_sheets_edit_dialog_entry_object_description_changed),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder, "entry_sheet_description"), "changed",
                      G_CALLBACK (on_sheets_edit_dialog_entry_sheet_description_changed),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder, "entry_sheet_name"), "changed",
                      G_CALLBACK (on_sheets_edit_dialog_entry_sheet_name_changed),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder, "button_ok"), "clicked",
                      G_CALLBACK (on_sheets_edit_dialog_button_ok_clicked),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder, "button_cancel"), "clicked",
                      G_CALLBACK (on_sheets_edit_dialog_button_cancel_clicked),
                      NULL);

  return sheets_edit_dialog;
}

GtkWidget*
create_sheets_remove_dialog (void)
{
  GtkWidget *sheets_remove_dialog;
  GtkBuilder *builder;

  builder = builder_new_from_file ("ui/sheets-remove-dialog.xml");
  sheets_remove_dialog = GTK_WIDGET (gtk_builder_get_object (builder, "sheets_remove_dialog"));
  g_object_set_data (G_OBJECT(sheets_remove_dialog), "_sheet_dialogs_builder", builder);

  g_signal_connect (G_OBJECT (sheets_remove_dialog), "destroy",
		    G_CALLBACK (sheets_dialog_destroyed), NULL);
  g_signal_connect (gtk_builder_get_object (builder,"radiobutton_object"), "toggled",
                      G_CALLBACK (on_sheets_remove_dialog_radiobutton_object_toggled),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder, "radiobutton_sheet"), "toggled",
                      G_CALLBACK (on_sheets_remove_dialog_radiobutton_sheet_toggled),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder, "button_ok"), "clicked",
                      G_CALLBACK (on_sheets_remove_dialog_button_ok_clicked),
                      NULL);
  g_signal_connect (gtk_builder_get_object (builder, "button_cancel"), "clicked",
                      G_CALLBACK (on_sheets_remove_dialog_button_cancel_clicked),
                      NULL);
  /* FIXME:
  gtk_widget_grab_default (button_ok);
  */
  return sheets_remove_dialog;
}

GtkWidget*
create_sheets_shapeselection_dialog (void)
{
  GtkWidget *sheets_shapeselection_dialog;
  GtkWidget *ok_button;
  GtkWidget *cancel_button1;

  sheets_shapeselection_dialog = gtk_file_selection_new (_("Select SVG Shape File"));
  gtk_object_set_data (GTK_OBJECT (sheets_shapeselection_dialog), "sheets_shapeselection_dialog", sheets_shapeselection_dialog);
  gtk_container_set_border_width (GTK_CONTAINER (sheets_shapeselection_dialog), 10);

  ok_button = GTK_FILE_SELECTION (sheets_shapeselection_dialog)->ok_button;
  gtk_object_set_data (GTK_OBJECT (sheets_shapeselection_dialog), "ok_button", ok_button);
  gtk_widget_show (ok_button);
#if GTK_CHECK_VERSION(2,18,0)
  gtk_widget_set_can_default (GTK_WIDGET (ok_button), TRUE);
#else
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
#endif

  cancel_button1 = GTK_FILE_SELECTION (sheets_shapeselection_dialog)->cancel_button;
  gtk_object_set_data (GTK_OBJECT (sheets_shapeselection_dialog), "cancel_button1", cancel_button1);
  gtk_widget_show (cancel_button1);
#if GTK_CHECK_VERSION(2,18,0)
  gtk_widget_set_can_default (GTK_WIDGET (cancel_button1), TRUE);
#else
  GTK_WIDGET_SET_FLAGS (cancel_button1, GTK_CAN_DEFAULT);
#endif

  g_signal_connect (G_OBJECT (ok_button), "clicked",
                    G_CALLBACK (on_sheets_shapeselection_dialog_button_ok_clicked),
                    NULL);
  g_signal_connect (G_OBJECT (cancel_button1), "clicked",
                    G_CALLBACK (on_sheets_shapeselection_dialog_button_cancel_clicked),
                    NULL);

  return sheets_shapeselection_dialog;
}

