#ifndef __DO_CONNECT_H__
#define __DO_CONNECT_H__

/********************/
/* start a new DCTC */
/***********************************************************************************************/
/* if no_wait is set, the -l flag is not added and DCTC starts without waiting a UI connection */
/***********************************************************************************************/
void start_a_new_dctc(char *hub_address, int no_wait);

/**************************************/
/* connect to an already running DCTC */
/**************************************/
void connect_to_a_running_dctc(char *dctc_entry);

/***********************************/
/* add a new var to the vars array */
/***********************************/
void add_var(char *var_name, char *var_value);

/***********************************/
/* get a value from the vars array */
/***********************************/
const char *get_var(char* var_name);

/**************************************/
/* get the size of the file dir/fname */
/**********************************************/
/* output: file size. On error, 0 is returned */
/**********************************************/
unsigned long get_file_size(const char *dir, char *fname);

/******************************************************************************************/
/* update the line i of the clist (clst) with the name 't' in the dir (cur_dir="dl_path") */
/******************************************************************************************/
void update_dl_clist_size(GtkCList *clst, int i, char *t, const char *cur_dir);

typedef struct
{
	time_t start_time;			/* start time of the download */
	unsigned long start_pos;	/* start position */
} DL_XTRA;

/*******************************************************/
/* name of the last used socket (dctc-xxxxxxxx-yyyyyy) */
/*******************************************************/
extern char last_known_running_dctc_name[512];

/*************************************************************************/
/* send the redirection message to force the client to go to another hub */
/*************************************************************************/
void go_to_another_hub(char *hubname);

#endif
