

	#ifndef	REGS_68HC908MR32

REGS_68HC908MR32 	.EQU 	1

PTA 	.EQU	$00
PTB 	.EQU 	$01
PTC 	.EQU 	$02
PTD 	.EQU	$03

DDRA 	.EQU	$04
DDRB 	.EQU	$05
DDRC 	.EQU	$06
DDRD 	.EQU	$07

PTE 	.EQU	$08
PTF	.EQU	$09

DDRE 	.EQU	$0C
DDRF	.EQU	$0D

TASC	.EQU	$0E
TACNTH	.EQU	$0F
TACNTL	.EQU	$10
TAMODH	.EQU	$11
TAMODL	.EQU	$12
TASC0	.EQU	$13
TACH0H	.EQU	$14
TACH0L	.EQU	$15
TASC1	.EQU	$16
TACH1H	.EQU	$17
TACH1L	.EQU	$18
TASC2	.EQU	$19
TACH2H	.EQU	$1A
TACH2L	.EQU	$1B
TASC3	.EQU	$1C
TACH3H	.EQU	$1D
TACH3L	.EQU	$1E

CONFIG	.EQU	$1F

PCTL1	.EQU	$20
PCTL2	.EQU	$21
FCR	.EQU	$22
FSR	.EQU	$23
FTACK	.EQU	$24
PWMOUT	.EQU	$25

PCNTH	.EQU	$26
PCNTL	.EQU	$27
PMODH	.EQU	$28
PMODL	.EQU	$29
PVAL1H	.EQU	$2A
PVAL1L	.EQU	$2B
PVAL2H	.EQU	$2C
PVAL2L	.EQU	$2D
PVAL3H	.EQU	$2E
PVAL3L	.EQU	$2F
PVAL4H	.EQU	$30
PVAL4L	.EQU	$31
PVAL5H	.EQU	$32
PVAL5L	.EQU	$33
PVAL6H	.EQU	$34
PVAL6L	.EQU	$35
DEADTM	.EQU	$36
DISMAP	.EQU	$37

SCC1	.EQU	$38
SCC2	.EQU	$39
SCC3	.EQU	$3A
SCS1	.EQU	$3B
SCS2	.EQU	$3C
SCDR	.EQU	$3D
SCBR	.EQU	$3E

ISCR	.EQU	$3F

ADSCR	.EQU	$40
ADRH	.EQU	$41
ADRL	.EQU	$42
ADCLK	.EQU	$43

SPCR	.EQU	$44
SPSCR	.EQU	$45
SPDR	.EQU	$46

TBSC	.EQU	$51
TBCNTH	.EQU	$52
TBCNTL	.EQU	$53
TBMODH	.EQU	$54
TBMODL	.EQU	$55
TBSC0	.EQU	$56
TBCH0H	.EQU	$57
TBCH0L	.EQU	$58
TBSC1	.EQU	$59
TBCH1H	.EQU	$5A
TBCH1L	.EQU	$5B

PCTL	.EQU	$5C
PBWC	.EQU	$5D
PPG	.EQU	$5E


SBSR	.EQU	$FE00
SRSR	.EQU	$FE01
SBFCR	.EQU	$FE03
FLCR	.EQU	$FE08		; this is not $FE07 as stated on page 26, datasheet Rev.6.1
BRKH	.EQU	$FE0C
BRKL	.EQU	$FE0D
BRKSCR	.EQU	$FE0E
LVISCR	.EQU	$FE0F
FLBPR	.EQU	$FF7E
COPCTL	.EQU	$FFFF


_vect_SCItransmit	.EQU	$FFD2
_vect_SCIreceive	.EQU	$FFD4
_vect_SCIerror		.EQU	$FFD6
_vect_SPItransmit	.EQU	$FFD8
_vect_SPIreceive	.EQU	$FFDA
_vect_ADC		.EQU	$FFDC
_vect_TIMOVF		.EQU	$FFDE
_vect_TIM1		.EQU	$FFE0
_vect_TIM0		.EQU	$FFE2
_vect_TimAOvf		.EQU	$FFE4
_vect_TimACh3		.EQU	$FFE6
_vect_TimACh2		.EQU	$FFE8
_vect_TimACh1		.EQU	$FFEA
_vect_TimACh0		.EQU	$FFEC
_vect_PWMmc		.EQU	$FFEE
_vect_Fault4		.EQU	$FFF0
_vect_Fault3		.EQU	$FFF2
_vect_Fault2		.EQU	$FFF4
_vect_Fault1		.EQU	$FFF6
_vect_PLL		.EQU	$FFF8
_vect_IRQ		.EQU	$FFFA
_vect_SWI		.EQU	$FFFC
_vect_RESET		.EQU	$FFFE


	#include	"bits68hc908.asm"


#endif



