struct cpuinfo_mock_file filesystem[] = {
	{
		.path = "/proc/cpuinfo",
		.size = 1121,
		.content =
			"Processor\t: ARMv7 Processor rev 5 (v7l)\n"
			"processor\t: 0\n"
			"model name\t: ARMv7 Processor rev 5 (v7l)\n"
			"BogoMIPS\t: 2413.36\n"
			"Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 7\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xc07\n"
			"CPU revision\t: 5\n"
			"\n"
			"processor\t: 1\n"
			"model name\t: ARMv7 Processor rev 5 (v7l)\n"
			"BogoMIPS\t: 2419.91\n"
			"Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 7\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xc07\n"
			"CPU revision\t: 5\n"
			"\n"
			"processor\t: 2\n"
			"model name\t: ARMv7 Processor rev 5 (v7l)\n"
			"BogoMIPS\t: 2419.91\n"
			"Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 7\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xc07\n"
			"CPU revision\t: 5\n"
			"\n"
			"processor\t: 3\n"
			"model name\t: ARMv7 Processor rev 5 (v7l)\n"
			"BogoMIPS\t: 2419.91\n"
			"Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 7\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xc07\n"
			"CPU revision\t: 5\n"
			"\n"
			"Hardware\t: sc8830\n"
			"Revision\t: 0005\n"
			"Serial\t\t: 4200ff80dc185400\n",
	},
	{
		.path = "/system/build.prop",
		.size = 5018,
		.content =
			"\n"
			"# begin build properties\n"
			"# autogenerated by buildinfo.sh\n"
			"ro.build.id=LMY47V\n"
			"ro.build.display.id=LMY47V.J120HXXS0AQE1\n"
			"ro.build.version.incremental=J120HXXS0AQE1\n"
			"ro.build.version.sdk=22\n"
			"ro.build.version.codename=REL\n"
			"ro.build.version.all_codenames=REL\n"
			"ro.build.version.release=5.1.1\n"
			"ro.build.version.security_patch=2017-05-01\n"
			"ro.build.version.base_os=samsung/j1x3gxx/j1x3g:5.1.1/LMY47V/J120HXXU0AQC1:user/release-keys\n"
			"ro.build.date=Thu May 18 18:45:55 KST 2017\n"
			"ro.build.date.utc=1495100755\n"
			"ro.build.type=user\n"
			"ro.build.user=dpi\n"
			"ro.build.host=SWDG9710\n"
			"ro.build.tags=release-keys\n"
			"ro.build.flavor=j1x3gxx-user\n"
			"ro.product.model=SM-J120H\n"
			"ro.product.brand=samsung\n"
			"ro.product.name=j1x3gxx\n"
			"ro.product.device=j1x3g\n"
			"ro.product.board=SC7727SE\n"
			"# ro.product.cpu.abi and ro.product.cpu.abi2 are obsolete,\n"
			"# use ro.product.cpu.abilist instead.\n"
			"ro.product.cpu.abi=armeabi-v7a\n"
			"ro.product.cpu.abi2=armeabi\n"
			"ro.product.cpu.abilist=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist32=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist64=\n"
			"ro.product.manufacturer=samsung\n"
			"ro.product.locale.language=en\n"
			"ro.product.locale.region=GB\n"
			"ro.wifi.channels=\n"
			"ro.board.platform=sc8830\n"
			"# ro.build.product is obsolete; use ro.product.device\n"
			"ro.build.product=j1x3g\n"
			"# Do not try to parse description, fingerprint, or thumbprint\n"
			"ro.build.description=j1x3gxx-user 5.1.1 LMY47V J120HXXS0AQE1 release-keys\n"
			"ro.build.fingerprint=samsung/j1x3gxx/j1x3g:5.1.1/LMY47V/J120HXXS0AQE1:user/release-keys\n"
			"ro.build.characteristics=default\n"
			"# Samsung Specific Properties\n"
			"ro.build.PDA=J120HXXS0AQE1\n"
			"ro.build.hidden_ver=J120HXXS0AQE1\n"
			"ro.build.changelist=9606765\n"
			"ro.product_ship=true\n"
			"ro.chipname=SC7727SE\n"
			"ro.build.official.release=true\n"
			"# end build properties\n"
			"#\n"
			"# from device/samsung/j1x3g/system.prop\n"
			"#\n"
			"\n"
			"ro.sf.lcd_density=240\n"
			"ro.sf.lcd_width=54\n"
			"ro.sf.lcd_height=96\n"
			"ro.opengles.version=131072\n"
			"ro.product.hardware=J1X3G_V1.0.0\n"
			"\n"
			"debug.hwui.render_dirty_regions=false\n"
			"\n"
			"# Bluetooth OPP low speed for save power\n"
			"debug.bt.lowspeed=true\n"
			"\n"
			"persist.ttydev=ttyVUART0\n"
			"\n"
			"# delay for ConnectivityChange broadcast (ms)\n"
			"conn.connectivity_change_delay = 0\n"
			"\n"
			"ro.product.partitionpath=/dev/block/platform/sdio_emmc/by-name/\n"
			"\n"
			"# Default ecclist\n"
			"ro.ril.ecclist=112,911,#911,*911\n"
			"\n"
			"persist.modem.w.enable=1\n"
			"persist.modem.w.nvp=w\n"
			"ro.modem.w.dev=/proc/cpw/\n"
			"ro.modem.w.tty=/dev/stty_w\n"
			"ro.modem.w.eth=rmnet\n"
			"ro.modem.w.snd=1\n"
			"ro.modem.w.diag=/dev/slog_w\n"
			"ro.modem.w.log=/dev/slog_w\n"
			"ro.modem.w.loop=/dev/spipe_w0\n"
			"ro.modem.w.nv=/dev/spipe_w1\n"
			"ro.modem.w.assert=/dev/spipe_w2\n"
			"ro.modem.w.vbc=/dev/spipe_w6\n"
			"ro.modem.w.id=0\n"
			"ro.modem.w.fixnv_size=0x40000\n"
			"ro.modem.w.runnv_size=0x60000\n"
			"\n"
			"ro.modem.wcn.enable=1\n"
			"ro.modem.wcn.diag=/dev/slog_wcn\n"
			"ro.digital.fm.support=1\n"
			"\n"
			"persist.sys.engpc.disable=0\n"
			"\n"
			"ro.config.ksm.support=true\n"
			"\n"
			"#zram config\n"
			"ro.config.zram.support=true\n"
			"ro.board_ram_size=high\n"
			"\n"
			"# SPRD: add low cost low memory @{\n"
			"ro.config.low_ram=true\n"
			"# @}\n"
			"\n"
			"#if our product not support drm,set as false\n"
			"drm.service.enabled=true\n"
			"\n"
			"# hotspot development\n"
			"#ro.hotspot.enabled=1\n"
			"\n"
			"# SPRD: add support hwrotation\n"
			"ro.sf.hwrotation=0\n"
			"\n"
			"# System property for storage_preload\n"
			"persist.sys.storage_preload=1\n"
			"\n"
			"persist.ini.connectivity.prodnv=0\n"
			"\n"
			"ro.kernel.qemu=0\n"
			"\n"
			"#\n"
			"# ADDITIONAL_BUILD_PROPERTIES\n"
			"#\n"
			"ro.astcenc.astcsupport=0\n"
			"ro.mct.compressiontype=ETC1\n"
			"ro.sf.lcd_density=240\n"
			"dalvik.vm.heapstartsize=5m\n"
			"dalvik.vm.heapgrowthlimit=96m\n"
			"dalvik.vm.heapsize=128m\n"
			"dalvik.vm.heaptargetutilization=0.75\n"
			"dalvik.vm.heapminfree=1m\n"
			"dalvik.vm.heapmaxfree=4m\n"
			"ro.com.android.dateformat=MM-dd-yyyy\n"
			"ro.carrier=unknown\n"
			"security.ASKS.policy_version=000000\n"
			"drm.service.enabled=true\n"
			"persist.sys.sprd.modemreset=1\n"
			"ro.adb.secure=1\n"
			"persist.sys.sprd.wcnreset=1\n"
			"persist.sys.engpc.disable=0\n"
			"persist.service.agps.network=4g\n"
			"ro.storage.flash_type=2\n"
			"persist.storage.type=2\n"
			"sys.tempsd.enable=0\n"
			"sys.internal.emulated=1\n"
			"ro.storage.install2internal=0\n"
			"keyguard.no_require_sim=true\n"
			"ro.com.android.dataroaming=false\n"
			"persist.msms.phone_default=0\n"
			"persist.sys.modem.diag=,gser\n"
			"persist.sys.support.vt=false\n"
			"sys.usb.gser.count=4\n"
			"lmk.autocalc=false\n"
			"ro.msms.phone_count=2\n"
			"persist.msms.phone_count=2\n"
			"ro.modem.w.count=2\n"
			"persist.sprd.hperf=false\n"
			"ro.build.scafe=capuccino\n"
			"ro.build.scafe.size=short\n"
			"ro.build.scafe.cream=white\n"
			"ro.build.scafe.shot=single\n"
			"ro.sec.fle.encryption=true\n"
			"ro.error.receiver.default=com.samsung.receiver.error\n"
			"ro.frp.pst=/dev/block/persistent\n"
			"ro.config.dha_cached_max=8\n"
			"ro.config.dha_cached_min=4\n"
			"ro.config.dha_empty_max=30\n"
			"ro.config.dha_empty_min=6\n"
			"ro.config.dha_lmk_scale=1\n"
			"ro.config.mdha_ssr_enable=true\n"
			"ro.config.ringtone=Over_the_Horizon.ogg\n"
			"ro.config.notification_sound=Skyline.ogg\n"
			"ro.config.alarm_alert=Morning_Flower.ogg\n"
			"ro.config.media_sound=Media_preview_Touch_the_light.ogg\n"
			"ro.config.ringtone_2=Basic_Bell.ogg\n"
			"ro.config.notification_sound_2=S_Charming_Bell.ogg\n"
			"ro.setupwizard.mode=OPTIONAL\n"
			"ro.com.google.gmsversion=5.1_r7\n"
			"ro.com.google.clientidbase=android-samsung\n"
			"persist.sys.dalvik.vm.lib.2=libart.so\n"
			"dalvik.vm.isa.arm.features=div\n"
			"ro.build.selinux=1\n"
			"net.bt.name=Android\n"
			"dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			"ro.build.aapt.config.prefer=hdpi\n"
			"ro.build.version.sdl=2203\n"
			"\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 1,
		.content = "\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/all_time_in_state",
		.size = 108,
		.content =
			"freq\t\tcpu0\t\tcpu1\t\tcpu2\t\tcpu3\t\t\n"
			"768000\t\t0\t\t0\t\t0\t\t0\t\t\n"
			"1000000\t\t0\t\t0\t\t0\t\t0\t\t\n"
			"1200000\t\t2301\t\t2301\t\t2301\t\t2301\t\t\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 11,
		.content = "sc_cpuidle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 5,
		.content = "menu\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "768000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 6,
		.content = "50000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 25,
		.content = "interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 5,
		.content = "sprd\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "768000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 32,
		.content =
			"1200000 2395\n"
			"1000000 0\n"
			"768000 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 3,
		.content = "15\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "768000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 6,
		.content = "50000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 25,
		.content = "interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 5,
		.content = "sprd\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "768000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 32,
		.content =
			"1200000 2683\n"
			"1000000 0\n"
			"768000 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/physical_package_id",
		.size = 3,
		.content = "15\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "768000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_transition_latency",
		.size = 6,
		.content = "50000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_governors",
		.size = 25,
		.content = "interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_driver",
		.size = 5,
		.content = "sprd\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "768000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/time_in_state",
		.size = 32,
		.content =
			"1200000 2968\n"
			"1000000 0\n"
			"768000 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/total_trans",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_id",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/physical_package_id",
		.size = 3,
		.content = "15\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings_list",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "768000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_transition_latency",
		.size = 6,
		.content = "50000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_governors",
		.size = 25,
		.content = "interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_driver",
		.size = 5,
		.content = "sprd\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "768000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/time_in_state",
		.size = 32,
		.content =
			"1200000 3254\n"
			"1000000 6\n"
			"768000 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/total_trans",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_id",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/physical_package_id",
		.size = 3,
		.content = "15\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings",
		.size = 2,
		.content = "8\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings_list",
		.size = 2,
		.content = "3\n",
	},
	{ NULL },
};
#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "audioflinger.bootsnd",
		.value = "0",
	},
	{
		.key = "boot.sfbootcomplete",
		.value = "0",
	},
	{
		.key = "conn.connectivity_change_delay",
		.value = "0",
	},
	{
		.key = "dalvik.vm.dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.dex2oat-Xmx",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "96m",
	},
	{
		.key = "dalvik.vm.heapmaxfree",
		.value = "4m",
	},
	{
		.key = "dalvik.vm.heapminfree",
		.value = "1m",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "128m",
	},
	{
		.key = "dalvik.vm.heapstartsize",
		.value = "5m",
	},
	{
		.key = "dalvik.vm.heaptargetutilization",
		.value = "0.75",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xmx",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.isa.arm.features",
		.value = "div",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "debug.bt.lowspeed",
		.value = "true",
	},
	{
		.key = "debug.force_rtl",
		.value = "0",
	},
	{
		.key = "debug.hwui.render_dirty_regions",
		.value = "false",
	},
	{
		.key = "debug.sf.layerdump",
		.value = "0",
	},
	{
		.key = "dev.bootcomplete",
		.value = "1",
	},
	{
		.key = "dev.kies.sommode",
		.value = "TRUE",
	},
	{
		.key = "dev.kiessupport",
		.value = "TRUE",
	},
	{
		.key = "dev.knoxapp.running",
		.value = "false",
	},
	{
		.key = "dev.ssrm.app.type",
		.value = "false",
	},
	{
		.key = "dev.ssrm.appsync3p",
		.value = "false",
	},
	{
		.key = "dev.ssrm.init",
		.value = "1",
	},
	{
		.key = "dev.ssrm.live_thumbnail",
		.value = "1",
	},
	{
		.key = "dev.ssrm.mode",
		.value = "",
	},
	{
		.key = "dev.ssrm.pst",
		.value = "340",
	},
	{
		.key = "dev.ssrm.smart_switch",
		.value = "false",
	},
	{
		.key = "drm.service.enabled",
		.value = "true",
	},
	{
		.key = "gsm.current.phone-type",
		.value = "1,1",
	},
	{
		.key = "gsm.network.type",
		.value = "Unknown,Unknown",
	},
	{
		.key = "gsm.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.operator.iso-country",
		.value = "us",
	},
	{
		.key = "gsm.operator.ispsroaming",
		.value = "false,false",
	},
	{
		.key = "gsm.operator.isroaming",
		.value = "false,false",
	},
	{
		.key = "gsm.operator.numeric",
		.value = "310410",
	},
	{
		.key = "gsm.sim.operator.alpha",
		.value = ",",
	},
	{
		.key = "gsm.sim.operator.iso-country",
		.value = ",",
	},
	{
		.key = "gsm.sim.operator.numeric",
		.value = ",",
	},
	{
		.key = "gsm.sim.state",
		.value = "ABSENT,ABSENT",
	},
	{
		.key = "gsm.version.baseband",
		.value = "J120HXXU0APJ1",
	},
	{
		.key = "gsm.version.ril-impl",
		.value = "android reference-ril 1.0",
	},
	{
		.key = "init.svc.BCS-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.DR-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.SMD-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.at_distributor",
		.value = "running",
	},
	{
		.key = "init.svc.auditd",
		.value = "running",
	},
	{
		.key = "init.svc.batterysrv",
		.value = "running",
	},
	{
		.key = "init.svc.bootanim",
		.value = "stopped",
	},
	{
		.key = "init.svc.cmd_services",
		.value = "stopped",
	},
	{
		.key = "init.svc.cp_diskserver_w",
		.value = "running",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.download",
		.value = "running",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.drsd",
		.value = "running",
	},
	{
		.key = "init.svc.edmaudit",
		.value = "running",
	},
	{
		.key = "init.svc.engpcclientw",
		.value = "running",
	},
	{
		.key = "init.svc.gpsd",
		.value = "running",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.lmkd",
		.value = "running",
	},
	{
		.key = "init.svc.logd",
		.value = "running",
	},
	{
		.key = "init.svc.macloader",
		.value = "stopped",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.mobex-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.modem_control",
		.value = "running",
	},
	{
		.key = "init.svc.modemd",
		.value = "running",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.p2p_supplicant",
		.value = "running",
	},
	{
		.key = "init.svc.phoneserver_w",
		.value = "running",
	},
	{
		.key = "init.svc.powersnd",
		.value = "stopped",
	},
	{
		.key = "init.svc.prepare_param",
		.value = "stopped",
	},
	{
		.key = "init.svc.refnotify_w",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon2",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.scs",
		.value = "stopped",
	},
	{
		.key = "init.svc.sdcard",
		.value = "stopped",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.smd_symlink",
		.value = "stopped",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.swapon",
		.value = "stopped",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.wcnd",
		.value = "running",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "installd.sdcard_manipulate_done",
		.value = "1",
	},
	{
		.key = "keyguard.no_require_sim",
		.value = "true",
	},
	{
		.key = "lmk.autocalc",
		.value = "false",
	},
	{
		.key = "logd.auditd",
		.value = "false",
	},
	{
		.key = "marlin.hardware.version",
		.value = "AA",
	},
	{
		.key = "media.dump.path",
		.value = "/data/local/media/",
	},
	{
		.key = "media.dump.switch",
		.value = "0x0",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.qtaguid_enabled",
	},
	{
		.key = "net.hostname",
		.value = "android-4396cf647dece0e0",
	},
	{
		.key = "net.knoxscep.version",
		.value = "2.0.1",
	},
	{
		.key = "net.knoxsso.version",
		.value = "1.0.0",
	},
	{
		.key = "net.knoxvpn.version",
		.value = "2.2.2",
	},
	{
		.key = "net.qtaguid_enabled",
		.value = "1",
	},
	{
		.key = "net.tcp.default_init_rwnd",
		.value = "60",
	},
	{
		.key = "persist.audio.allsoundmute",
		.value = "0",
	},
	{
		.key = "persist.audio.cpufreq",
		.value = "350000",
	},
	{
		.key = "persist.audio.finemediavolume",
		.value = "0",
	},
	{
		.key = "persist.audio.globaleffect",
		.value = "1",
	},
	{
		.key = "persist.audio.headsetsysvolume",
		.value = "9",
	},
	{
		.key = "persist.audio.hphonesysvolume",
		.value = "9",
	},
	{
		.key = "persist.audio.mpseek",
		.value = "0",
	},
	{
		.key = "persist.audio.mysound",
		.value = "1",
	},
	{
		.key = "persist.audio.ringermode",
		.value = "2",
	},
	{
		.key = "persist.audio.soundalivefxsec",
		.value = "1",
	},
	{
		.key = "persist.audio.stereospeaker",
		.value = "0",
	},
	{
		.key = "persist.audio.sysvolume",
		.value = "9",
	},
	{
		.key = "persist.audio.uhqa",
		.value = "0",
	},
	{
		.key = "persist.ini.connectivity.prodnv",
		.value = "0",
	},
	{
		.key = "persist.modem.w.enable",
		.value = "1",
	},
	{
		.key = "persist.modem.w.nvp",
		.value = "w",
	},
	{
		.key = "persist.msms.phone_count",
		.value = "2",
	},
	{
		.key = "persist.msms.phone_default",
		.value = "0",
	},
	{
		.key = "persist.radio.gprsattachmode",
		.value = "1",
	},
	{
		.key = "persist.radio.initphone-type",
		.value = "1",
	},
	{
		.key = "persist.radio.multisim.config",
		.value = "dsds",
	},
	{
		.key = "persist.radio.networktype2",
		.value = "-1",
	},
	{
		.key = "persist.radio.networktype",
		.value = "-1",
	},
	{
		.key = "persist.radio.plmnname_1",
		.value = "",
	},
	{
		.key = "persist.radio.plmnname_2",
		.value = "",
	},
	{
		.key = "persist.security.ams.enforcing",
		.value = "1",
	},
	{
		.key = "persist.service.agps.network",
		.value = "4g",
	},
	{
		.key = "persist.service.bdroid.version",
		.value = "4.1",
	},
	{
		.key = "persist.sprd.hperf",
		.value = "false",
	},
	{
		.key = "persist.storage.type",
		.value = "2",
	},
	{
		.key = "persist.sys.clssprld1",
		.value = "710",
	},
	{
		.key = "persist.sys.clssprld2",
		.value = "495",
	},
	{
		.key = "persist.sys.cmdservice.enable",
		.value = "disable",
	},
	{
		.key = "persist.sys.country",
		.value = "GB",
	},
	{
		.key = "persist.sys.dalvik.vm.lib.2",
		.value = "libart.so",
	},
	{
		.key = "persist.sys.dataprefer.simid",
		.value = "0",
	},
	{
		.key = "persist.sys.drs.date",
		.value = "Thu May 18 18:45:55 KST 2017",
	},
	{
		.key = "persist.sys.engpc.disable",
		.value = "0",
	},
	{
		.key = "persist.sys.language",
		.value = "en",
	},
	{
		.key = "persist.sys.localevar",
		.value = "",
	},
	{
		.key = "persist.sys.modem.diag",
		.value = ",gser",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.setupwizard",
		.value = "FINISH",
	},
	{
		.key = "persist.sys.sprd.modemreset",
		.value = "1",
	},
	{
		.key = "persist.sys.sprd.wcnreset",
		.value = "1",
	},
	{
		.key = "persist.sys.ssrm_unbox_cnt",
		.value = "2",
	},
	{
		.key = "persist.sys.storage_preload",
		.value = "2",
	},
	{
		.key = "persist.sys.support.vt",
		.value = "false",
	},
	{
		.key = "persist.sys.timezone",
		.value = "America/New_York",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "persist.ttydev",
		.value = "ttyVUART0",
	},
	{
		.key = "ril.ICC_TYPE",
		.value = "0,0",
	},
	{
		.key = "ril.MSIMM",
		.value = "0",
	},
	{
		.key = "ril.RildInit",
		.value = "1",
	},
	{
		.key = "ril.SIMSLOT_EXCHANGED",
		.value = "0",
	},
	{
		.key = "ril.approved_codever",
		.value = "none",
	},
	{
		.key = "ril.approved_cscver",
		.value = "none",
	},
	{
		.key = "ril.approved_modemver",
		.value = "none",
	},
	{
		.key = "ril.atd_status",
		.value = "1_1_0",
	},
	{
		.key = "ril.boot_completed",
		.value = "1",
	},
	{
		.key = "ril.cp_ver",
		.value = "J120HXXU0APJ1",
	},
	{
		.key = "ril.dds.progressing",
		.value = "0",
	},
	{
		.key = "ril.deviceOffRes",
		.value = "1",
	},
	{
		.key = "ril.ecclist00",
		.value = "112,911,999,000,08,110,118,119",
	},
	{
		.key = "ril.ecclist10",
		.value = "112,911,999,000,08,110,118,119",
	},
	{
		.key = "ril.hw_ver",
		.value = "MP 0.400",
	},
	{
		.key = "ril.modem.board",
		.value = "SC7727SE",
	},
	{
		.key = "ril.official_cscver",
		.value = "J120HOJV0AQC1",
	},
	{
		.key = "ril.product_code",
		.value = "SM-J120HZDDBTC",
	},
	{
		.key = "ril.rfcal_date",
		.value = "20170710",
	},
	{
		.key = "ril.serialnumber",
		.value = "R51J703YHDV",
	},
	{
		.key = "ril.servicestate",
		.value = "2,1",
	},
	{
		.key = "ril.sim1.absent",
		.value = "1",
	},
	{
		.key = "ril.sim2.present",
		.value = "0",
	},
	{
		.key = "ril.subinfo",
		.value = "0:2147483643,1:2147483644",
	},
	{
		.key = "ril.sw_ver",
		.value = "J120HXXU0APJ1",
	},
	{
		.key = "ril.valid_certsig1",
		.value = "true",
	},
	{
		.key = "ril.valid_certsig2",
		.value = "true",
	},
	{
		.key = "ril.w.sim.power1",
		.value = "1",
	},
	{
		.key = "ril.w.sim.power",
		.value = "1",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.astcenc.astcsupport",
		.value = "0",
	},
	{
		.key = "ro.baseband",
		.value = "unknown",
	},
	{
		.key = "ro.board.platform",
		.value = "sc8830",
	},
	{
		.key = "ro.board_ram_size",
		.value = "high",
	},
	{
		.key = "ro.boot.bootloader",
		.value = "J120HXXS0AQE1",
	},
	{
		.key = "ro.boot.debug_level",
		.value = "0x4f4c",
	},
	{
		.key = "ro.boot.emmc_checksum",
		.value = "3",
	},
	{
		.key = "ro.boot.serialno",
		.value = "4200ff80dc185400",
	},
	{
		.key = "ro.boot_recovery",
		.value = "unknown",
	},
	{
		.key = "ro.bootloader",
		.value = "J120HXXS0AQE1",
	},
	{
		.key = "ro.bootmode",
		.value = "unknown",
	},
	{
		.key = "ro.bt.bdaddr_path",
		.value = "/efs/bluetooth/bt_addr",
	},
	{
		.key = "ro.build.PDA",
		.value = "J120HXXS0AQE1",
	},
	{
		.key = "ro.build.aapt.config.prefer",
		.value = "hdpi",
	},
	{
		.key = "ro.build.changelist",
		.value = "9606765",
	},
	{
		.key = "ro.build.characteristics",
		.value = "default",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1495100755",
	},
	{
		.key = "ro.build.date",
		.value = "Thu May 18 18:45:55 KST 2017",
	},
	{
		.key = "ro.build.description",
		.value = "j1x3gxx-user 5.1.1 LMY47V J120HXXS0AQE1 release-keys",
	},
	{
		.key = "ro.build.display.id",
		.value = "LMY47V.J120HXXS0AQE1",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "samsung/j1x3gxx/j1x3g:5.1.1/LMY47V/J120HXXS0AQE1:user/release-keys",
	},
	{
		.key = "ro.build.flavor",
		.value = "j1x3gxx-user",
	},
	{
		.key = "ro.build.hidden_ver",
		.value = "J120HXXS0AQE1",
	},
	{
		.key = "ro.build.host",
		.value = "SWDG9710",
	},
	{
		.key = "ro.build.id",
		.value = "LMY47V",
	},
	{
		.key = "ro.build.official.release",
		.value = "true",
	},
	{
		.key = "ro.build.product",
		.value = "j1x3g",
	},
	{
		.key = "ro.build.scafe.cream",
		.value = "white",
	},
	{
		.key = "ro.build.scafe.shot",
		.value = "single",
	},
	{
		.key = "ro.build.scafe.size",
		.value = "short",
	},
	{
		.key = "ro.build.scafe",
		.value = "capuccino",
	},
	{
		.key = "ro.build.selinux.enforce",
		.value = "1",
	},
	{
		.key = "ro.build.selinux",
		.value = "1",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "dpi",
	},
	{
		.key = "ro.build.version.all_codenames",
		.value = "REL",
	},
	{
		.key = "ro.build.version.base_os",
		.value = "samsung/j1x3gxx/j1x3g:5.1.1/LMY47V/J120HXXU0AQC1:user/release-keys",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "J120HXXS0AQE1",
	},
	{
		.key = "ro.build.version.release",
		.value = "5.1.1",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "22",
	},
	{
		.key = "ro.build.version.sdl",
		.value = "2203",
	},
	{
		.key = "ro.build.version.security_patch",
		.value = "2017-05-01",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.chipname",
		.value = "SC7727SE",
	},
	{
		.key = "ro.com.android.dataroaming",
		.value = "false",
	},
	{
		.key = "ro.com.android.dateformat",
		.value = "MM-dd-yyyy",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-samsung",
	},
	{
		.key = "ro.com.google.gmsversion",
		.value = "5.1_r7",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "Morning_Flower.ogg",
	},
	{
		.key = "ro.config.dha_cached_max",
		.value = "8",
	},
	{
		.key = "ro.config.dha_cached_min",
		.value = "4",
	},
	{
		.key = "ro.config.dha_empty_max",
		.value = "30",
	},
	{
		.key = "ro.config.dha_empty_min",
		.value = "6",
	},
	{
		.key = "ro.config.dha_lmk_scale",
		.value = "1",
	},
	{
		.key = "ro.config.ksm.support",
		.value = "true",
	},
	{
		.key = "ro.config.low_ram",
		.value = "true",
	},
	{
		.key = "ro.config.mdha_ssr_enable",
		.value = "true",
	},
	{
		.key = "ro.config.media_sound",
		.value = "Media_preview_Touch_the_light.ogg",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "Skyline.ogg",
	},
	{
		.key = "ro.config.notification_sound_2",
		.value = "S_Charming_Bell.ogg",
	},
	{
		.key = "ro.config.ringtone",
		.value = "Over_the_Horizon.ogg",
	},
	{
		.key = "ro.config.ringtone_2",
		.value = "Basic_Bell.ogg",
	},
	{
		.key = "ro.config.zram.support",
		.value = "true",
	},
	{
		.key = "ro.cp_debug_level",
		.value = "unknown",
	},
	{
		.key = "ro.crypto.fuse_sdcard",
		.value = "true",
	},
	{
		.key = "ro.crypto.state",
		.value = "unencrypted",
	},
	{
		.key = "ro.csc.country_code",
		.value = "Libya",
	},
	{
		.key = "ro.csc.countryiso_code",
		.value = "LY",
	},
	{
		.key = "ro.csc.sales_code",
		.value = "BTC",
	},
	{
		.key = "ro.dalvik.vm.native.bridge",
		.value = "0",
	},
	{
		.key = "ro.debug_level",
		.value = "0x4f4c",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.digital.fm.support",
		.value = "1",
	},
	{
		.key = "ro.emmc_checksum",
		.value = "3",
	},
	{
		.key = "ro.error.receiver.default",
		.value = "com.samsung.receiver.error",
	},
	{
		.key = "ro.factorytest",
		.value = "0",
	},
	{
		.key = "ro.frp.pst",
		.value = "/dev/block/persistent",
	},
	{
		.key = "ro.hardware",
		.value = "sc8830",
	},
	{
		.key = "ro.hmac_mismatch",
		.value = "unknown",
	},
	{
		.key = "ro.im.param.offset",
		.value = "unknown",
	},
	{
		.key = "ro.kernel.qemu",
		.value = "0",
	},
	{
		.key = "ro.mct.compressiontype",
		.value = "ETC1",
	},
	{
		.key = "ro.me.param.offset",
		.value = "unknown",
	},
	{
		.key = "ro.modem.w.assert",
		.value = "/dev/spipe_w2",
	},
	{
		.key = "ro.modem.w.count",
		.value = "2",
	},
	{
		.key = "ro.modem.w.dev",
		.value = "/proc/cpw/",
	},
	{
		.key = "ro.modem.w.diag",
		.value = "/dev/slog_w",
	},
	{
		.key = "ro.modem.w.eth",
		.value = "rmnet",
	},
	{
		.key = "ro.modem.w.fixnv_size",
		.value = "0x40000",
	},
	{
		.key = "ro.modem.w.id",
		.value = "0",
	},
	{
		.key = "ro.modem.w.log",
		.value = "/dev/slog_w",
	},
	{
		.key = "ro.modem.w.loop",
		.value = "/dev/spipe_w0",
	},
	{
		.key = "ro.modem.w.nv",
		.value = "/dev/spipe_w1",
	},
	{
		.key = "ro.modem.w.runnv_size",
		.value = "0x60000",
	},
	{
		.key = "ro.modem.w.snd",
		.value = "1",
	},
	{
		.key = "ro.modem.w.tty",
		.value = "/dev/stty_w",
	},
	{
		.key = "ro.modem.w.vbc",
		.value = "/dev/spipe_w6",
	},
	{
		.key = "ro.modem.wcn.diag",
		.value = "/dev/slog_wcn",
	},
	{
		.key = "ro.modem.wcn.enable",
		.value = "1",
	},
	{
		.key = "ro.msms.phone_count",
		.value = "2",
	},
	{
		.key = "ro.multisim.simslotcount",
		.value = "2",
	},
	{
		.key = "ro.opengles.version",
		.value = "131072",
	},
	{
		.key = "ro.pr.param.offset",
		.value = "unknown",
	},
	{
		.key = "ro.product.board",
		.value = "SC7727SE",
	},
	{
		.key = "ro.product.brand",
		.value = "samsung",
	},
	{
		.key = "ro.product.cpu.abi2",
		.value = "armeabi",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "armeabi-v7a",
	},
	{
		.key = "ro.product.cpu.abilist32",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist64",
		.value = "",
	},
	{
		.key = "ro.product.cpu.abilist",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.device",
		.value = "j1x3g",
	},
	{
		.key = "ro.product.hardware",
		.value = "J1X3G_V1.0.0",
	},
	{
		.key = "ro.product.locale.language",
		.value = "en",
	},
	{
		.key = "ro.product.locale.region",
		.value = "GB",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "samsung",
	},
	{
		.key = "ro.product.model",
		.value = "SM-J120H",
	},
	{
		.key = "ro.product.name",
		.value = "j1x3gxx",
	},
	{
		.key = "ro.product.partitionpath",
		.value = "/dev/block/platform/sdio_emmc/by-name/",
	},
	{
		.key = "ro.product_ship",
		.value = "true",
	},
	{
		.key = "ro.revision",
		.value = "5",
	},
	{
		.key = "ro.ril.ecclist",
		.value = "112,911,#911,*911",
	},
	{
		.key = "ro.rtn_config",
		.value = "unknown",
	},
	{
		.key = "ro.runtime.firstboot",
		.value = "1515121985079",
	},
	{
		.key = "ro.sec.fle.encryption",
		.value = "true",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.serialno",
		.value = "4200ff80dc185400",
	},
	{
		.key = "ro.setupwizard.mode",
		.value = "OPTIONAL",
	},
	{
		.key = "ro.sf.hwrotation",
		.value = "0",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "240",
	},
	{
		.key = "ro.sf.lcd_height",
		.value = "96",
	},
	{
		.key = "ro.sf.lcd_width",
		.value = "54",
	},
	{
		.key = "ro.sku.param.offset",
		.value = "unknown",
	},
	{
		.key = "ro.sn.param.offset",
		.value = "unknown",
	},
	{
		.key = "ro.storage.flash_type",
		.value = "2",
	},
	{
		.key = "ro.storage.install2internal",
		.value = "0",
	},
	{
		.key = "ro.warranty_bit",
		.value = "unknown",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "ro.zygote",
		.value = "zygote32",
	},
	{
		.key = "sec.fle.encryption.status",
		.value = "Dec NewFile IncludeMedia",
	},
	{
		.key = "security.ASKS.policy_version",
		.value = "161011",
	},
	{
		.key = "selinux.policy_version",
		.value = "SEPF_SM-J120H_5.1.1_0072",
	},
	{
		.key = "selinux.reload_policy",
		.value = "1",
	},
	{
		.key = "selinux.sec.restorecon",
		.value = "1",
	},
	{
		.key = "service.bootanim.exit",
		.value = "0",
	},
	{
		.key = "service.brcm.fm.set_blndmute",
		.value = "1",
	},
	{
		.key = "service.brcm.fm.start_mute",
		.value = "255",
	},
	{
		.key = "service.media.powersnd",
		.value = "1",
	},
	{
		.key = "storage.mmc.size",
		.value = "7818182656",
	},
	{
		.key = "storage.preload.complete",
		.value = "1",
	},
	{
		.key = "sys.boot_completed",
		.value = "1",
	},
	{
		.key = "sys.cameramode.blackbox",
		.value = "0",
	},
	{
		.key = "sys.cameramode.vtcall",
		.value = "0",
	},
	{
		.key = "sys.dockstate",
		.value = "0",
	},
	{
		.key = "sys.enterprise.billing.version",
		.value = "1.2.0",
	},
	{
		.key = "sys.internal.emulated",
		.value = "1",
	},
	{
		.key = "sys.isdumpstaterunning",
		.value = "0",
	},
	{
		.key = "sys.lmk.adj",
		.value = "0,1,3,9,11,15",
	},
	{
		.key = "sys.lmk.minfree",
		.value = "3072,4096,4608,6656,8704,10752",
	},
	{
		.key = "sys.onemodem.start.enable",
		.value = "1",
	},
	{
		.key = "sys.settings_system_version",
		.value = "3",
	},
	{
		.key = "sys.siop.level",
		.value = "0",
	},
	{
		.key = "sys.ssrm.mdnie",
		.value = "-1",
	},
	{
		.key = "sys.symlink.umts_router",
		.value = "/dev/pts/16  /dev/umts_router",
	},
	{
		.key = "sys.sysctl.extra_free_kbytes",
		.value = "4500",
	},
	{
		.key = "sys.tempsd.enable",
		.value = "0",
	},
	{
		.key = "sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.gser.count",
		.value = "4",
	},
	{
		.key = "sys.usb.state",
		.value = "mtp,adb",
	},
	{
		.key = "sys.vm.swappiness",
		.value = "100",
	},
	{
		.key = "vold.pfe",
		.value = "deactivated",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wlan.driver.status",
		.value = "ok",
	},
	{
		.key = "wlan.p2p.no_go_iface",
		.value = "1",
	},
	{
		.key = "zram.disksize",
		.value = "600",
	},
	{ NULL },
};
#endif /* __ANDROID__ */
