/*
 *  Author:       Serg Stoyan
 *
 *  Classes:      InfoPanel : NSObject
 *
 *  Description:  Info panel.
 */

#import <AppKit/NSApplication.h>
#import <AppKit/NSPanel.h>
#import <AppKit/NSButton.h>
#import <AppKit/NSBox.h>
#import <AppKit/NSTextField.h>

#import "AppController.h"
#import "Info.h"

@implementation InfoPanel

- init
{
  NSLog(@"InfoPanel init");

  // Panel
  panel = [[NSWindow alloc] initWithContentRect: NSMakeRect(0, 0, 300, 235)
                                     styleMask: NSTitledWindowMask |
                                                NSClosableWindowMask
                                       backing: NSBackingStoreRetained
                                         defer: YES];
  
  [panel setTitle: @"Info"];
  [panel setMinSize: NSMakeSize(200, 300)];
  [panel setMaxSize: NSMakeSize(200, 300)];
  [panel setReleasedWhenClosed: NO];
  [panel setHidesOnDeactivate: YES];
  [panel setDelegate: self];
  [panel center];

  iconLabel = [[NSButton alloc] initWithFrame: NSMakeRect(76, 221, 48, 48)];
  [iconLabel setImage: [NSApp applicationIconImage]];
  [iconLabel setImagePosition: NSImageOnly];
  [iconLabel setBordered: NO];
  [[panel contentView] addSubview:iconLabel];

  RELEASE (iconLabel);

  return self;
}

/*-------------------------------------------------------------------------*
 *  Window delegate methods
 *-------------------------------------------------------------------------*/
- (void) orderFront: (id)sender
{
  [panel orderFront: nil];
  [panel makeKeyWindow];
}

- (void) dealloc
{
  NSLog(@"InfoPanel: dealloc");
  RELEASE(panel);

  [super dealloc];
}

- (void) windowWillClose: (NSNotification *)notif
{
  NSLog(@"InfoPanel: will close");
  
  [ConnectApp infoPanelWillClose];
  
  [self release];
}

@end
