{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetCenter: TVector3Double;
    procedure SetCenter(const Value: TVector3Double);
    function GetGeoOrigin: TGeoOriginNode;
    procedure SetGeoOrigin(const Value: TGeoOriginNode);
    function GetRange: Single;
    procedure SetRange(const Value: Single);
    function GetBboxCenter: TVector3;
    procedure SetBboxCenter(const Value: TVector3);
    function GetBboxSize: TVector3;
    procedure SetBboxSize(const Value: TVector3);
  public
    property Center: TVector3Double read GetCenter write SetCenter;
    procedure SetChild1Url(const Value: array of string);
    procedure SetChild1Url(const Value: TCastleStringList);
    procedure SetChild2Url(const Value: array of string);
    procedure SetChild2Url(const Value: TCastleStringList);
    procedure SetChild3Url(const Value: array of string);
    procedure SetChild3Url(const Value: TCastleStringList);
    procedure SetChild4Url(const Value: array of string);
    procedure SetChild4Url(const Value: TCastleStringList);
    property GeoOrigin: TGeoOriginNode read GetGeoOrigin write SetGeoOrigin;
    procedure SetGeoSystem(const Value: array of string);
    procedure SetGeoSystem(const Value: TCastleStringList);
    property Range: Single read GetRange write SetRange;
    procedure SetRootUrl(const Value: array of string);
    procedure SetRootUrl(const Value: TCastleStringList);
    procedure SetRootNode(const Value: array of TAbstractChildNode);
    property BboxCenter: TVector3 read GetBboxCenter write SetBboxCenter;
    property BboxSize: TVector3 read GetBboxSize write SetBboxSize;

{$endif read_interface}

{$ifdef read_implementation}

{ TGeoLODNode ----------------------------------------------- }

function TGeoLODNode.GetCenter: TVector3Double;
begin
  Result := FdCenter.Value;
end;

procedure TGeoLODNode.SetCenter(const Value: TVector3Double);
begin
  FdCenter.Send(Value);
end;

procedure TGeoLODNode.SetChild1Url(const Value: array of string);
begin
  FdChild1Url.Send(Value);
end;

procedure TGeoLODNode.SetChild1Url(const Value: TCastleStringList);
begin
  FdChild1Url.Send(Value);
end;

procedure TGeoLODNode.SetChild2Url(const Value: array of string);
begin
  FdChild2Url.Send(Value);
end;

procedure TGeoLODNode.SetChild2Url(const Value: TCastleStringList);
begin
  FdChild2Url.Send(Value);
end;

procedure TGeoLODNode.SetChild3Url(const Value: array of string);
begin
  FdChild3Url.Send(Value);
end;

procedure TGeoLODNode.SetChild3Url(const Value: TCastleStringList);
begin
  FdChild3Url.Send(Value);
end;

procedure TGeoLODNode.SetChild4Url(const Value: array of string);
begin
  FdChild4Url.Send(Value);
end;

procedure TGeoLODNode.SetChild4Url(const Value: TCastleStringList);
begin
  FdChild4Url.Send(Value);
end;

function TGeoLODNode.GetGeoOrigin: TGeoOriginNode;
begin
  if FdGeoOrigin.Value is TGeoOriginNode then
    Result := TGeoOriginNode(FdGeoOrigin.Value)
  else
    Result := nil;
end;

procedure TGeoLODNode.SetGeoOrigin(const Value: TGeoOriginNode);
begin
  FdGeoOrigin.Send(Value);
end;

procedure TGeoLODNode.SetGeoSystem(const Value: array of string);
begin
  FdGeoSystem.Send(Value);
end;

procedure TGeoLODNode.SetGeoSystem(const Value: TCastleStringList);
begin
  FdGeoSystem.Send(Value);
end;

function TGeoLODNode.GetRange: Single;
begin
  Result := FdRange.Value;
end;

procedure TGeoLODNode.SetRange(const Value: Single);
begin
  FdRange.Send(Value);
end;

procedure TGeoLODNode.SetRootUrl(const Value: array of string);
begin
  FdRootUrl.Send(Value);
end;

procedure TGeoLODNode.SetRootUrl(const Value: TCastleStringList);
begin
  FdRootUrl.Send(Value);
end;

procedure TGeoLODNode.SetRootNode(const Value: array of TAbstractChildNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractChildNode));
  FdRootNode.Send(A);
end;

function TGeoLODNode.GetBboxCenter: TVector3;
begin
  Result := FdBboxCenter.Value;
end;

procedure TGeoLODNode.SetBboxCenter(const Value: TVector3);
begin
  FdBboxCenter.Send(Value);
end;

function TGeoLODNode.GetBboxSize: TVector3;
begin
  Result := FdBboxSize.Value;
end;

procedure TGeoLODNode.SetBboxSize(const Value: TVector3);
begin
  FdBboxSize.Send(Value);
end;

{$endif read_implementation}
