/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2001 The Caudium Group
 * Based on IMHO  Stefan Wallstrm and Bosse Lincoln.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * $Id: ldap.h,v 1.2.6.3 2001/11/22 06:48:21 kiwi Exp $
 */

#if constant(Protocols.LDAP)

string getldapaddr (object imho, string namecont)
{      	
  string filter, server, basedn;
  mixed status;
  mixed error;
  string name, address, dn, ou, output = "";
  object con;
  int inx;
  string uname = "", passwd = "";
  
  namecont = TO_UTF8 (namecont);
  server = imho->query ("ldapserver");
  if (server == "")
    server = "localhost";
  basedn = imho->query ("ldapsearchroot");
  int version = imho->query ("ldapversion");
  
  if(imho->query("ldapuser") != "")
    uname=imho->query("ldapuser");
  if(imho->query("ldappass") != "")
    passwd=imho->query("ldappass");
  
  error = catch (con = Protocols.LDAP.client (server));
  error |= catch (con->bind (uname, passwd, version));
  
  if (error || !objectp(con)) {
    if (imho->query ("debug"))
      write ("Protocols.LDAP: error= " + error[0] + "\n");
    return "";
  }

  status = con->set_basedn(basedn);
  status = con->set_scope(2);
  
  // filter = "cn=*";
  filter = "(|(cn=*" + namecont + "*)(sn=*" + namecont + "*))";
  object en;
  string ldap_last_error;
  
  if (error = catch(en = con->search(filter))) {
    //string con_err = con->error_string();
    string con_err = error[0];
    ldap_last_error = "LDAP search \"" + filter + "\" failed: " + con_err;
    if (imho->query ("debug"))
      write (ldap_last_error + "\n");
    return "";
  }
  con->unbind();
  
  int start;
  
  for(inx = 1; inx <= en->num_entries(); inx++)
  {
    address = sprintf("%s", (en->fetch(inx)["mail"]||({ "" }))[0]);
    string temp = (en->fetch(inx)["dn"]||({ "" }))[0];
      name = (en->fetch(inx)["cn"]||({ "" }))[0];
      if(sizeof(name) == 0) {
        name = (en->fetch(inx)["givenname"]||({ "" }))[0] + " " + (en->fetch(inx)["sn"]||({ "" }))[0];
      }
    if(imho->query("ldapshowou"))
    {
      if(arrayp(en->fetch(inx)["ou"])==1)
	ou = en->fetch(inx)["ou"][0];
      else
	sscanf(temp, "ou=%s", ou);
      if(sizeof(output) == 0)
	output = name + ":" +  address + ":" + ou;
      else
	output += "\n" + name + ":" + address + ":" + ou;
    }
    else
    {
      if(sizeof(output) == 0)
	output = name + ":" +  address;
      else
	output += "\n" + name + ":" + address;
    }
  }
  return FROM_UTF8(output);
}

#endif
