#
# Copyright (C) 1999  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

# version
source version.tcl

# pkgdatadir
set pkgdatadir "C:\\Program Files\\BookView"

# srcdir
set srcdir [file dirname $argv0]

# Files to be installed.
set install_files {
    "bookview/bookview.tcl"
    "bookview/finder.tcl"
    "bookview/message.tcl"
    "bookview/ndtp.tcl"
    "bookview/help.tcl"
    "bookview/setup.tcl"
    "bookview/ja.mo"
    "bitmap/arrow.xbm"
    "bitmap/copyright.gif"
    "bitmap/find.gif"
    "bitmap/menu.gif"
    "bitmap/next.gif"
    "bitmap/prev.gif"
    "bitmap/space.xbm"
    "doc/help.txt"
    "doc-ja/help-ja.txt"
}

set button_flag ""

#
# Make a window.
#
proc make_main_window {} {
    global button_flag
    global pkgdatadir

    #
    # Set window title.
    #
    wm title . "BookView Tiny Installer for Windows"

    #
    # Install prefix.
    #
    frame .pkgdatadir
    pack .pkgdatadir -side top -expand 1 -fill x -padx 4 -pady 4
    label .pkgdatadir.label -text "Install Directory: "
    pack .pkgdatadir.label -side left
    entry .pkgdatadir.entry -textvariable pkgdatadir -width 40
    pack .pkgdatadir.entry -side left -expand 1 -fill x
    bind .pkgdatadir.entry <Return> {set button_flag "exit"}

    #
    # Buttons.
    #
    frame .buttons
    pack .buttons -side top -expand 1 -fill x -padx 4 -pady 4
    button .buttons.install -text "Install" -default active \
	    -command {set button_flag "install"}
    pack .buttons.install -side left -expand 1
    button .buttons.exit -text "Exit" \
	    -command {set button_flag "exit"}
    pack .buttons.exit -side left -expand 1

    #
    # Wait until an user clicks a button.
    #
    tkwait variable button_flag
    if {$button_flag == "exit"} {
	destroy .
	exit
    }
}

#
# Install.
#
proc install_bookview {} {
    global version
    global pkgdatadir
    global srcdir
    global install_files

    #
    # Generate `bookview/bookview.tcl' from `bookview/bookview.in'.
    #
    file delete -force "$srcdir/bookview/bookview.tcl"
    if {[catch {set rfile [open "$srcdir/bookview/bookview.in" "r"]} \
	    error_message]} {
	return $error_message
    }
    if {[catch {set wfile [open "$srcdir/bookview/bookview.tcl" "w"]} \
	    error_message]} {
	catch {close $rfile}
	return $error_message
    }
    while {1} {
	if {[catch {gets $rfile line} error_message]} {
	    catch {close $rfile}
	    catch {close $wfile}
	    return $error_message
	}
	regsub -all {@VERSION@} $line $version line
	regsub -all {@pkgdatadir@} $line $pkgdatadir line
	if {[catch {puts $wfile $line} error_message]} {
	    catch {close $rfile}
	    catch {close $wfile}
	    return $error_message
	}
	if {[eof $rfile]} {
	    break
	}
    }
    catch {close $rfile}
    catch {close $wfile}

    #
    # Make the directory $pkgdatadir.
    #
    if {![file isdirectory $pkgdatadir]} {
	if {[catch {file mkdir $pkgdatadir} error_message]} {
	    return $error_message
	}
    }

    #
    # Install files.
    #
    foreach src $install_files {
	set dst "$pkgdatadir/[file tail $src]"
	if {[catch {file copy -force $srcdir/$src $dst} error_message]} {
	    return $error_message
	}
    }

    return "Done."
}

#
# Make a result window.
#
proc make_result_window {message} {
    global button_flag

    toplevel .result
    set x [expr [winfo rootx .] + 24]
    set y [expr [winfo rooty .] + 24]
    wm geometry .result +$x+$y
    focus .result
    grab .result

    #
    # Message.
    #
    frame .result.message
    pack .result.message -side top -expand 1 -fill x -padx 4 -pady 4
    message .result.message.message -text $message -width 40c
    pack .result.message.message -side top -expand 1 -fill x

    #
    # Buttons.
    #
    frame .result.buttons
    pack .result.buttons -side top -expand 1 -fill x -padx 4 -pady 4
    button .result.buttons.exit -text "Exit" -default active \
	    -command {set button_flag "exit"}
    pack .result.buttons.exit -side top -expand 1 -fill x

    bind .result <Return> {set button_flag "exit"}

    #
    # Wait until an user clicks a button.
    #
    tkwait variable button_flag
    destroy .
}

make_main_window
regsub -all "\\\\" $pkgdatadir "/" pkgdatadir
set message [install_bookview]
make_result_window $message
