/*
 * part of bidwatcher
 * Author: Jan Starzynski
 * use of this code is restricted to the terms
 * of the GNU GPL, which should have been included in this
 * distribution. If not, see www.gnu.org/copyleft/gpl.html.
 * Here is the short version:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * $Id: bidgroup.h,v 1.1.2.4 2004/08/25 07:44:58 sturnus Exp $
 *
 * Handling of Bidgroups
 */

#ifndef BIDWATCHER_BIDGROUP_H
#define BIDWATCHER_BIDGROUP_H

#include "config.h"

#ifdef HAVE_STL

#define HAVE_BIDGROUP 1

#include <vector>
#include <set>
#include <cstdio>

class BidGroup {
public:
  typedef unsigned long long    IdType;
  typedef std::set<IdType>      ItemList;
  typedef std::vector<ItemList> GroupList;

  void clear();
  int numGroup() const;

  ItemList *addItem(const IdType &id1, const IdType &id2);
  bool delItem(const IdType &id);

  int groupId(const IdType &id) const;
  const ItemList *getGroup(int idx) const { return getGroupP(idx); }
  ItemList *getGroup(int idx) { return getGroupP(idx); }

  const ItemList *findItem(const IdType &id) const { return findItemP(id); }
  ItemList *findItem(const IdType &id) { return findItemP(id); }
  std::vector<IdType> &findItem(std::vector<IdType> &vec, const IdType &id);

  void sweepList(bool at_end_only = true);

  bool read(const char *file);
  bool read(std::FILE *fp);

  bool write(const char *file) const;
  bool write(std::FILE *fp) const;

private:
  GroupList m_list;
  ItemList *findItemP(const IdType &id) const;
  ItemList *getGroupP(int idx) const;
};

#else

#include <stdio.h>

class BidGroup {
public:
  typedef unsigned long long    IdType;
  int groupId(const IdType &id) const { return 0; }
  bool delItem(const IdType &id) { return false; }
  void *addItem(const IdType &id1, const IdType &id2) { return 0; }
  void sweepList(bool at_end_only = true) {}
  bool read(const char *file) { return false; }
  bool read(FILE *fp) { return false; }

  bool write(const char *file) const { return false; }
  bool write(FILE *fp) const { return false; }

  void clear() {}
  int numGroup() const { return 0; }
};

#endif

#endif

