// resource.cc for bbappconf - a pager tool for Blackbox
//
//  Copyright (c) 1998-1999 John Kennis, jkennis@chello.nl
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//

#include "resource.hh"
#include "blackboxstyle.hh"

Resource::Resource(ToolWindow *toolwindow): BaseResource(toolwindow) {
  Load();
}

Resource::~Resource() {
  Clean();
}

void Resource::Clean() {
	if (frame.font) 
		XFreeFont(bbtool->getXDisplay(), frame.font);
  delete [] app_conf;
}

AppConf *Resource::getAppConf(int i){
  return &app_conf[i];
}


void Resource::LoadBBToolResource(void) {
  XrmValue value;
  char *value_type;

  Frame();
  
  SizeAndPosition();

  Font();

  Config();
}

void Resource::Config() {
  unsigned int start_on_desktop;
  XrmValue value;
  char *value_type;
  int i;
  char rclass[40];
  char rname[40];
	int position_x, position_y;
	int width, height;
  
  if ((XrmGetResource(resource_db, "bbappconf.numberOf.configs",
                       "Bbappconf.NumberOf.Configs",
                       &value_type, &value))) {
    if (sscanf(value.addr, "%u", &number_of_confs) != 1) {
      number_of_confs = 0;
    }
  } else
    number_of_confs=0;
  app_conf = new AppConf[number_of_confs];
  for (i=0;i<number_of_confs;i++) {

    sprintf(rclass, "Bbappconf.%d.ClassHint.Class",i+1);
    sprintf(rname,  "bbappconf.%d.classHint.class",i+1);

    if ((XrmGetResource(resource_db, rname,rclass,
                        &value_type, &value))) {
      app_conf[i].LoadAppClass(value.addr);
    } else
     app_conf[i].LoadAppClass(NULL);

    sprintf(rclass, "Bbappconf.%d.ClassHint.Name",i+1);
    sprintf(rname,  "bbappconf.%d.classHint.name",i+1);

    if ((XrmGetResource(resource_db, rname,rclass,
                        &value_type, &value))) {
      app_conf[i].LoadAppName(value.addr);
    } else
      app_conf[i].LoadAppName(NULL);

    if ((app_conf[i].getName()==NULL)&(app_conf[i].getClass()==NULL)) {
      fprintf(stderr,"Error, either appclass or appname should be specified");
      exit(-1);
    }
 
    sprintf(rclass, "Bbappconf.%d.Stick",i+1);
    sprintf(rname,  "bbappconf.%d.stick",i+1);

    if ((XrmGetResource(resource_db, rname,rclass,
                        &value_type, &value))) {
      if (! strncasecmp("true", value.addr, value.size)) {
        app_conf[i].setSticky(true);
      } else {
        app_conf[i].setSticky(false);
      }
    } else {
      app_conf[i].setSticky(false);
    }
    sprintf(rclass, "Bbappconf.%d.Decorless",i+1);
    sprintf(rname,  "bbappconf.%d.decorless",i+1);

    if ((XrmGetResource(resource_db, rname,rclass,
                        &value_type, &value))) {
      if (! strncasecmp("true", value.addr, value.size)) {
        app_conf[i].setDecorless(true);
      } else {
        app_conf[i].setDecorless(false);
      }
    } else {
      app_conf[i].setDecorless(false);
    }

    sprintf(rclass, "Bbappconf.%d.StartOnWorkspace",i+1);
    sprintf(rname,  "bbappconf.%d.startOnWorkspace",i+1);
    if ((XrmGetResource(resource_db, rname,rclass,
                        &value_type, &value))) {
      if (sscanf(value.addr, "%u", &start_on_desktop) != 1) {
        start_on_desktop = 0;
      }
    } else
     start_on_desktop=0;

    app_conf[i].setStartOnDesktop(start_on_desktop);

    sprintf(rclass, "Bbappconf.%d.MaxVert",i+1);
    sprintf(rname,  "bbappconf.%d.maxVert",i+1);

    if ((XrmGetResource(resource_db, rname,rclass,
                        &value_type, &value))) {
      if (! strncasecmp("true", value.addr, value.size)) {
        app_conf[i].setMaxVert(true);

      } else {
        app_conf[i].setMaxVert(false);
      }
    } else {
      app_conf[i].setMaxVert(false);
    }

    sprintf(rclass, "Bbappconf.%d.MaxHoriz",i+1);
    sprintf(rname,  "bbappconf.%d.maxHoriz",i+1);

    if ((XrmGetResource(resource_db, rname,rclass,
                        &value_type, &value))) {
      if (! strncasecmp("true", value.addr, value.size)) {
        app_conf[i].setMaxHoriz(true);
      } else {
        app_conf[i].setMaxHoriz(false);
      }
    } else {
      app_conf[i].setMaxHoriz(false);
    }

    sprintf(rclass, "Bbappconf.%d.Width",i+1);
		sprintf(rname,  "bbappconf.%d.width",i+1);
		if ((XrmGetResource(resource_db, rname,rclass,
												&value_type, &value))) {
			if (sscanf(value.addr, "%u", &width) != 1) {
				width = -1;
			}
		} else
		 width=-1;
		app_conf[i].setWidth(width);

		sprintf(rclass, "Bbappconf.%d.Height",i+1);
		sprintf(rname,  "bbappconf.%d.height",i+1);
		if ((XrmGetResource(resource_db, rname,rclass,
												&value_type, &value))) {
			if (sscanf(value.addr, "%u", &height) != 1) {
				height = -1;
			}
		} else
		 height=-1;
		app_conf[i].setHeight(height);

		sprintf(rclass, "Bbappconf.%d.PositionX",i+1);
    sprintf(rname,  "bbappconf.%d.positionX",i+1);
    if ((XrmGetResource(resource_db, rname,rclass,
                        &value_type, &value))) {
      if (sscanf(value.addr, "%u", &position_x) != 1) {
        position_x = -1111;
      }
    } else
     position_x=-1111;
		app_conf[i].setPositionX(position_x);

    sprintf(rclass, "Bbappconf.%d.PositionY",i+1);
    sprintf(rname,  "bbappconf.%d.positionY",i+1);
    if ((XrmGetResource(resource_db, rname,rclass,
                        &value_type, &value))) {
      if (sscanf(value.addr, "%u", &position_y) != 1) {
        position_y = -1111;
      }
    } else
     position_y=-1111;
		app_conf[i].setPositionY(position_y);

  }
}

void Resource::Frame() {
  XrmValue value;
  char *value_type;

  readTexture("bbappconf.frame","BbPager.Frame",BB_FRAME,"Toolbar",
             "slategrey","darkslategrey","Raised Gradient Vertical Bevel1",
             &frame.texture);

  if (XrmGetResource(resource_db, "bbappconf.bevelWidth","Bbappconf.BevelWidth",
                     &value_type, &value)) {
    if (sscanf(value.addr, "%u", &frame.bevelWidth) != 1)
      frame.bevelWidth = 4;
    else if (frame.bevelWidth == 0)
      frame.bevelWidth = 4;
  } else if (XrmGetResource(resource_db, BB_BEVELWIDTH,"BevelWidth", &value_type,
                            &value)) {
    if (sscanf(value.addr, "%u", &frame.bevelWidth) != 1)
      frame.bevelWidth = 4;
    else if (frame.bevelWidth == 0)
      frame.bevelWidth = 4;
  } else
    frame.bevelWidth = 4;
}


void Resource::SizeAndPosition() {
  XrmValue value;
  char *value_type;
  unsigned int w,h;
  char positionstring[11];

  if (!(bbtool->position)) {
    if (!(XrmGetResource(resource_db, "bbappconf.position","Bbappconf.Position",
                         &value_type, &value)))
      strncpy(positionstring, "+0+0", 5);
    else
      strncpy(positionstring, value.addr, strlen(value.addr)+1);
  } else
    strncpy(positionstring, bbtool->position, strlen(bbtool->position)+1);


  position.mask=XParseGeometry(positionstring, &position.x, &position.y, 
                              &w, &h);

  if (!(position.mask & XValue))
    position.x=0;
  if (!(position.mask & YValue))
    position.y=0;
}

void Resource::Font(){
  XrmValue value;
  char *value_type;

	const char *defaultFont=
          "-*-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*";
	
	if (frame.font)
	{
    XFreeFont(bbtool->getXDisplay(), frame.font);
		frame.font = 0;
	}
	
	if (XrmGetResource(resource_db, "bbappconf.frame.font",
                          "Bbappconf.Frame.Font",
						&value_type, &value))
	{
    if ((frame.font = XLoadQueryFont(bbtool->getXDisplay(), value.addr)) 
                                                                   == NULL) {
   		fprintf(stderr, " blackbox: couldn't load font '%s'\n"
	   					" ...  reverting to default font.", value.addr);
	   	if ((frame.font = XLoadQueryFont(bbtool->getXDisplay(), defaultFont)) 
                                                                   == NULL) {
  			fprintf(stderr,"bbappconf: couldn't load default font. please check to\n"
								"make sure the necessary font is installed '%s'\n",
					defaultFont);
				exit(2);
			}
		}
	} else { 
   	if ((frame.font = XLoadQueryFont(bbtool->getXDisplay(), defaultFont)) 
                                                                   == NULL) {
			fprintf(stderr,
	      			"bbappconf: couldn't load default font.  please check to\n"
	      			"make sure the necessary font is installed '%s'\n", defaultFont);
			exit(2);
		}
	}
}
