/*
 * Copyright (c) 2001 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __PATHPAGE_H__
#define __PATHPAGE_H__

#include "_pathpage.h"
#include "configdlg.h"

/*========================================================*/

class ArsonConfigDlg;
class ArsonConfig;
class QComboBox;
class QListViewItem;

class ArsonPathPage : public ArsonPathPageBase, public ArsonConfigPage
{
	Q_OBJECT
	
public:
	ArsonPathPage (ArsonConfig &cfg, ArsonConfigDlg *pdlg, QWidget *parent);

private:
	virtual void auto_detect_clicked (void);
	virtual void modify_clicked (void);

	void fillDriverList (QComboBox *ptr);
	void fillProgramList (void);
	
private slots:
	void program_dblclk (QListViewItem *pItem);
	void url_clicked (const QString &url);
	void on_accept (void);
};

/*========================================================*/
#endif	/*	__PATHPAGE_H__	*/
