/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __LISTWND_H__
#define __LISTWND_H__

#include <klistview.h>

/*========================================================*/

struct ArsonListHeader {
	ArsonListHeader (const QString &str, int w = 0)
		: text(str), width(w) {}

	inline int calc_width (int max) const
	{
		return (int) (((double) max) * (((double) width) * 0.01));
	}

	QString text;
	int width;
};

/*========================================================*/
/*	List window class definition
 *========================================================*/

class ArsonListWndBase : public KListView
{
	Q_OBJECT
	
public:
	ArsonListWndBase (QWidget *parent, const char *name);

	void setListHeaders (ArsonListHeader *pHdrs, int count);
	uint itemListStates (void) const;
	void resizeColumns (int width);
	void setSortable (bool sortable);

	virtual QSize minimumSizeHint (void) const { return sizeHint(); }
	virtual QSize sizeHint (void) const;

	enum {
		itemDelete = 0x01,
		itemUp = 0x02,
		itemDown = 0x04,
	};

protected:
	virtual void resizeEvent (QResizeEvent *pEvent);

	struct {
		ArsonListHeader *pHdrs;
		int count;
	}	m_headers;

	int m_nLastCol;
	bool m_bAscend;
	
protected slots:
	virtual void slotHdrClicked (int col);
	bool moveItemUp (void);
	bool moveItemDown (void);
};

/*========================================================*/

class QResizeEvent;
class ArsonListDoc;

class ArsonListWnd : public ArsonListWndBase
{
public:
	ArsonListWnd (ArsonListDoc *parent);
};

/*========================================================*/

class ArsonFileListDoc;

class ArsonFileListWnd : public ArsonListWnd
{
public:
	ArsonFileListWnd (ArsonFileListDoc *parent);

	virtual bool acceptDrag (QDropEvent *ptr) const;
};

/*========================================================*/

class ArsonMp3List : public ArsonFileListWnd
{
public:
	ArsonMp3List (ArsonFileListDoc *parent);

	enum {
		HEADER_FILENAME,
		HEADER_TITLE,
		HEADER_LENGTH,
		_HEADER_MAX
	};

private:
	static ArsonListHeader sHeaders[_HEADER_MAX];
};

/*========================================================*/
#endif	/*	__LISTWND_H__	*/
