#!/usr/bin/perl
# Read original include file, and generate enumeration

$file = @ARGV[0];
$prefix = "NFOSMESA_";

if ( ! defined(open(FILE, $file)) ) {
	warn "Couldn't open $file: $!\n";
	exit;
}

print "/* Generated by enum-gen.pl from $file */\n\n";

$linecount=0;
while ($ligne = <FILE>) {
	if ($ligne =~ /^GLAPI/ ) {
		while (! ($ligne =~ /\);/)) {
			chomp($ligne);
			$ligne .= " " . <FILE>;
		}
		$ligne =~ s/\t//g;
		$ligne =~ s/ \(/\(/;

		if ($ligne =~ /^GLAPI *(\w+).* G?L?APIENTRY *(\w+) *\(.*/) {
			$return_type = $1 ;
			$function_name = $2 ;
		} else {
			$return_type = "" ;
			$function_name = "" ;
		}

		$ligne =~ s/GLAPI *// ;
		$ligne =~ s/ *GLAPIENTRY// ;
		$ligne =~ s/ *APIENTRY// ;
		$ligne =~ s/;$// ;
		$function_name =~ tr/a-z/A-Z/;
		chomp($ligne);

		print "\t$prefix$function_name,\n";

		$linecount++;
	}
}
close(FILE);
print "/* Functions generated: $linecount */\n";
