/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#include <iostream>
#include "error.hpp"
#include "utils.hpp"

using namespace std;

int main(void)
{
  int retVal = 0;
  try {
    // Test replacement of substrings.
    string
      testString = "waaxyaayxawaayxyaaawwaaw",
      replaceResult = replaceAll( replaceAll( testString, "yxy", "zz" ),
                                  "w", "" );
    ERRORMACRO( replaceResult == "aaxyaayxaaazzaaaaa", Error, ,
                "Replacing \"yxy\" by \"zz\" and \"w\" by \"\" in \""
                << testString << "\" must not result in \""
                << replaceResult << "\"." );
                       
  } catch ( Error &e ) {
    cerr << e.what() << std::endl;
    retVal = 1;
  };
  return retVal;
}
