/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __STRX_HPP
#define __STRX_HPP

#include <iostream>
#include <util/XercesDefs.hpp>
#include <util/XMLString.hpp>
#include <Include/PlatformDefinitions.hpp>

#ifdef XERCES_HAS_CPP_NAMESPACE
using namespace XERCES_CPP_NAMESPACE;
#endif
#ifdef XALAN_HAS_CPP_NAMESPACE
using namespace XALAN_CPP_NAMESPACE;
#endif

/** @addtogroup XMLCpp
    @{ */
/** Conversion to and from unicode.
    @todo Replace StrX with XalanDOMString (if possible)
    @date Sat Feb 05 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
template <class To, class From>
class StrX
{
public:
  ///
  StrX( const From *aXMLStr )
     { buffer = XMLString::transcode( aXMLStr ); }
  ///
  StrX( const StrX<To,From> &aStrX ):
    buffer( XMLString::replicate( aStrX.buffer ) ) {}
  /// Destructor.
  virtual ~StrX(void) { free( buffer ); }
  ///
  int getLength(void) const
  { return XMLString::stringLen( buffer ); }
  ///
  int getSize(void) const { return ( getLength() + 1 ) * sizeof(To); }
  ///
  const To *getBuffer() const { return buffer; }
protected:
  ///
  To *buffer;
};

///
template <class To, class From>
inline std::ostream& operator<<( std::ostream& target, const StrX<To,From> &toDump)
{
  target << toDump.getBuffer();
  return target;
}

///@}

#endif
