/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __STATEMENT_HPP
#define __STATEMENT_HPP

#include "include.hpp"
#include <boost/smart_ptr.hpp>
#include "error.hpp"
#include "object.hpp"
#include "resultRow.hpp"

/** @addtogroup mysqlCpp
    @{ */
/** Abstract class for performing SQL queries and acquiring results.
    @see Database::execQuery
    @date Thu Mar 03 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class Statement: public Object
{
public:
  /// Empty constructor.
  Statement(void) {}
  /** Get number of result columns.
      @return Number of resulting columns of a SELECT query. <TT>0</TT> if
      there is none. */
  virtual int getNumCols(void) throw (Error) = 0;
  /** Meta information about column.
      @param col Number of column (between <TT>0</TT> and
      <TT>getNumCols()-1</TT>). */
  virtual std::string getColAttr( int col ) throw (Error) = 0;
  /// Fetch row of resulting row.
  virtual ResultRowPtr fetchRow(void) throw (Error) = 0;
};

///
typedef boost::shared_ptr< Statement > StatementPtr;

///@}

#endif
