/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#include <iostream>
#include "odbcWrap.hpp"

using namespace std;

void odbcWrap( SQLRETURN success, SQLSMALLINT handleType, SQLHANDLE handle )
  throw (Error)
{
  if ( !SQL_SUCCEEDED( success ) ) {
    if ( handleType != SQL_NULL_HANDLE ) {
      SQLCHAR sqlStatus[10];
      SQLINTEGER error;
      SQLSMALLINT length;
      SQLCHAR message[4096];
      SQLGetDiagRec( handleType, handle, 1, sqlStatus, &error, message,
                     sizeof(message), &length );
#ifndef NDEBUG
      cerr << (const char *)&message << endl;
#endif
      ERRORMACRO( false, Error, , "Could not allocate ODBC handle: "
                  << (const char *)&message );
    } else
      ERRORMACRO( false, Error, , "Error allocating ODBC handle" );
  };  
}
