/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __MYSQLSTATEMENT_HPP
#define __MYSQLSTATEMENT_HPP

#include "include.hpp"
#include <mysql/mysql.h>
#include <mysqlDatabase.hpp>
#include "statement.hpp"

/** @addtogroup mysqlCpp
    @{ */
/** Class for executing SQL query and querying results.
    Call \c MySQLDatabase::execQuery to acquire an instance of this class.
    @date Thu Mar 03 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class MySQLStatement: public Statement
{
public:
  /** Constructor requiring MySQL handle.
      Call \c MySQLDatabase::execQuery to acquire an instance of this class.
      @see MySQLDatabase::execQuery */
  MySQLStatement( MySQLDatabase *_database, const std::string &query )
    throw (Error);
  /// Destructor frees the statement handle.
  virtual ~MySQLStatement(void);
  ///
  virtual int getNumCols(void) throw (Error);
  ///
  virtual std::string getColAttr( int col ) throw (Error);
  ///
  virtual ResultRowPtr fetchRow(void) throw (Error);
protected:
  ///
  MySQLDatabase *database;
  ///
  MYSQL_RES *result;
  ///
  ResultRowPtr resultRow;
};

///
typedef boost::shared_ptr< MySQLStatement > MySQLStatementPtr;

///@}

#endif
